/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir.compiler_pass.opts;

import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import org.jruby.compiler.ir.CodeVersion;
import org.jruby.compiler.ir.IR_Class;
import org.jruby.compiler.ir.IR_Method;
import org.jruby.compiler.ir.IR_Module;
import org.jruby.compiler.ir.IR_Scope;
import org.jruby.compiler.ir.Operation;
import org.jruby.compiler.ir.compiler_pass.CompilerPass;
import org.jruby.compiler.ir.instructions.ASSERT_METHOD_VERSION_Instr;
import org.jruby.compiler.ir.instructions.CALL_Instr;
import org.jruby.compiler.ir.instructions.COPY_Instr;
import org.jruby.compiler.ir.instructions.IR_Instr;
import org.jruby.compiler.ir.operands.Array;
import org.jruby.compiler.ir.operands.Constant;
import org.jruby.compiler.ir.operands.Fixnum;
import org.jruby.compiler.ir.operands.Float;
import org.jruby.compiler.ir.operands.Label;
import org.jruby.compiler.ir.operands.Operand;
import org.jruby.compiler.ir.operands.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalOptimizationPass
implements CompilerPass {
    @Override
    public boolean isPreOrder() {
        return false;
    }

    @Override
    public void run(IR_Scope s) {
        if (!(s instanceof IR_Method)) {
            return;
        }
        IR_Method m = (IR_Method)s;
        Label deoptLabel = m.getNewLabel();
        HashMap<Operand, Operand> valueMap = new HashMap<Operand, Operand>();
        HashMap<String, CodeVersion> versionMap = new HashMap<String, CodeVersion>();
        ListIterator<IR_Instr> instrs = m.getInstrs().listIterator();
        while (instrs.hasNext()) {
            IR_Instr i = instrs.next();
            Operation iop = i._op;
            if (iop.startsBasicBlock()) {
                valueMap = new HashMap();
                versionMap = new HashMap();
            }
            Operand val = i.simplifyAndGetResult(valueMap);
            Variable res = i.getResult();
            if (val != null && res != null && res != val) {
                valueMap.put(res, val);
            } else if (iop.isCall()) {
                IR_Method rm;
                Operand v;
                val = null;
                CALL_Instr call2 = (CALL_Instr)i;
                Operand r = call2.getReceiver();
                if (!r.isConstant() && (v = (Operand)valueMap.get(r)) != null) {
                    r = v;
                }
                if ((rm = call2.getTargetMethodWithReceiver(r)) != null) {
                    Operand[] args2;
                    IR_Module rc = rm.getDefiningModule();
                    if (rc == IR_Class.getCoreClass("Fixnum")) {
                        args2 = call2.getCallArgs();
                        if (args2[1].isConstant()) {
                            this.addMethodGuard(rm, deoptLabel, versionMap, instrs);
                            val = ((Fixnum)r).computeValue(rm._name, (Constant)args2[1]);
                        }
                    } else if (rc == IR_Class.getCoreClass("Float")) {
                        args2 = call2.getCallArgs();
                        if (args2[1].isConstant()) {
                            this.addMethodGuard(rm, deoptLabel, versionMap, instrs);
                            val = ((Float)r).computeValue(rm._name, (Constant)args2[1]);
                        }
                    } else if (rc == IR_Class.getCoreClass("Array") && (args2 = call2.getCallArgs())[1] instanceof Fixnum && rm._name == "[]") {
                        this.addMethodGuard(rm, deoptLabel, versionMap, instrs);
                        val = ((Array)r).fetchCompileTimeArrayElement(((Fixnum)args2[1])._value.intValue(), false);
                    }
                    if (val != null) {
                        i.markDead();
                        instrs.add(new COPY_Instr(res, val));
                        valueMap.put(res, val);
                    }
                }
            }
            if (!iop.endsBasicBlock() && (!iop.isCall() || i.isDead())) continue;
            valueMap = new HashMap();
            versionMap = new HashMap();
        }
    }

    private void addMethodGuard(IR_Method m, Label deoptLabel, Map<String, CodeVersion> versionMap, ListIterator instrs) {
        String fullName = m.getFullyQualifiedName();
        CodeVersion knownVersion = versionMap.get(fullName);
        CodeVersion mVersion = m.getCodeVersionToken();
        if (knownVersion == null || knownVersion._version != mVersion._version) {
            instrs.add(new ASSERT_METHOD_VERSION_Instr(m.getDefiningModule(), m._name, m.getCodeVersionToken(), deoptLabel));
            versionMap.put(fullName, mVersion);
        }
    }
}

