/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.variable;

import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.embed.BiVariable;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

abstract class AbstractVariable
implements BiVariable {
    protected String name;
    protected Object javaObject = null;
    protected Class javaType = null;
    protected IRubyObject irubyObject = null;

    protected AbstractVariable(Ruby runtime2, String name2, Object ... values) {
        this.name = name2;
        this.updateJavaObject(runtime2, values[0]);
        if (values.length > 1) {
            this.javaType = (Class)values[1];
        } else if (this.javaObject != null) {
            this.javaType = values[0].getClass();
        }
    }

    protected void updateJavaObject(Ruby runtime2, Object javaObject) {
        this.javaObject = javaObject;
        this.irubyObject = JavaEmbedUtils.javaToRuby(runtime2, javaObject);
    }

    protected AbstractVariable(String name2, IRubyObject rubyObject) {
        this.name = name2;
        this.updateRubyObject(rubyObject);
    }

    protected void updateRubyObject(IRubyObject rubyObject) {
        if (rubyObject == null) {
            return;
        }
        this.irubyObject = rubyObject;
        Ruby rt = rubyObject.getRuntime();
        if (this.javaType != null) {
            this.javaObject = this.javaType.cast(JavaEmbedUtils.rubyToJava(rt, rubyObject, this.javaType));
        } else {
            this.javaObject = JavaEmbedUtils.rubyToJava(rubyObject);
            if (this.javaObject != null) {
                this.javaType = this.javaObject.getClass();
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public Object getJavaObject() {
        return this.javaObject;
    }

    public void setJavaObject(Ruby runtime2, Object javaObject) {
        this.updateJavaObject(runtime2, javaObject);
    }

    public IRubyObject getRubyObject() {
        return this.irubyObject;
    }

    public void setRubyObject(IRubyObject rubyObject) {
        this.updateRubyObject(rubyObject);
    }

    protected RubyModule getRubyClass(Ruby runtime2) {
        ThreadContext context = runtime2.getCurrentContext();
        StaticScope scope = context.getCurrentScope().getStaticScope();
        RubyModule rubyClass = scope.getModule();
        return rubyClass;
    }
}

