/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.exceptions;

import org.jruby.RubyInstanceConfig;
import org.jruby.internal.runtime.JumpTarget;

public class JumpException
extends RuntimeException {
    private static final long serialVersionUID = -228162532535826617L;
    public static final RetryJump RETRY_JUMP = new RetryJump();
    public static final RedoJump REDO_JUMP = new RedoJump();
    public static final SpecialJump SPECIAL_JUMP = new SpecialJump();

    public JumpException() {
    }

    public JumpException(String msg) {
        super(msg);
    }

    public JumpException(String msg, Throwable cause2) {
        super(msg, cause2);
    }

    public Throwable fillInStackTrace() {
        if (RubyInstanceConfig.JUMPS_HAVE_BACKTRACE) {
            return this.originalFillInStackTrace();
        }
        return this;
    }

    protected Throwable originalFillInStackTrace() {
        return super.fillInStackTrace();
    }

    public static class ReturnJump
    extends FlowControlException {
        public ReturnJump(JumpTarget t, Object v) {
            this.target = t;
            this.value = v;
        }
    }

    public static class SpecialJump
    extends FlowControlException {
    }

    public static class RedoJump
    extends FlowControlException {
    }

    public static class ThrowJump
    extends FlowControlException {
        public ThrowJump(JumpTarget t, Object v) {
            super(t, v);
        }
    }

    public static class RetryJump
    extends FlowControlException {
    }

    public static class NextJump
    extends FlowControlException {
        public NextJump(Object v) {
            super(null, v);
        }
    }

    public static class BreakJump
    extends FlowControlException {
        public BreakJump(JumpTarget t, Object v) {
            super(t, v);
        }
    }

    public static class FlowControlException
    extends JumpException {
        protected JumpTarget target;
        protected Object value;

        public FlowControlException() {
        }

        public FlowControlException(JumpTarget target, Object value2) {
            this.target = target;
            this.value = value2;
        }

        public JumpTarget getTarget() {
            return this.target;
        }

        public void setTarget(JumpTarget target) {
            this.target = target;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value2) {
            this.value = value2;
        }
    }
}

