/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.io;

import java.io.IOException;
import org.jruby.Ruby;
import org.jruby.util.ShellLauncher;
import org.jruby.util.io.BadDescriptorException;
import org.jruby.util.io.ChannelDescriptor;
import org.jruby.util.io.InvalidValueException;
import org.jruby.util.io.PipeException;
import org.jruby.util.io.Stream;

public class OpenFile {
    public static final int READABLE = 1;
    public static final int WRITABLE = 2;
    public static final int READWRITE = 3;
    public static final int APPEND = 64;
    public static final int CREATE = 128;
    public static final int BINMODE = 4;
    public static final int SYNC = 8;
    public static final int WBUF = 16;
    public static final int RBUF = 32;
    public static final int WSPLIT = 512;
    public static final int WSPLIT_INITIALIZED = 1024;
    public static final int SYNCWRITE = 10;
    private Stream mainStream;
    private Stream pipeStream;
    private int mode;
    private Process process;
    private int lineNumber = 0;
    private String path;
    private Finalizer finalizer;

    public Stream getMainStream() {
        return this.mainStream;
    }

    public synchronized void setMainStream(Stream mainStream) {
        this.mainStream = mainStream;
    }

    public Stream getPipeStream() {
        return this.pipeStream;
    }

    public synchronized void setPipeStream(Stream pipeStream) {
        this.pipeStream = pipeStream;
    }

    public Stream getWriteStream() {
        return this.pipeStream == null ? this.mainStream : this.pipeStream;
    }

    public int getMode() {
        return this.mode;
    }

    public String getModeAsString(Ruby runtime2) {
        String modeString = OpenFile.getStringFromMode(this.mode);
        if (modeString == null) {
            throw runtime2.newArgumentError("Illegal access modenum " + Integer.toOctalString(this.mode));
        }
        return modeString;
    }

    public static String getStringFromMode(int mode2) {
        if ((mode2 & 0x40) != 0) {
            if ((mode2 & 3) != 0) {
                return "ab+";
            }
            return "ab";
        }
        switch (mode2 & 3) {
            case 1: {
                return "rb";
            }
            case 2: {
                return "wb";
            }
            case 3: {
                if ((mode2 & 0x80) != 0) {
                    return "wb+";
                }
                return "rb+";
            }
        }
        return null;
    }

    public void checkReadable(Ruby runtime2) throws IOException, BadDescriptorException, PipeException, InvalidValueException {
        this.checkClosed(runtime2);
        if ((this.mode & 1) == 0) {
            throw runtime2.newIOError("not opened for reading");
        }
        if (!((this.mode & 0x10) == 0 && (this.mode & 0x2A) != 10 || this.mainStream.feof() || this.pipeStream != null)) {
            try {
                this.seek(0L, 1);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void seek(long offset2, int whence) throws IOException, InvalidValueException, PipeException, BadDescriptorException {
        this.flushBeforeSeek();
        this.getWriteStream().lseek(offset2, whence);
    }

    private void flushBeforeSeek() throws BadDescriptorException, IOException {
        if ((this.mode & 0x10) != 0) {
            this.fflush(this.getWriteStream());
        }
    }

    public void fflush(Stream stream) throws IOException, BadDescriptorException {
        int n;
        while ((n = stream.fflush()) == -1) {
        }
        this.mode &= 0xFFFFFFEF;
    }

    public void checkWritable(Ruby runtime2) throws IOException, BadDescriptorException, InvalidValueException, PipeException {
        this.checkClosed(runtime2);
        if ((this.mode & 2) == 0) {
            throw runtime2.newIOError("not opened for writing");
        }
        if ((this.mode & 0x20) != 0 && !this.mainStream.feof() && this.pipeStream == null) {
            try {
                this.seek(0L, 1);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.pipeStream == null) {
            this.mode &= 0xFFFFFFDF;
        }
    }

    public void checkClosed(Ruby runtime2) {
        if (this.mainStream == null && this.pipeStream == null) {
            throw runtime2.newIOError("closed stream");
        }
    }

    public boolean isBinmode() {
        return (this.mode & 4) != 0;
    }

    public boolean isOpen() {
        return this.mainStream != null || this.pipeStream != null;
    }

    public boolean isReadable() {
        return (this.mode & 1) != 0;
    }

    public boolean isWritable() {
        return (this.mode & 2) != 0;
    }

    public boolean isReadBuffered() {
        return (this.mode & 0x20) != 0;
    }

    public void setReadBuffered() {
        this.mode |= 0x20;
    }

    public boolean isWriteBuffered() {
        return (this.mode & 0x10) != 0;
    }

    public void setWriteBuffered() {
        this.mode |= 0x10;
    }

    public void setSync(boolean sync2) {
        this.mode = sync2 ? (this.mode |= 8) : (this.mode &= 0xFFFFFFF7);
    }

    public boolean isSync() {
        return (this.mode & 8) != 0;
    }

    public boolean areBothEOF() throws IOException, BadDescriptorException {
        return this.mainStream.feof() && (this.pipeStream == null || this.pipeStream.feof());
    }

    public void setMode(int modes) {
        this.mode = modes;
    }

    public Process getProcess() {
        return this.process;
    }

    public void setProcess(Process process) {
        this.process = process;
    }

    public long getPid() {
        return ShellLauncher.getPidFromProcess(this.process);
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path2) {
        this.path = path2;
    }

    public Finalizer getFinalizer() {
        return this.finalizer;
    }

    public void setFinalizer(Finalizer finalizer) {
        this.finalizer = finalizer;
    }

    public void cleanup(Ruby runtime2, boolean raise2) {
        if (this.finalizer != null) {
            this.finalizer.finalize(runtime2, raise2);
        } else {
            this.finalize(runtime2, raise2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize(Ruby runtime2, boolean raise2) {
        try {
            ChannelDescriptor main2 = null;
            ChannelDescriptor pipe2 = null;
            OpenFile openFile = this;
            synchronized (openFile) {
                block22: {
                    Stream ms;
                    Stream ps = this.pipeStream;
                    if (ps != null) {
                        pipe2 = ps.getDescriptor();
                        try {
                            ps.fflush();
                            ps.fclose();
                        }
                        finally {
                            this.pipeStream = null;
                            runtime2.unregisterDescriptor(pipe2.getFileno());
                        }
                    }
                    if ((ms = this.mainStream) != null) {
                        main2 = ms.getDescriptor();
                        try {
                            if (pipe2 == null && this.isWriteBuffered()) {
                                ms.fflush();
                            }
                            ms.fclose();
                        }
                        catch (BadDescriptorException bde) {
                            if (main2 == pipe2) {
                                break block22;
                            }
                            throw bde;
                        }
                        finally {
                            this.mainStream = null;
                            runtime2.unregisterDescriptor(main2.getFileno());
                        }
                    }
                }
            }
        }
        catch (IOException ex) {
            if (raise2) {
                throw runtime2.newIOErrorFromException(ex);
            }
        }
        catch (BadDescriptorException ex) {
            if (raise2) {
                throw runtime2.newErrnoEBADFError();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static interface Finalizer {
        public void finalize(Ruby var1, boolean var2);
    }
}

