/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.api.ejbjar;

import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJarMetadata;
import org.netbeans.modules.j2ee.ejbjar.EjbJarAccessor;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.spi.ejbjar.EjbJarImplementation;
import org.netbeans.modules.j2ee.spi.ejbjar.EjbJarImplementation2;
import org.netbeans.modules.j2ee.spi.ejbjar.EjbJarProvider;
import org.netbeans.modules.j2ee.spi.ejbjar.EjbJarsInProject;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EjbJar {
    private static final Lookup.Result<EjbJarProvider> implementations = Lookup.getDefault().lookup(new Lookup.Template(EjbJarProvider.class));
    private final EjbJarImplementation impl;
    private final EjbJarImplementation2 impl2;

    private EjbJar(EjbJarImplementation ejbJarImplementation, EjbJarImplementation2 ejbJarImplementation2) {
        assert (ejbJarImplementation != null && ejbJarImplementation2 == null || ejbJarImplementation == null && ejbJarImplementation2 != null);
        this.impl = ejbJarImplementation;
        this.impl2 = ejbJarImplementation2;
    }

    public static EjbJar getEjbJar(FileObject fileObject) {
        if (fileObject == null) {
            throw new NullPointerException("Passed null to EjbJar.getEjbJar(FileObject)");
        }
        for (EjbJarProvider ejbJarProvider : implementations.allInstances()) {
            EjbJar ejbJar = ejbJarProvider.findEjbJar(fileObject);
            if (ejbJar == null) continue;
            return ejbJar;
        }
        return null;
    }

    public static EjbJar[] getEjbJars(Project project) {
        EjbJar[] ejbJarArray;
        EjbJarsInProject ejbJarsInProject = (EjbJarsInProject)project.getLookup().lookup(EjbJarsInProject.class);
        if (ejbJarsInProject != null && (ejbJarArray = ejbJarsInProject.getEjbJars()) != null) {
            return ejbJarArray;
        }
        return new EjbJar[0];
    }

    public String getJ2eePlatformVersion() {
        if (this.impl2 != null) {
            return this.impl2.getJ2eeProfile().toPropertiesString();
        }
        return this.impl.getJ2eePlatformVersion();
    }

    public Profile getJ2eeProfile() {
        if (this.impl2 != null) {
            return this.impl2.getJ2eeProfile();
        }
        return Profile.fromPropertiesString((String)this.impl.getJ2eePlatformVersion());
    }

    public FileObject getDeploymentDescriptor() {
        if (this.impl2 != null) {
            return this.impl2.getDeploymentDescriptor();
        }
        return this.impl.getDeploymentDescriptor();
    }

    public FileObject[] getJavaSources() {
        if (this.impl2 != null) {
            return this.impl2.getJavaSources();
        }
        return this.impl.getJavaSources();
    }

    public FileObject getMetaInf() {
        if (this.impl2 != null) {
            return this.impl2.getMetaInf();
        }
        return this.impl.getMetaInf();
    }

    public MetadataModel<EjbJarMetadata> getMetadataModel() {
        if (this.impl2 != null) {
            return this.impl2.getMetadataModel();
        }
        return this.impl.getMetadataModel();
    }

    static {
        EjbJarAccessor.setDefault(new EjbJarAccessor(){

            public EjbJar createEjbJar(EjbJarImplementation ejbJarImplementation) {
                return new EjbJar(ejbJarImplementation, null);
            }

            public EjbJar createEjbJar(EjbJarImplementation2 ejbJarImplementation2) {
                return new EjbJar(null, ejbJarImplementation2);
            }
        });
    }
}

