/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.identity.server.manager.api;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.identity.profile.api.configurator.ServerProperties;
import org.netbeans.modules.identity.server.manager.api.ServerInstance;
import org.netbeans.modules.identity.server.manager.spi.ServerInstanceListener;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerManager {
    private static String DIR_CONFIGURED_SERVERS = "/Identity/ConfiguredServers";
    private static ServerManager instance;
    private Map<String, ServerInstance> instancesMap;
    private Set<ServerInstanceListener> listeners;

    private ServerManager() {
        this.init();
    }

    public static ServerManager getDefault() {
        if (instance == null) {
            instance = new ServerManager();
        }
        return instance;
    }

    public void init() {
        this.listeners = new HashSet<ServerInstanceListener>();
        this.instancesMap = new HashMap<String, ServerInstance>();
        FileObject fileObject = ServerManager.getConfiguredServersDirectory();
        FileObject[] fileObjectArray = fileObject.getChildren();
        for (int i = 0; i < fileObjectArray.length; ++i) {
            ServerInstance serverInstance = this.convertToServerInstance(fileObjectArray[i]);
            this.addServerInstanceInternal(serverInstance);
        }
    }

    public Collection<ServerInstance> getServerInstances() {
        return Collections.unmodifiableCollection(this.instancesMap.values());
    }

    public ServerInstance getServerInstance(ServerProperties serverProperties) {
        String string = serverProperties.getProperty("org.netbeans.modules.identity.profile.api.configurator.id");
        ServerInstance serverInstance = this.instancesMap.get(string);
        if (serverInstance == null) {
            serverInstance = this.createServerInstance(serverProperties);
            this.addServerInstance(serverInstance);
        }
        return serverInstance;
    }

    public ServerInstance getServerInstance(String string) {
        ServerProperties serverProperties = ServerProperties.getInstance((String)string);
        return this.getServerInstance(serverProperties);
    }

    private ServerInstance createServerInstance(ServerProperties serverProperties) {
        ServerInstance serverInstance = new ServerInstance();
        serverInstance.setID(serverProperties.getProperty("org.netbeans.modules.identity.profile.api.configurator.id"));
        serverInstance.setHost(serverProperties.getProperty("com.iplanet.am.server.host"));
        serverInstance.setPort(serverProperties.getProperty("com.iplanet.am.server.port"));
        serverInstance.setContextRoot(serverProperties.getProperty("org.netbeans.modules.identity.profile.api.configurator.contextroot"));
        serverInstance.setUserName(serverProperties.getProperty("com.sun.identity.agents.app.username"));
        serverInstance.setPassword(serverProperties.getProperty("com.iplanet.am.service.password"));
        return serverInstance;
    }

    public boolean addServerInstance(ServerInstance serverInstance) {
        this.addServerInstanceInternal(serverInstance);
        this.fireServerInstanceAdded(serverInstance);
        return true;
    }

    public void removeServerInstance(ServerInstance serverInstance) {
        try {
            this.removeInstanceFromFile(serverInstance);
            this.removeServerInstanceInternal(serverInstance);
            this.fireServerInstanceRemoved(serverInstance);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void addServerInstanceListener(ServerInstanceListener serverInstanceListener) {
        this.listeners.add(serverInstanceListener);
    }

    public void removeServerInstanceListener(ServerInstanceListener serverInstanceListener) {
        this.listeners.remove(serverInstanceListener);
    }

    public void fireServerInstanceAdded(ServerInstance serverInstance) {
        String string = serverInstance.getID();
        for (ServerInstanceListener serverInstanceListener : this.listeners) {
            serverInstanceListener.instanceAdded(string);
        }
    }

    public void fireServerInstanceRemoved(ServerInstance serverInstance) {
        String string = serverInstance.getID();
        for (ServerInstanceListener serverInstanceListener : this.listeners) {
            serverInstanceListener.instanceRemoved(string);
        }
    }

    private void addServerInstanceInternal(ServerInstance serverInstance) {
        this.instancesMap.put(serverInstance.getID(), serverInstance);
    }

    private void removeServerInstanceInternal(ServerInstance serverInstance) {
        this.instancesMap.remove(serverInstance.getID());
    }

    private boolean serverInstanceExists(ServerInstance serverInstance) {
        return this.instancesMap.get(serverInstance.getID()) != null;
    }

    private ServerInstance convertToServerInstance(FileObject fileObject) {
        ServerInstance serverInstance = new ServerInstance();
        serverInstance.setID((String)fileObject.getAttribute("id"));
        serverInstance.setHost((String)fileObject.getAttribute("host"));
        serverInstance.setPort((String)fileObject.getAttribute("port"));
        serverInstance.setContextRoot((String)fileObject.getAttribute("contextRoot"));
        serverInstance.setUserName((String)fileObject.getAttribute("userName"));
        serverInstance.setPassword((String)fileObject.getAttribute("password"));
        return serverInstance;
    }

    public synchronized void writeInstanceToFile(ServerInstance serverInstance) throws IOException {
        FileObject fileObject = ServerManager.getConfiguredServersDirectory();
        FileObject[] fileObjectArray = fileObject.getChildren();
        FileObject fileObject2 = null;
        String string = serverInstance.getID();
        if (string != null) {
            for (int i = 0; i < fileObjectArray.length; ++i) {
                if (!string.equals(fileObjectArray[i].getAttribute("id"))) continue;
                fileObject2 = fileObjectArray[i];
            }
        }
        if (fileObject2 == null) {
            String string2 = FileUtil.findFreeFileName((FileObject)fileObject, (String)"instance", null);
            fileObject2 = fileObject.createData(string2);
        }
        fileObject2.setAttribute("id", (Object)serverInstance.getID());
        fileObject2.setAttribute("host", (Object)serverInstance.getHost());
        fileObject2.setAttribute("port", (Object)serverInstance.getPort());
        fileObject2.setAttribute("contextRoot", (Object)serverInstance.getContextRoot());
        fileObject2.setAttribute("userName", (Object)serverInstance.getUserName());
        fileObject2.setAttribute("password", (Object)serverInstance.getPassword());
    }

    private void removeInstanceFromFile(ServerInstance serverInstance) throws IOException {
        FileObject fileObject = ServerManager.getConfiguredServersDirectory();
        FileObject[] fileObjectArray = fileObject.getChildren();
        FileObject fileObject2 = null;
        String string = serverInstance.getID();
        if (string != null) {
            for (int i = 0; i < fileObjectArray.length; ++i) {
                if (!string.equals(fileObjectArray[i].getAttribute("id"))) continue;
                fileObject2 = fileObjectArray[i];
            }
        }
        if (fileObject2 != null) {
            fileObject2.delete();
        }
    }

    public static FileObject getInstanceFileObject(String string) {
        FileObject fileObject = ServerManager.getConfiguredServersDirectory();
        FileObject[] fileObjectArray = fileObject.getChildren();
        for (int i = 0; i < fileObjectArray.length; ++i) {
            String string2 = (String)fileObjectArray[i].getAttribute("id");
            if (string2 == null || !string2.equals(string)) continue;
            return fileObjectArray[i];
        }
        return null;
    }

    private static FileObject getConfiguredServersDirectory() {
        return FileUtil.getConfigFile((String)DIR_CONFIGURED_SERVERS);
    }
}

