/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.dlg;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.netbeans.lib.ddl.DDLException;
import org.netbeans.lib.ddl.impl.Specification;
import org.netbeans.lib.ddl.util.PListReader;
import org.netbeans.modules.db.explorer.DbUtilities;
import org.netbeans.modules.db.explorer.dlg.AddTableColumnDialog;
import org.netbeans.modules.db.explorer.dlg.ColumnItem;
import org.netbeans.modules.db.explorer.dlg.CreateTableDDL;
import org.netbeans.modules.db.explorer.dlg.DataModel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotificationLineSupport;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class CreateTableDialog {
    Dialog dialog = null;
    JTextField dbnamefield;
    JTextField dbownerfield;
    JTable table;
    JButton addbtn;
    JButton delbtn;
    JButton editBtn;
    Specification spec;
    private DialogDescriptor descriptor = null;
    private NotificationLineSupport statusLine;
    private static Map dlgtab = null;
    private static final String filename = "org/netbeans/modules/db/resources/CreateTableDialog.plist";
    private static Logger LOGGER = Logger.getLogger(CreateTableDialog.class.getName());

    public static final Map getProperties() {
        if (dlgtab == null) {
            try {
                ClassLoader classLoader = CreateTableDialog.class.getClassLoader();
                InputStream inputStream = classLoader.getResourceAsStream(filename);
                if (inputStream == null) {
                    String string = NbBundle.getMessage(CreateTableDialog.class, (String)"EXC_UnableToOpenStream", (Object)filename);
                    throw new Exception(string);
                }
                PListReader pListReader = new PListReader(inputStream);
                dlgtab = pListReader.getData();
                inputStream.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                dlgtab = null;
            }
        }
        return dlgtab;
    }

    public CreateTableDialog(Specification specification, final String string) {
        this.spec = specification;
        try {
            JPanel jPanel = new JPanel();
            jPanel.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            jPanel.setLayout(gridBagLayout);
            jPanel.setMinimumSize(new Dimension(200, 100));
            JLabel jLabel = new JLabel();
            Mnemonics.setLocalizedText((JLabel)jLabel, (String)NbBundle.getMessage(CreateTableDialog.class, (String)"CreateTableName"));
            jLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CreateTableDialog.class, (String)"ACS_CreateTableNameA11yDesc"));
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            jPanel.add(jLabel);
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            this.dbnamefield = new JTextField(NbBundle.getMessage(CreateTableDialog.class, (String)"CreateTableUntitledName"), 10);
            this.dbnamefield.setToolTipText(NbBundle.getMessage(CreateTableDialog.class, (String)"ACS_CreateTableNameTextFieldA11yDesc"));
            this.dbnamefield.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CreateTableDialog.class, (String)"ACS_CreateTableNameTextFieldA11yName"));
            jLabel.setLabelFor(this.dbnamefield);
            gridBagLayout.setConstraints(this.dbnamefield, gridBagConstraints);
            jPanel.add(this.dbnamefield);
            this.dbnamefield.getDocument().addDocumentListener(new DocumentListener(){

                public void insertUpdate(DocumentEvent documentEvent) {
                    CreateTableDialog.this.validate();
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    CreateTableDialog.this.validate();
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                    CreateTableDialog.this.validate();
                }
            });
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 4;
            gridBagConstraints.gridheight = 3;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            this.table = new DataTable(new DataModel());
            this.table.setAutoResizeMode(0);
            this.table.setToolTipText(NbBundle.getMessage(CreateTableDialog.class, (String)"ACS_CreateTableColumnTableA11yDesc"));
            this.table.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CreateTableDialog.class, (String)"ACS_CreateTableColumnTableA11yName"));
            this.table.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CreateTableDialog.class, (String)"ACS_CreateTableColumnTableA11yDesc"));
            JScrollPane jScrollPane = new JScrollPane(this.table);
            jScrollPane.setBorder(new BevelBorder(1));
            gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
            jPanel.add(jScrollPane);
            this.table.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 2) {
                        CreateTableDialog.this.editBtn.doClick();
                    }
                }
            });
            this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    CreateTableDialog.this.validate();
                }
            });
            this.table.getModel().addTableModelListener(new TableModelListener(){

                public void tableChanged(TableModelEvent tableModelEvent) {
                    CreateTableDialog.this.validate();
                }
            });
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 11;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.gridx = 4;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.insets = new Insets(2, 8, 2, 2);
            JPanel jPanel2 = new JPanel();
            GridLayout gridLayout = new GridLayout(3, 1, 0, 5);
            jPanel2.setLayout(gridLayout);
            gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
            jPanel.add(jPanel2);
            this.addbtn = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)this.addbtn, (String)NbBundle.getMessage(CreateTableDialog.class, (String)"CreateTableAddButtonTitle"));
            this.addbtn.setToolTipText(NbBundle.getMessage(CreateTableDialog.class, (String)"ACS_CreateTableAddButtonTitleA11yDesc"));
            jPanel2.add(this.addbtn);
            this.addbtn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ColumnItem columnItem = AddTableColumnDialog.showDialog(CreateTableDialog.this.spec, null);
                    if (columnItem != null) {
                        DataModel dataModel = (DataModel)CreateTableDialog.this.table.getModel();
                        dataModel.addRow(columnItem);
                    }
                }
            });
            this.editBtn = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)this.editBtn, (String)NbBundle.getMessage(CreateTableDialog.class, (String)"CreateTableEditButtonTitle"));
            this.editBtn.setToolTipText(NbBundle.getMessage(CreateTableDialog.class, (String)"ACS_CreateTableEditButtonTitleA11yDesc"));
            jPanel2.add(this.editBtn);
            this.editBtn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ColumnItem columnItem;
                    ColumnItem columnItem2;
                    int n = CreateTableDialog.this.table.getSelectedRow();
                    if (n != -1 && (columnItem2 = AddTableColumnDialog.showDialog(CreateTableDialog.this.spec, columnItem = ((DataModel)CreateTableDialog.this.table.getModel()).getRow(n))) != null) {
                        DataModel dataModel = (DataModel)CreateTableDialog.this.table.getModel();
                        dataModel.removeRow(n);
                        dataModel.insertRow(n, columnItem2);
                    }
                }
            });
            this.delbtn = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)this.delbtn, (String)NbBundle.getMessage(CreateTableDialog.class, (String)"CreateTableRemoveButtonTitle"));
            this.delbtn.setToolTipText(NbBundle.getMessage(CreateTableDialog.class, (String)"ACS_CreateTableRemoveButtonTitleA11yDesc"));
            jPanel2.add(this.delbtn);
            this.delbtn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = CreateTableDialog.this.table.getSelectedRow();
                    if (n != -1) {
                        ((DataModel)CreateTableDialog.this.table.getModel()).removeRow(n);
                    }
                }
            });
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ActionEvent actionEvent2 = actionEvent;
                    if (actionEvent2.getSource() == DialogDescriptor.OK_OPTION) {
                        try {
                            final String string2 = CreateTableDialog.this.getTableName();
                            final DataModel dataModel = (DataModel)CreateTableDialog.this.table.getModel();
                            final Vector vector = dataModel.getData();
                            boolean bl = DbUtilities.doWithProgress(null, new Callable<Boolean>(){

                                @Override
                                public Boolean call() throws Exception {
                                    CreateTableDDL createTableDDL = new CreateTableDDL(CreateTableDialog.this.spec, string, string2);
                                    return createTableDDL.execute(vector, dataModel.getTablePrimaryKeys());
                                }
                            });
                            if (!bl) {
                                CreateTableDialog.this.dialog.setVisible(false);
                                CreateTableDialog.this.dialog.dispose();
                            }
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            Throwable throwable = invocationTargetException.getCause();
                            if (throwable instanceof DDLException) {
                                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)invocationTargetException.getMessage(), 0));
                            }
                            LOGGER.log(Level.INFO, null, throwable);
                            DbUtilities.reportError(NbBundle.getMessage(CreateTableDialog.class, (String)"ERR_UnableToCreateTable"), invocationTargetException.getMessage());
                        }
                    }
                }
            };
            jPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CreateTableDialog.class, (String)"ACS_CreateTableDialogA11yDesc"));
            this.descriptor = new DialogDescriptor((Object)jPanel, NbBundle.getMessage(CreateTableDialog.class, (String)"CreateTableDialogTitle"), true, actionListener);
            this.statusLine = this.descriptor.createNotificationLineSupport();
            Object[] objectArray = new Object[]{DialogDescriptor.CANCEL_OPTION};
            this.descriptor.setClosingOptions(objectArray);
            this.dialog = DialogDisplayer.getDefault().createDialog(this.descriptor);
            this.dialog.setResizable(true);
            this.validate();
        }
        catch (MissingResourceException missingResourceException) {
            missingResourceException.printStackTrace();
        }
    }

    public static boolean showDialogAndCreate(Specification specification, String string) {
        CreateTableDialog createTableDialog = new CreateTableDialog(specification, string);
        createTableDialog.dialog.setVisible(true);
        return createTableDialog.descriptor.getValue() == DialogDescriptor.OK_OPTION;
    }

    private String getTableName() {
        return this.dbnamefield.getText();
    }

    private void validate() {
        assert (this.statusLine != null) : "Notification status line not available";
        boolean bl = this.table.getSelectedRowCount() == 1;
        this.editBtn.setEnabled(bl);
        this.delbtn.setEnabled(bl);
        String string = this.getTableName();
        if (string == null || string.length() < 1) {
            this.statusLine.setInformationMessage(NbBundle.getMessage(CreateTableDialog.class, (String)"CreateTableMissingTableName"));
            this.updateOK(false);
            return;
        }
        if (this.table.getModel().getRowCount() == 0) {
            this.statusLine.setInformationMessage(NbBundle.getMessage(CreateTableDialog.class, (String)"CreateTableNoColumns"));
            this.updateOK(false);
            return;
        }
        this.statusLine.clearMessages();
        this.updateOK(true);
    }

    private void updateOK(boolean bl) {
        if (this.descriptor != null) {
            this.descriptor.setValid(bl);
        }
    }

    class DataTable
    extends JTable {
        static final long serialVersionUID = 1222037401669064863L;

        public DataTable(TableModel tableModel) {
            super(tableModel);
            this.setSurrendersFocusOnKeystroke(true);
            TableColumnModel tableColumnModel = this.getColumnModel();
            int n = tableModel.getColumnCount();
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                TableColumn tableColumn = tableColumnModel.getColumn(i);
                Map map = ColumnItem.getColumnProperty(i);
                tableColumn.setIdentifier(map.get("name"));
                String string = NbBundle.getMessage(CreateTableDialog.class, (String)("CreateTable_" + i));
                int n3 = new Double(this.getFontMetrics(this.getFont()).getStringBounds(string, this.getGraphics()).getWidth()).intValue() + 20;
                if (map.containsKey("width")) {
                    if ((Integer)map.get("width") < n3) {
                        tableColumn.setPreferredWidth(n3);
                    } else {
                        tableColumn.setPreferredWidth((Integer)map.get("width"));
                    }
                    int n4 = tableColumn.getPreferredWidth();
                }
                if (map.containsKey("minwidth")) {
                    if ((Integer)map.get("minwidth") < n3) {
                        tableColumn.setMinWidth(n3);
                    } else {
                        tableColumn.setMinWidth((Integer)map.get("minwidth"));
                    }
                }
                if (i >= 7) continue;
                n2 += tableColumn.getPreferredWidth();
            }
            n2 = Math.min(Math.max(n2, 380), Toolkit.getDefaultToolkit().getScreenSize().width - 100);
            this.setPreferredScrollableViewportSize(new Dimension(n2, 150));
        }
    }
}

