/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.node;

import org.netbeans.api.db.explorer.node.BaseNode;
import org.netbeans.api.db.explorer.node.NodeProvider;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.node.NodeDataLookup;
import org.netbeans.modules.db.explorer.node.NodeRegistry;
import org.netbeans.modules.db.metadata.model.api.Action;
import org.netbeans.modules.db.metadata.model.api.Column;
import org.netbeans.modules.db.metadata.model.api.ForeignKeyColumn;
import org.netbeans.modules.db.metadata.model.api.Metadata;
import org.netbeans.modules.db.metadata.model.api.MetadataElementHandle;
import org.netbeans.modules.db.metadata.model.api.MetadataModel;
import org.netbeans.modules.db.metadata.model.api.MetadataModelException;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ForeignKeyColumnNode
extends BaseNode {
    private static final String ICON = "org/netbeans/modules/db/resources/columnForeign.gif";
    private static final String FOLDER = "ForeignKeyColumn";
    private String name = "";
    private final MetadataElementHandle<ForeignKeyColumn> keyColumnHandle;
    private final DatabaseConnection connection = (DatabaseConnection)this.getLookup().lookup(DatabaseConnection.class);

    public static ForeignKeyColumnNode create(NodeDataLookup nodeDataLookup, NodeProvider nodeProvider) {
        ForeignKeyColumnNode foreignKeyColumnNode = new ForeignKeyColumnNode(nodeDataLookup, nodeProvider);
        foreignKeyColumnNode.setup();
        return foreignKeyColumnNode;
    }

    private ForeignKeyColumnNode(NodeDataLookup nodeDataLookup, NodeProvider nodeProvider) {
        super(nodeDataLookup, FOLDER, nodeProvider);
        this.keyColumnHandle = (MetadataElementHandle)this.getLookup().lookup(MetadataElementHandle.class);
    }

    protected void initialize() {
        boolean bl = !this.connection.getConnector().isDisconnected();
        MetadataModel metadataModel = this.connection.getMetadataModel();
        if (bl && metadataModel != null) {
            try {
                metadataModel.runReadAction((Action)new Action<Metadata>(){

                    public void run(Metadata metadata) {
                        ForeignKeyColumn foreignKeyColumn = (ForeignKeyColumn)ForeignKeyColumnNode.this.keyColumnHandle.resolve(metadata);
                        ForeignKeyColumnNode.this.name = foreignKeyColumn.getReferringColumn().getName() + " -> " + foreignKeyColumn.getReferredColumn().getParent().getName() + "." + foreignKeyColumn.getReferredColumn().getName();
                        ForeignKeyColumnNode.this.updateProperties(foreignKeyColumn);
                    }
                });
            }
            catch (MetadataModelException metadataModelException) {
                NodeRegistry.handleMetadataModelException(((Object)((Object)this)).getClass(), this.connection, metadataModelException, true);
            }
        }
    }

    private void updateProperties(ForeignKeyColumn foreignKeyColumn) {
        PropertySupport.Name name = new PropertySupport.Name((Node)this);
        this.addProperty((Node.Property)name);
        try {
            Column column = foreignKeyColumn.getReferredColumn();
            Column column2 = foreignKeyColumn.getReferringColumn();
            this.addProperty("PositionInFK", "PositionInFKDescription", Integer.class, false, foreignKeyColumn.getPosition());
            this.addProperty("ReferringFKSchema", "ReferringFKSchema", String.class, false, column2.getParent().getParent().getName());
            this.addProperty("ReferringFKTable", "ReferringFKTable", String.class, false, column2.getParent().getName());
            this.addProperty("ReferringFKColumn", "ReferringFKColumn", String.class, false, column2.getName());
            this.addProperty("ReferredFKSchema", "ReferredFKSchema", String.class, false, column.getParent().getParent().getName());
            this.addProperty("ReferredFKTable", "ReferredFKTable", String.class, false, column.getParent().getName());
            this.addProperty("ReferredFKColumn", "ReferredFKColumn", String.class, false, column.getName());
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
        }
    }

    public int getPosition() {
        MetadataModel metadataModel = this.connection.getMetadataModel();
        final int[] nArray = new int[1];
        try {
            metadataModel.runReadAction((Action)new Action<Metadata>(){

                public void run(Metadata metadata) {
                    ForeignKeyColumn foreignKeyColumn = (ForeignKeyColumn)ForeignKeyColumnNode.this.keyColumnHandle.resolve(metadata);
                    nArray[0] = foreignKeyColumn.getPosition();
                }
            });
        }
        catch (MetadataModelException metadataModelException) {
            NodeRegistry.handleMetadataModelException(((Object)((Object)this)).getClass(), this.connection, metadataModelException, true);
        }
        return nArray[0];
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.getName();
    }

    public String getIconBase() {
        return ICON;
    }

    public String getShortDescription() {
        return NbBundle.getMessage(ForeignKeyColumnNode.class, (String)"ND_Column");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(ForeignKeyColumnNode.class);
    }
}

