/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.node;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import org.netbeans.api.db.explorer.node.NodeProvider;
import org.netbeans.api.db.explorer.node.NodeProviderFactory;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.node.IndexColumnNode;
import org.netbeans.modules.db.explorer.node.NodeDataLookup;
import org.netbeans.modules.db.explorer.node.NodeRegistry;
import org.netbeans.modules.db.metadata.model.api.Action;
import org.netbeans.modules.db.metadata.model.api.Index;
import org.netbeans.modules.db.metadata.model.api.IndexColumn;
import org.netbeans.modules.db.metadata.model.api.Metadata;
import org.netbeans.modules.db.metadata.model.api.MetadataElement;
import org.netbeans.modules.db.metadata.model.api.MetadataElementHandle;
import org.netbeans.modules.db.metadata.model.api.MetadataModel;
import org.netbeans.modules.db.metadata.model.api.MetadataModelException;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

public class IndexColumnNodeProvider
extends NodeProvider {
    private final DatabaseConnection connection = (DatabaseConnection)this.getLookup().lookup(DatabaseConnection.class);
    private final MetadataElementHandle<Index> handle = (MetadataElementHandle)this.getLookup().lookup(MetadataElementHandle.class);

    public static NodeProviderFactory getFactory() {
        return FactoryHolder.FACTORY;
    }

    private IndexColumnNodeProvider(Lookup lookup) {
        super(lookup, new ColumnComparator());
    }

    protected synchronized void initialize() {
        final ArrayList<Node> arrayList = new ArrayList<Node>();
        boolean bl = !this.connection.getConnector().isDisconnected();
        MetadataModel metadataModel = this.connection.getMetadataModel();
        if (bl && metadataModel != null) {
            try {
                metadataModel.runReadAction((Action)new Action<Metadata>(){

                    public void run(Metadata metadata) {
                        Index index = (Index)IndexColumnNodeProvider.this.handle.resolve(metadata);
                        if (index != null) {
                            Collection collection = index.getColumns();
                            for (IndexColumn indexColumn : collection) {
                                MetadataElementHandle metadataElementHandle = MetadataElementHandle.create((MetadataElement)indexColumn);
                                Collection collection2 = IndexColumnNodeProvider.this.getNodes(metadataElementHandle);
                                if (collection2.size() > 0) {
                                    arrayList.addAll(collection2);
                                    continue;
                                }
                                NodeDataLookup nodeDataLookup = new NodeDataLookup();
                                nodeDataLookup.add(IndexColumnNodeProvider.this.connection);
                                nodeDataLookup.add(metadataElementHandle);
                                arrayList.add(IndexColumnNode.create(nodeDataLookup, IndexColumnNodeProvider.this));
                            }
                        }
                    }
                });
            }
            catch (MetadataModelException metadataModelException) {
                NodeRegistry.handleMetadataModelException(this.getClass(), this.connection, metadataModelException, true);
            }
        }
        this.setNodes(arrayList);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ColumnComparator
    implements Comparator<Node> {
        ColumnComparator() {
        }

        @Override
        public int compare(Node node, Node node2) {
            IndexColumnNode indexColumnNode = (IndexColumnNode)node;
            IndexColumnNode indexColumnNode2 = (IndexColumnNode)node2;
            int n = 1;
            if (indexColumnNode.getPosition() < indexColumnNode2.getPosition()) {
                n = -1;
            }
            return n;
        }
    }

    private static class FactoryHolder {
        static final NodeProviderFactory FACTORY = new NodeProviderFactory(){

            public IndexColumnNodeProvider createInstance(Lookup lookup) {
                IndexColumnNodeProvider indexColumnNodeProvider = new IndexColumnNodeProvider(lookup);
                return indexColumnNodeProvider;
            }
        };

        private FactoryHolder() {
        }
    }
}

