/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.node;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.db.explorer.node.BaseNode;
import org.netbeans.api.db.explorer.node.ChildNodeFactory;
import org.netbeans.api.db.explorer.node.NodeProvider;
import org.netbeans.lib.ddl.DDLException;
import org.netbeans.lib.ddl.impl.Specification;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.DatabaseConnector;
import org.netbeans.modules.db.explorer.action.RefreshAction;
import org.netbeans.modules.db.explorer.node.DDLHelper;
import org.netbeans.modules.db.explorer.node.NodeDataLookup;
import org.netbeans.modules.db.explorer.node.NodeRegistry;
import org.netbeans.modules.db.metadata.model.api.Action;
import org.netbeans.modules.db.metadata.model.api.Index;
import org.netbeans.modules.db.metadata.model.api.Metadata;
import org.netbeans.modules.db.metadata.model.api.MetadataElementHandle;
import org.netbeans.modules.db.metadata.model.api.MetadataModel;
import org.netbeans.modules.db.metadata.model.api.MetadataModelException;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexNode
extends BaseNode {
    private static final String ICONBASE = "org/netbeans/modules/db/resources/index.gif";
    private static final String FOLDER = "Index";
    private String name = "";
    private final MetadataElementHandle<Index> indexHandle;
    private final DatabaseConnection connection = (DatabaseConnection)this.getLookup().lookup(DatabaseConnection.class);

    public static IndexNode create(NodeDataLookup nodeDataLookup, NodeProvider nodeProvider) {
        IndexNode indexNode = new IndexNode(nodeDataLookup, nodeProvider);
        indexNode.setup();
        return indexNode;
    }

    private IndexNode(NodeDataLookup nodeDataLookup, NodeProvider nodeProvider) {
        super(new ChildNodeFactory((Lookup)nodeDataLookup), nodeDataLookup, FOLDER, nodeProvider);
        this.indexHandle = (MetadataElementHandle)this.getLookup().lookup(MetadataElementHandle.class);
    }

    @Override
    protected void initialize() {
        boolean bl = !this.connection.getConnector().isDisconnected();
        MetadataModel metadataModel = this.connection.getMetadataModel();
        if (bl && metadataModel != null) {
            try {
                metadataModel.runReadAction((Action)new Action<Metadata>(){

                    public void run(Metadata metadata) {
                        Index index = (Index)IndexNode.this.indexHandle.resolve(metadata);
                        IndexNode.this.name = index.getName();
                        IndexNode.this.updateProperties(index);
                    }
                });
            }
            catch (MetadataModelException metadataModelException) {
                NodeRegistry.handleMetadataModelException(((Object)((Object)this)).getClass(), this.connection, metadataModelException, true);
            }
        }
    }

    private void updateProperties(Index index) {
        PropertySupport.Name name = new PropertySupport.Name((Node)this);
        this.addProperty((Node.Property)name);
        this.addProperty("UniqueNoMnemonic", "UniqueDescription", Boolean.class, index.isUnique(), false);
    }

    public String getCatalogName() {
        return IndexNode.getCatalogName(this.connection, this.indexHandle);
    }

    public String getSchemaName() {
        return IndexNode.getSchemaName(this.connection, this.indexHandle);
    }

    public String getTableName() {
        return IndexNode.getTableName(this.connection, this.indexHandle);
    }

    public String getShortDescription() {
        return NbBundle.getMessage(IndexNode.class, (String)"ND_Index");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(IndexNode.class);
    }

    @Override
    public void destroy() {
        DatabaseConnector databaseConnector = this.connection.getConnector();
        String string = this.getTableName();
        String string2 = this.getSchemaName();
        String string3 = this.getCatalogName();
        if (string2 == null) {
            string2 = string3;
        }
        try {
            Specification specification = databaseConnector.getDatabaseSpecification();
            DDLHelper.deleteIndex(specification, string2, string, this.getName());
            Object object = this.getParentNode();
            if (object == null) {
                object = this;
            } else {
                Node node = object.getParentNode();
                if (node != null) {
                    object = node;
                }
            }
            ((RefreshAction)SystemAction.get(RefreshAction.class)).performAction(new Node[]{object});
        }
        catch (DDLException dDLException) {
            Logger.getLogger(IndexNode.class.getName()).log(Level.INFO, dDLException + " while deleting index " + this.getName());
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)dDLException.getMessage(), 0));
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
        }
    }

    @Override
    public boolean canDestroy() {
        DatabaseConnector databaseConnector = this.connection.getConnector();
        return databaseConnector.supportsCommand("DropIndexCommand");
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.getName();
    }

    @Override
    public String getIconBase() {
        return ICONBASE;
    }

    public static String getTableName(DatabaseConnection databaseConnection, final MetadataElementHandle<Index> metadataElementHandle) {
        MetadataModel metadataModel = databaseConnection.getMetadataModel();
        final String[] stringArray = new String[]{null};
        try {
            metadataModel.runReadAction((Action)new Action<Metadata>(){

                public void run(Metadata metadata) {
                    Index index = (Index)metadataElementHandle.resolve(metadata);
                    if (index != null) {
                        stringArray[0] = index.getParent().getName();
                    }
                }
            });
        }
        catch (MetadataModelException metadataModelException) {
            // empty catch block
        }
        return stringArray[0];
    }

    public static String getSchemaName(DatabaseConnection databaseConnection, final MetadataElementHandle<Index> metadataElementHandle) {
        MetadataModel metadataModel = databaseConnection.getMetadataModel();
        final String[] stringArray = new String[1];
        try {
            metadataModel.runReadAction((Action)new Action<Metadata>(){

                public void run(Metadata metadata) {
                    Index index = (Index)metadataElementHandle.resolve(metadata);
                    if (index != null) {
                        stringArray[0] = index.getParent().getParent().getName();
                    }
                }
            });
        }
        catch (MetadataModelException metadataModelException) {
            // empty catch block
        }
        return stringArray[0];
    }

    public static String getCatalogName(DatabaseConnection databaseConnection, final MetadataElementHandle<Index> metadataElementHandle) {
        MetadataModel metadataModel = databaseConnection.getMetadataModel();
        final String[] stringArray = new String[1];
        try {
            metadataModel.runReadAction((Action)new Action<Metadata>(){

                public void run(Metadata metadata) {
                    Index index = (Index)metadataElementHandle.resolve(metadata);
                    if (index != null) {
                        stringArray[0] = index.getParent().getParent().getParent().getName();
                    }
                }
            });
        }
        catch (MetadataModelException metadataModelException) {
            // empty catch block
        }
        return stringArray[0];
    }
}

