/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.modules.db.util.JdbcUrl;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DriverListUtil {
    private static List<JdbcUrl> urls = new LinkedList<JdbcUrl>();

    private DriverListUtil() {
    }

    private static void add(JdbcUrl jdbcUrl) {
        urls.add(jdbcUrl);
    }

    private static void add(String string, String string2, String string3, String string4) {
        urls.add(new JdbcUrl(string, string, string3, string2, string4));
    }

    private static void add(String string, String string2, String string3, String string4, boolean bl) {
        urls.add(new JdbcUrl(string, string, string3, string2, string4, bl));
    }

    private static void add(String string, String string2, String string3) {
        DriverListUtil.add(string, null, string2, string3);
    }

    private static void add(String string, String string2, String string3, boolean bl) {
        DriverListUtil.add(string, null, string2, string3, bl);
    }

    public static Set<String> getDrivers() {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (JdbcUrl jdbcUrl : urls) {
            treeSet.add(jdbcUrl.getClassName());
        }
        return treeSet;
    }

    public static List<JdbcUrl> getJdbcUrls(JDBCDriver jDBCDriver) {
        ArrayList<JdbcUrl> arrayList = new ArrayList<JdbcUrl>();
        JdbcUrl jdbcUrl = null;
        for (JdbcUrl jdbcUrl2 : urls) {
            if (!jdbcUrl2.getClassName().equals(jDBCDriver.getClassName())) continue;
            if (jdbcUrl2.getDriver() == null) {
                jdbcUrl2.setDriver(jDBCDriver);
                jdbcUrl2.clear();
                arrayList.add(jdbcUrl2);
                continue;
            }
            if (!DriverListUtil.isDriverEquals(jDBCDriver, jdbcUrl2.getDriver())) {
                jdbcUrl = new JdbcUrl(jDBCDriver, jdbcUrl2.getUrlTemplate(), jdbcUrl2.isParseUrl());
                arrayList.add(jdbcUrl);
                continue;
            }
            arrayList.add(jdbcUrl2);
        }
        if (jdbcUrl != null) {
            DriverListUtil.add(jdbcUrl);
        }
        if (arrayList.isEmpty()) {
            arrayList.add(new JdbcUrl(jDBCDriver));
        }
        return arrayList;
    }

    static List<JdbcUrl> getJdbcUrls() {
        return urls;
    }

    public static String getName(String string) {
        for (JdbcUrl jdbcUrl : urls) {
            if (!jdbcUrl.getClassName().equals(string)) continue;
            return jdbcUrl.getName();
        }
        return "";
    }

    public static String findFreeName(String string) {
        int n;
        Vector<String> vector = new Vector<String>();
        JDBCDriver[] jDBCDriverArray = JDBCDriverManager.getDefault().getDrivers();
        for (n = 0; n < jDBCDriverArray.length; ++n) {
            vector.add(jDBCDriverArray[n].getDisplayName());
        }
        if (vector.contains(string)) {
            n = 1;
            while (true) {
                String string2;
                if (!vector.contains(string2 = string + " (" + n + ")")) {
                    return string2;
                }
                ++n;
            }
        }
        return string;
    }

    private static boolean isDriverEquals(JDBCDriver jDBCDriver, JDBCDriver jDBCDriver2) {
        if (jDBCDriver == null && jDBCDriver2 == null) {
            return true;
        }
        if (jDBCDriver == null || jDBCDriver2 == null) {
            return false;
        }
        if (jDBCDriver == jDBCDriver2) {
            return true;
        }
        return jDBCDriver.getClassName().equals(jDBCDriver2.getClassName()) && jDBCDriver.getDisplayName().equals(jDBCDriver2.getDisplayName()) && jDBCDriver.getName().equals(jDBCDriver2.getName()) && Arrays.equals(jDBCDriver.getURLs(), jDBCDriver2.getURLs());
    }

    static {
        DriverListUtil.add("IBM DB2 (net)", "COM.ibm.db2.jdbc.net.DB2Driver", "jdbc:db2://<HOST>:<PORT>/<DB>");
        DriverListUtil.add("IBM DB2 (local)", "COM.ibm.db2.jdbc.app.DB2Driver", "jdbc:db2:<DB>");
        DriverListUtil.add("JDBC-ODBC Bridge", "sun.jdbc.odbc.JdbcOdbcDriver", "jdbc:odbc:<DB>");
        DriverListUtil.add("Microsoft SQL Server (Weblogic driver)", "weblogic.jdbc.mssqlserver4.Driver", "jdbc:weblogic:mssqlserver4:<DB>@<HOST>[:<PORT>]");
        DriverListUtil.add("PointBase", "Network Server", "com.pointbase.jdbc.jdbcUniversalDriver", "jdbc:pointbase://<HOST>[:<PORT>]/<DB>");
        DriverListUtil.add("PointBase", "Embedded", "com.pointbase.jdbc.jdbcUniversalDriver", "jdbc:pointbase://embedded[:<PORT>]/<DB>");
        DriverListUtil.add("PointBase", "Mobile Edition", "com.pointbase.jdbc.jdbcUniversalDriver", "jdbc:pointbase:<DB>");
        DriverListUtil.add("Cloudscape", "COM.cloudscape.core.JDBCDriver", "jdbc:cloudscape:<DB>");
        DriverListUtil.add("Cloudscape RMI", "RmiJdbc.RJDriver", "jdbc:rmi://<HOST>[:<PORT>]/jdbc:cloudscape:<DB>");
        DriverListUtil.add(NbBundle.getMessage(DriverListUtil.class, (String)"DRIVERNAME_JavaDbEmbedded"), "org.apache.derby.jdbc.EmbeddedDriver", "jdbc:derby:<DB>[;<ADDITIONAL>]", true);
        DriverListUtil.add(NbBundle.getMessage(DriverListUtil.class, (String)"DRIVERNAME_JavaDbNetwork"), "org.apache.derby.jdbc.ClientDriver", "jdbc:derby://<HOST>[:<PORT>]/<DB>[;<ADDITIONAL>]", true);
        DriverListUtil.add(NbBundle.getMessage(DriverListUtil.class, (String)"DRIVERNAME_DB2JCC"), "com.ibm.db2.jcc.DB2Driver", "jdbc:db2://<HOST>:<PORT>/<DB>[:<ADDITIONAL>]", true);
        DriverListUtil.add(NbBundle.getMessage(DriverListUtil.class, (String)"DRIVERNAME_DB2JCC"), NbBundle.getMessage(DriverListUtil.class, (String)"TYPE_IDS"), "com.ibm.db2.jcc.DB2Driver", "jdbc:ids://<HOST>:<PORT>/<DB>[:<ADDITIONAL>]", true);
        DriverListUtil.add(NbBundle.getMessage(DriverListUtil.class, (String)"DRIVERNAME_DB2JCC"), NbBundle.getMessage(DriverListUtil.class, (String)"TYPE_Cloudscape"), "com.ibm.db2.jcc.DB2Driver", "jdbc:db2j:net://<HOST>:<PORT>/<DB>[:<ADDITIONAL>]", true);
        DriverListUtil.add("Firebird (JCA/JDBC driver)", "org.firebirdsql.jdbc.FBDriver", "jdbc:firebirdsql:[//<HOST>[:<PORT>]/]<DB>");
        DriverListUtil.add("FirstSQL/J", "Enterprise Server Edition", "COM.FirstSQL.Dbcp.DbcpDriver", "jdbc:dbcp://<HOST>[:<PORT>]");
        DriverListUtil.add("FirstSQL/J", "Professional Edition", "COM.FirstSQL.Dbcp.DbcpDriver", "jdbc:dbcp://local");
        DriverListUtil.add("IBM DB2 (DataDirect Connect for JDBC)", "com.ddtek.jdbc.db2.DB2Driver", "jdbc:datadirect:db2://<HOST>[:<PORT>][;databaseName=<DB>]");
        DriverListUtil.add("IDS Server", "ids.sql.IDSDriver", "jdbc:ids://<HOST>[:<PORT>]/conn?dsn='<DSN>'");
        DriverListUtil.add("Informix Dynamic Server", "com.informix.jdbc.IfxDriver", "jdbc:informix-sqli://<HOST>[:<PORT>]/<DB>:INFORMIXSERVER=<SERVER_NAME>");
        DriverListUtil.add("Informix Dynamic Server (DataDirect Connect for JDBC)", "com.ddtek.jdbc.informix.InformixDriver", "jdbc:datadirect:informix://<HOST>[:<PORT>];informixServer=<SERVER_NAME>;databaseName=<DB>");
        DriverListUtil.add("InstantDB (v3.13 and earlier)", "jdbc.idbDriver", "jdbc:idb:<DB>");
        DriverListUtil.add("InstantDB (v3.14 and later)", "org.enhydra.instantdb.jdbc.idbDriver", "jdbc:idb:<DB>");
        DriverListUtil.add("Interbase (InterClient driver)", "interbase.interclient.Driver", "jdbc:interbase://<HOST>/<DB>");
        DriverListUtil.add("HSQLDB", "Server", "org.hsqldb.jdbcDriver", "jdbc:hsqldb:hsql://<HOST>[:<PORT>]");
        DriverListUtil.add("HSQLDB", "Embedded", "org.hsqldb.jdbcDriver", "jdbc:hsqldb:<DB>");
        DriverListUtil.add("HSQLDB", "Web Server", "org.hsqldb.jdbcDriver", "jdbc:hsqldb:http://<HOST>[:<PORT>]");
        DriverListUtil.add("HSQLDB", "In-Memory", "org.hsqldb.jdbcDriver", "jdbc:hsqldb:.");
        DriverListUtil.add("Hypersonic SQL (v1.2 and earlier)", "hSql.hDriver", "jdbc:HypersonicSQL:<DB>");
        DriverListUtil.add("Hypersonic SQL (v1.3 and later)", "org.hsql.jdbcDriver", "jdbc:HypersonicSQL:<DB>");
        DriverListUtil.add(NbBundle.getMessage(DriverListUtil.class, (String)"DRIVERNAME_JTDS"), NbBundle.getMessage(DriverListUtil.class, (String)"TYPE_ForSQLServer"), "net.sourceforge.jtds.jdbc.Driver", "jdbc:jtds:sqlserver://<HOST>[:<PORT>][/<DB>][;<ADDITIONAL>]", true);
        DriverListUtil.add(NbBundle.getMessage(DriverListUtil.class, (String)"DRIVERNAME_JTDS"), NbBundle.getMessage(DriverListUtil.class, (String)"TYPE_ForSybase"), "net.sourceforge.jtds.jdbc.Driver", "jdbc:jtds:sybase://<HOST>[:<PORT>][/<DB>][;<ADDITIONAL>]", true);
        DriverListUtil.add("Mckoi SQL Database", "Server", "com.mckoi.JDBCDriver", "jdbc:mckoi://<HOST>[:<PORT>]");
        DriverListUtil.add("Mckoi SQL Database", "Embedded", "com.mckoi.JDBCDriver", "jdbc:mckoi:local://<DB>");
        DriverListUtil.add("Microsoft SQL Server (DataDirect Connect for JDBC)", "com.ddtek.jdbc.sqlserver.SQLServerDriver", "jdbc:datadirect:sqlserver://<HOST>[:<PORT>][;databaseName=<DB>]");
        DriverListUtil.add("Microsoft SQL Server (JTurbo driver)", "com.ashna.jturbo.driver.Driver", "jdbc:JTurbo://<HOST>:<PORT>/<DB>");
        DriverListUtil.add("Microsoft SQL Server (Sprinta driver)", "com.inet.tds.TdsDriver", "jdbc:inetdae:<HOST>[:<PORT>]?database=<DB>");
        DriverListUtil.add("Microsoft SQL Server 2000 (Microsoft driver)", "com.microsoft.jdbc.sqlserver.SQLServerDriver", "jdbc:microsoft:sqlserver://<HOST>[:<PORT>][;DatabaseName=<DB>]");
        DriverListUtil.add(NbBundle.getMessage(DriverListUtil.class, (String)"DRIVERNAME_MSSQL2005"), "com.microsoft.sqlserver.jdbc.SQLServerDriver", "jdbc:sqlserver://[<HOST>[\\<INSTANCE>][:<PORT>]][;databaseName=<DB>][;<ADDITIONAL>]", true);
        DriverListUtil.add(NbBundle.getMessage(DriverListUtil.class, (String)"DRIVERNAME_MySQL"), "com.mysql.jdbc.Driver", "jdbc:mysql://[<HOST>[:<PORT>]][/<DB>][?<ADDITIONAL>]", true);
        DriverListUtil.add("MySQL (MM.MySQL driver)", "org.gjt.mm.mysql.Driver", "jdbc:mysql://<HOST>[:<PORT>]/<DB>");
        DriverListUtil.add(NbBundle.getMessage(DriverListUtil.class, (String)"DRIVERNAME_OracleThin"), NbBundle.getMessage(DriverListUtil.class, (String)"TYPE_SID"), "oracle.jdbc.OracleDriver", "jdbc:oracle:thin:@<HOST>:<PORT>:<SID>[?<ADDITIONAL>]", true);
        DriverListUtil.add(NbBundle.getMessage(DriverListUtil.class, (String)"DRIVERNAME_OracleThin"), NbBundle.getMessage(DriverListUtil.class, (String)"TYPE_Service"), "oracle.jdbc.OracleDriver", "jdbc:oracle:thin:@//<HOST>:<PORT>/<SERVICE>[?<ADDITIONAL>]", true);
        DriverListUtil.add(NbBundle.getMessage(DriverListUtil.class, (String)"DRIVERNAME_OracleThin"), NbBundle.getMessage(DriverListUtil.class, (String)"TYPE_TNSName"), "oracle.jdbc.OracleDriver", "jdbc:oracle:thin:@<TNSNAME>[?<ADDITIONAL>]", true);
        DriverListUtil.add(NbBundle.getMessage(DriverListUtil.class, (String)"DRIVERNAME_OracleOCI"), "OCI8 " + NbBundle.getMessage(DriverListUtil.class, (String)"TYPE_SID"), "oracle.jdbc.driver.OracleDriver", "jdbc:oracle:oci8:@<HOST>:<PORT>:<SID>[?<ADDITIONAL>]", true);
        DriverListUtil.add(NbBundle.getMessage(DriverListUtil.class, (String)"DRIVERNAME_OracleOCI"), "OCI8 " + NbBundle.getMessage(DriverListUtil.class, (String)"TYPE_Service"), "oracle.jdbc.driver.OracleDriver", "jdbc:oracle:oci8:@//<HOST>:<PORT>/<SERVICE>[?<ADDITIONAL>]", true);
        DriverListUtil.add(NbBundle.getMessage(DriverListUtil.class, (String)"DRIVERNAME_OracleOCI"), NbBundle.getMessage(DriverListUtil.class, (String)"TYPE_TNSName"), "oracle.jdbc.driver.OracleDriver", "jdbc:oracle:oci:@<TNSNAME>[?<ADDITIONAL>]", true);
        DriverListUtil.add(NbBundle.getMessage(DriverListUtil.class, (String)"DRIVERNAME_OracleOCI"), NbBundle.getMessage(DriverListUtil.class, (String)"TYPE_SID"), "oracle.jdbc.driver.OracleDriver", "jdbc:oracle:oci:@<HOST>:<PORT>:<SID>[?<ADDITIONAL>]", true);
        DriverListUtil.add(NbBundle.getMessage(DriverListUtil.class, (String)"DRIVERNAME_OracleOCI"), NbBundle.getMessage(DriverListUtil.class, (String)"TYPE_Service"), "oracle.jdbc.driver.OracleDriver", "jdbc:oracle:oci:@//<HOST>:<PORT>/<SERVICE>[?<ADDITIONAL>]", true);
        DriverListUtil.add("Oracle (DataDirect Connect for JDBC)", "com.ddtek.jdbc.oracle.OracleDriver", "jdbc:datadirect:oracle://<HOST>[:<PORT>];SID=<SID>");
        DriverListUtil.add("PostgreSQL (v6.5 and earlier)", "postgresql.Driver", "jdbc:postgresql:[//<HOST>[:<PORT>]/]<DB>[?<ADDITIONAL>]");
        DriverListUtil.add(NbBundle.getMessage(DriverListUtil.class, (String)"DRIVERNAME_PostgreSQL"), "org.postgresql.Driver", "jdbc:postgresql:[//<HOST>[:<PORT>]/]<DB>[?<ADDITIONAL>]", true);
        DriverListUtil.add("Quadcap Embeddable Database", "com.quadcap.jdbc.JdbcDriver", "jdbc:qed:<DB>");
        DriverListUtil.add("Sybase (jConnect 4.2 and earlier)", "com.sybase.jdbc.SybDriver", "jdbc:sybase:Tds:<HOST>[:<PORT>]");
        DriverListUtil.add("Sybase (jConnect 5.2)", "com.sybase.jdbc2.jdbc.SybDriver", "jdbc:sybase:Tds:<HOST>[:<PORT>]");
        DriverListUtil.add("Sybase (DataDirect Connect for JDBC)", "com.ddtek.jdbc.sybase.SybaseDriver", "jdbc:datadirect:sybase://<HOST>[:<PORT>][;databaseName=<DB>]");
        DriverListUtil.add("Microsoft SQL Server Driver", "com.sun.sql.jdbc.sqlserver.SQLServerDriver", "jdbc:sun:sqlserver://<HOST>[:<PORT>]");
        DriverListUtil.add("DB2 Driver", "com.sun.sql.jdbc.db2.DB2Driver", "jdbc:sun:db2://<HOST>[:<PORT>];databaseName=<DB>");
        DriverListUtil.add("Oracle Driver", "com.sun.sql.jdbc.oracle.OracleDriver", "jdbc:sun:oracle://<HOST>[:<PORT>][;SID=<SID>]");
        DriverListUtil.add("Sybase Driver", "com.sun.sql.jdbc.sybase.SybaseDriver", "jdbc:sun:sybase://<HOST>[:<PORT]");
    }
}

