/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.perfan.stack.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.dlight.core.stack.api.Function;
import org.netbeans.modules.dlight.core.stack.api.FunctionCall;
import org.netbeans.modules.dlight.core.stack.api.FunctionCallWithMetric;
import org.netbeans.modules.dlight.core.stack.api.FunctionMetric;
import org.netbeans.modules.dlight.perfan.stack.impl.FunctionImpl;
import org.netbeans.modules.dlight.spi.SourceFileInfoProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionCallImpl
extends FunctionCallWithMetric {
    private final Map<FunctionMetric, Object> metrics;
    private final long ref;
    private String displayedName = null;
    private SourceFileInfoProvider.SourceFileInfo sourceInfo = null;
    private static final Pattern FUNCTION_PATTERN = Pattern.compile("\\s+(.+?)(?:\\s+\\+\\s+0x([0-9a-fA-F]+))?(?:,\\s+line\\s+(\\d+)\\s+in\\s+\"(.+)\")?");

    public FunctionCallImpl(FunctionImpl functionImpl, long l, Map<FunctionMetric, Object> map) {
        super((Function)functionImpl, l);
        this.ref = functionImpl.getRef();
        this.metrics = Collections.unmodifiableMap(map);
        this.updateDisplayedName();
    }

    public synchronized void setSourceFileInfo(SourceFileInfoProvider.SourceFileInfo sourceFileInfo) {
        this.sourceInfo = sourceFileInfo;
        this.updateDisplayedName();
    }

    public long getFunctionRefID() {
        return this.ref;
    }

    public synchronized String getSourceFile() {
        return this.sourceInfo == null ? null : this.sourceInfo.getFileName();
    }

    public synchronized String getDisplayedName() {
        return this.displayedName;
    }

    public Object getMetricValue(FunctionMetric functionMetric) {
        return this.metrics.get(functionMetric);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getFunction().toString());
        stringBuilder.append(" [ ");
        for (FunctionMetric functionMetric : this.metrics.keySet()) {
            stringBuilder.append(functionMetric.getMetricDisplayedName()).append(" == ");
            stringBuilder.append(this.metrics.get(functionMetric)).append("; ");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof FunctionCallImpl)) {
            return false;
        }
        return this.ref == ((FunctionCallImpl)((Object)object)).ref;
    }

    public int hashCode() {
        int n = 7;
        n = 97 * n + (int)(this.ref ^ this.ref >>> 32);
        return n;
    }

    public boolean hasMetric(String string) {
        for (FunctionMetric functionMetric : this.metrics.keySet()) {
            if (!functionMetric.getMetricID().equals(string)) continue;
            return true;
        }
        return false;
    }

    public Object getMetricValue(String string) {
        for (FunctionMetric functionMetric : this.metrics.keySet()) {
            if (!functionMetric.getMetricID().equals(string)) continue;
            return this.metrics.get(functionMetric);
        }
        return null;
    }

    private synchronized void updateDisplayedName() {
        StringBuilder stringBuilder = new StringBuilder(this.getFunction().getSignature());
        if (this.sourceInfo != null) {
            String string = this.sourceInfo.getFileName();
            int n = this.sourceInfo.getLine();
            stringBuilder.append("; ");
            stringBuilder.append(new File(string).getName());
            if (n > 0) {
                stringBuilder.append(':').append(n);
            }
        }
        if (stringBuilder.length() == 0) {
            stringBuilder.append(super.getDisplayedName());
        }
        this.displayedName = stringBuilder.toString();
    }

    public static List<FunctionCall> parseStack(ListIterator<String> listIterator) {
        ArrayList<FunctionCall> arrayList = new ArrayList<FunctionCall>();
        while (listIterator.hasNext()) {
            String string = listIterator.next().replace("Stack:", "      ");
            if (8 <= string.length() - string.trim().length()) {
                arrayList.add(FunctionCallImpl.parseFunctionCall(string));
                continue;
            }
            listIterator.previous();
            break;
        }
        Collections.reverse(arrayList);
        return arrayList;
    }

    private static FunctionCall parseFunctionCall(String string) {
        Matcher matcher = FUNCTION_PATTERN.matcher(string);
        if (!matcher.matches()) {
            return null;
        }
        FunctionImpl functionImpl = new FunctionImpl(matcher.group(1), matcher.group(1).hashCode());
        int n = -1;
        if (matcher.group(3) != null) {
            try {
                n = Integer.parseInt(matcher.group(3));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        FunctionCallImpl functionCallImpl = new FunctionCallImpl(functionImpl, n, new HashMap<FunctionMetric, Object>());
        if (matcher.group(4) != null) {
            functionCallImpl.setSourceFileInfo(new SourceFileInfoProvider.SourceFileInfo((CharSequence)matcher.group(4), n, 0));
        }
        return functionCallImpl;
    }
}

