/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.completion.completors;

import java.io.IOException;
import java.util.ArrayList;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeKind;
import org.netbeans.modules.spring.api.Action;
import org.netbeans.modules.spring.api.beans.model.SpringBean;
import org.netbeans.modules.spring.api.beans.model.SpringBeans;
import org.netbeans.modules.spring.api.beans.model.SpringConfigModel;
import org.netbeans.modules.spring.beans.completion.CompletionContext;
import org.netbeans.modules.spring.beans.completion.completors.JavaMethodCompletor;
import org.netbeans.modules.spring.beans.editor.SpringXMLConfigEditorUtils;
import org.netbeans.modules.spring.java.Public;
import org.netbeans.modules.spring.java.Static;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FactoryMethodCompletor
extends JavaMethodCompletor {
    private Static staticFlag = Static.YES;

    public FactoryMethodCompletor(int n) {
        super(n);
    }

    @Override
    protected Public getPublicFlag(CompletionContext completionContext) {
        return Public.DONT_CARE;
    }

    @Override
    protected Static getStaticFlag(CompletionContext completionContext) {
        return this.staticFlag;
    }

    @Override
    protected int getArgCount(CompletionContext completionContext) {
        return -1;
    }

    @Override
    protected String getTypeName(CompletionContext completionContext) {
        Node node = completionContext.getTag();
        SpringBean springBean = SpringXMLConfigEditorUtils.getMergedBean(SpringXMLConfigEditorUtils.getTagAttributes(node), completionContext.getFileObject());
        if (springBean == null) {
            return null;
        }
        final String[] stringArray = new String[]{springBean.getClassName()};
        if (springBean.getFactoryBean() != null) {
            final String string = springBean.getFactoryBean();
            FileObject fileObject = completionContext.getFileObject();
            SpringConfigModel springConfigModel = SpringConfigModel.forFileObject(fileObject);
            if (springConfigModel == null) {
                return null;
            }
            try {
                springConfigModel.runReadAction(new Action<SpringBeans>(){

                    @Override
                    public void run(SpringBeans springBeans) {
                        SpringBean springBean = springBeans.findBean(string);
                        if (springBean == null) {
                            stringArray[0] = null;
                            return;
                        }
                        stringArray[0] = springBean.getClassName();
                    }
                });
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
                stringArray[0] = null;
            }
            this.staticFlag = Static.NO;
        }
        return stringArray[0];
    }

    @Override
    protected Iterable<? extends Element> filter(Iterable<? extends Element> iterable) {
        ArrayList<ExecutableElement> arrayList = new ArrayList<ExecutableElement>();
        for (Element element : iterable) {
            ExecutableElement executableElement = (ExecutableElement)element;
            if (executableElement.getReturnType().getKind() == TypeKind.VOID) continue;
            arrayList.add(executableElement);
        }
        return arrayList;
    }
}

