/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.refactoring;

import java.io.CharConversionException;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.spring.api.beans.model.Location;
import org.netbeans.modules.spring.api.beans.model.SpringBean;
import org.netbeans.modules.spring.api.beans.model.SpringConfigModel;
import org.netbeans.modules.spring.beans.refactoring.AttributeValueFinder;
import org.netbeans.modules.spring.beans.refactoring.Occurrences;
import org.netbeans.modules.xml.text.syntax.XMLSyntaxSupport;
import org.openide.filesystems.FileObject;
import org.openide.text.PositionBounds;
import org.openide.text.PositionRef;
import org.openide.xml.XMLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaElementRefFinder {
    private final SpringConfigModel.DocumentAccess docAccess;
    private final XMLSyntaxSupport syntaxSupport;

    public JavaElementRefFinder(SpringConfigModel.DocumentAccess documentAccess) {
        this.docAccess = documentAccess;
        BaseDocument baseDocument = (BaseDocument)documentAccess.getDocument();
        this.syntaxSupport = (XMLSyntaxSupport)baseDocument.getSyntaxSupport();
    }

    public void addOccurrences(Matcher matcher, List<Occurrences.Occurrence> list) throws BadLocationException {
        List<SpringBean> list2 = this.docAccess.getSpringBeans().getFileBeans(this.docAccess.getFileObject()).getBeans();
        for (SpringBean springBean : list2) {
            Occurrences.Occurrence occurrence;
            String string;
            String string2 = springBean.getClassName();
            if (string2 == null || (string = matcher.accept(string2)) == null || (occurrence = this.createClassOccurrence(string, springBean)) == null) continue;
            list.add(occurrence);
        }
    }

    private Occurrences.Occurrence createClassOccurrence(String string, SpringBean springBean) throws BadLocationException {
        Location location = springBean.getLocation();
        if (location == null) {
            return null;
        }
        int n = location.getOffset();
        if (n == -1) {
            return null;
        }
        AttributeValueFinder attributeValueFinder = new AttributeValueFinder(this.syntaxSupport, n);
        if (!attributeValueFinder.find("class")) {
            return null;
        }
        int n2 = attributeValueFinder.getFoundOffset();
        String string2 = attributeValueFinder.getValue();
        int n3 = string2.indexOf(string);
        if (n3 == -1) {
            return null;
        }
        String string3 = this.createClassDisplayText(attributeValueFinder, string2, n3, string.length());
        PositionRef positionRef = this.docAccess.createPositionRef(n2 + n3, Position.Bias.Forward);
        PositionRef positionRef2 = this.docAccess.createPositionRef(n2 + n3 + string.length(), Position.Bias.Backward);
        return new JavaElementRefOccurrence(string3, this.docAccess.getFileObject(), new PositionBounds(positionRef, positionRef2));
    }

    private String createClassDisplayText(AttributeValueFinder attributeValueFinder, String string, int n, int n2) throws BadLocationException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("&lt;bean");
        String string2 = this.getAttributeWithValue(attributeValueFinder, "id");
        if (string2 == null) {
            string2 = this.getAttributeWithValue(attributeValueFinder, "name");
        }
        if (string2 != null) {
            stringBuilder.append(' ');
            stringBuilder.append(string2);
        }
        String string3 = this.escapeAttrValue(string.substring(0, n));
        String string4 = this.escapeAttrValue(string.substring(n, n + n2));
        String string5 = this.escapeAttrValue(string.substring(n + n2, string.length()));
        if (string3 != null && string4 != null && string5 != null) {
            stringBuilder.append(" class=");
            stringBuilder.append(string3).append("<b>").append(string4).append("</b>").append(string5);
        }
        return stringBuilder.toString();
    }

    private String getAttributeWithValue(AttributeValueFinder attributeValueFinder, String string) throws BadLocationException {
        if (attributeValueFinder.find(string)) {
            return string + "=" + this.escapeAttrValue(attributeValueFinder.getValue());
        }
        return null;
    }

    private String escapeAttrValue(String string) {
        try {
            return XMLUtil.toAttributeValue((String)string);
        }
        catch (CharConversionException charConversionException) {
            return null;
        }
    }

    private static final class JavaElementRefOccurrence
    extends Occurrences.Occurrence {
        private final String displayText;

        JavaElementRefOccurrence(String string, FileObject fileObject, PositionBounds positionBounds) {
            super(fileObject, positionBounds);
            this.displayText = string;
        }

        public String getDisplayText() {
            return this.displayText;
        }
    }

    public static interface Matcher {
        public String accept(String var1);
    }
}

