/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.api.languages.CompletionItem;
import org.netbeans.api.languages.LanguageDefinitionNotFoundException;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.Language;
import org.netbeans.modules.languages.LanguagesManager;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.CompletionUtilities;
import org.openide.ErrorManager;
import org.openide.util.ImageUtilities;

public class CompletionSupport
implements CompletionItem {
    private static Map<String, ImageIcon> icons = new HashMap<String, ImageIcon>();
    private String text;
    private String filledPrefix;
    private String description;
    private String rightText;
    private String icon;
    private int priority;
    private int processKeyEventOffset;
    private String confirmChars;
    private CompletionItem.Type type;

    private static ImageIcon getCIcon(String string) {
        if (string == null) {
            string = "org/netbeans/modules/languages/resources/node.gif";
        }
        if (!icons.containsKey(string)) {
            Image image = ImageUtilities.loadImage((String)string);
            if (image == null) {
                image = ImageUtilities.loadImage((String)"org/netbeans/modules/languages/resources/node.gif");
            }
            icons.put(string, new ImageIcon(image));
        }
        return icons.get(string);
    }

    CompletionSupport(org.netbeans.api.languages.CompletionItem completionItem, String string) {
        this.text = completionItem.getText();
        this.filledPrefix = string;
        this.rightText = completionItem.getLibrary();
        this.priority = completionItem.getPriority();
        String string2 = "000000";
        this.type = completionItem.getType();
        if (this.type == null) {
            this.type = CompletionItem.Type.FIELD;
        }
        boolean bl = false;
        String string3 = completionItem.getText();
        switch (this.type) {
            case KEYWORD: {
                string2 = "000099";
                this.icon = "/org/netbeans/modules/languages/resources/keyword.jpg";
                bl = true;
                break;
            }
            case INTERFACE: {
                string2 = "560000";
                this.icon = "/org/netbeans/modules/editor/resources/completion/interface.png";
                break;
            }
            case CLASS: {
                string2 = "560000";
                this.icon = "/org/netbeans/modules/editor/resources/completion/class_16.png ";
                break;
            }
            case FIELD: {
                this.icon = "/org/netbeans/modules/editor/resources/completion/field_16.png";
                break;
            }
            case METHOD: {
                this.icon = "/org/netbeans/modules/editor/resources/completion/method_16.png";
                bl = true;
                string3 = string3 + "()";
                break;
            }
            case CONSTRUCTOR: {
                this.icon = "/org/netbeans/modules/editor/resources/completion/constructor_16.png";
                bl = true;
                string3 = string3 + "()";
                break;
            }
            case CONSTANT: {
                this.icon = "/org/netbeans/modules/editor/resources/completion/field_static_16.png";
                break;
            }
            case LOCAL: {
                this.icon = "/org/netbeans/modules/editor/resources/completion/localVariable.gif";
                break;
            }
            case PARAMETER: {
                this.icon = "/org/netbeans/modules/editor/resources/completion/localVariable.gif";
            }
        }
        this.description = completionItem.getDescription() == null ? "<html>" + (bl ? "<b>" : "") + "<font color=#" + string2 + ">" + string3 + "</font>" + (bl ? "</b>" : "") + "</html>" : "<html>" + (bl ? "<b>" : "") + "<font color=#" + string2 + ">" + string3 + ": </font>" + (bl ? "</b>" : "") + "<font color=#000000> " + completionItem.getDescription() + "</font></html>";
    }

    CompletionSupport(String string, String string2, String string3, String string4, String string5, int n) {
        this.text = string;
        this.filledPrefix = string2;
        this.description = string3;
        this.rightText = string4;
        this.icon = string5;
        this.priority = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void defaultAction(JTextComponent jTextComponent) {
        NbEditorDocument nbEditorDocument = (NbEditorDocument)jTextComponent.getDocument();
        int n = jTextComponent.getCaret().getDot();
        boolean bl = this.type == CompletionItem.Type.METHOD || this.type == CompletionItem.Type.CONSTRUCTOR;
        try {
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)nbEditorDocument);
            if (nbEditorDocument instanceof NbEditorDocument) {
                nbEditorDocument.readLock();
            }
            String string = null;
            try {
                TokenSequence tokenSequence;
                TokenSequence tokenSequence2 = tokenHierarchy.tokenSequence();
                while (true) {
                    tokenSequence2.move(n - 1);
                    if (!tokenSequence2.moveNext() || (tokenSequence = tokenSequence2.embedded()) == null) break;
                    tokenSequence2 = tokenSequence;
                }
                tokenSequence = tokenSequence2.token();
                String string2 = tokenSequence != null ? tokenSequence.id().name() : "";
                String string3 = tokenSequence2.language().mimeType();
                Language language = LanguagesManager.getDefault().getLanguage(string3);
                List<Feature> list = language.getFeatureList().getFeatures("COMPLETION", string2);
                Iterator<Feature> iterator = list.iterator();
                string = bl ? this.text + "()" : this.text;
                boolean bl2 = false;
                while (iterator.hasNext()) {
                    Feature feature = iterator.next();
                    String string4 = CompletionSupport.getCompletionType(feature, string2);
                    if (string4 != "complete") continue;
                    string = string.substring(n - tokenSequence2.offset());
                    bl2 = true;
                    break;
                }
                if (!bl2 && this.filledPrefix != null) {
                    string = string.substring(this.filledPrefix.length());
                }
            }
            finally {
                if (nbEditorDocument instanceof NbEditorDocument) {
                    nbEditorDocument.readUnlock();
                }
            }
            nbEditorDocument.insertString(n, string, null);
            if (bl) {
                jTextComponent.setCaretPosition(jTextComponent.getCaret().getDot() - 1);
            }
            this.processKeyEventOffset = n + string.length();
        }
        catch (BadLocationException badLocationException) {
            ErrorManager.getDefault().notify((Throwable)badLocationException);
        }
        catch (LanguageDefinitionNotFoundException languageDefinitionNotFoundException) {
            // empty catch block
        }
        Completion.get().hideAll();
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getID() == 400) {
            char c = keyEvent.getKeyChar();
            JTextComponent jTextComponent = (JTextComponent)keyEvent.getSource();
            if (this.confirmChars == null) {
                this.confirmChars = this.getConfirmChars(jTextComponent);
            }
            if (this.confirmChars.indexOf(c) != -1) {
                if (c != '.') {
                    Completion.get().hideDocumentation();
                    Completion.get().hideCompletion();
                }
                NbEditorDocument nbEditorDocument = (NbEditorDocument)jTextComponent.getDocument();
                try {
                    this.defaultAction(jTextComponent);
                    nbEditorDocument.insertString(this.processKeyEventOffset, Character.toString(c), null);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                if (c == '.') {
                    Completion.get().showCompletion();
                }
                keyEvent.consume();
            }
        }
    }

    public int getPreferredWidth(Graphics graphics, Font font) {
        return CompletionUtilities.getPreferredWidth((String)this.description, (String)this.rightText, (Graphics)graphics, (Font)font);
    }

    public void render(Graphics graphics, Font font, Color color, Color color2, int n, int n2, boolean bl) {
        CompletionUtilities.renderHtml((ImageIcon)CompletionSupport.getCIcon(this.icon), (String)this.description, (String)this.rightText, (Graphics)graphics, (Font)font, (Color)color, (int)n, (int)n2, (boolean)bl);
    }

    public CompletionTask createDocumentationTask() {
        return null;
    }

    public CompletionTask createToolTipTask() {
        return null;
    }

    public boolean instantSubstitution(JTextComponent jTextComponent) {
        this.defaultAction(jTextComponent);
        return true;
    }

    public int getSortPriority() {
        return this.priority;
    }

    public CharSequence getSortText() {
        return this.text;
    }

    public CharSequence getInsertPrefix() {
        return this.text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getConfirmChars(JTextComponent jTextComponent) {
        NbEditorDocument nbEditorDocument = (NbEditorDocument)jTextComponent.getDocument();
        StringBuffer stringBuffer = new StringBuffer();
        int n = jTextComponent.getCaret().getDot();
        try {
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)nbEditorDocument);
            if (nbEditorDocument instanceof NbEditorDocument) {
                nbEditorDocument.readLock();
            }
            try {
                String string;
                Object object = tokenHierarchy.tokenSequence();
                if (object.isEmpty()) {
                    String string2 = "";
                    return string2;
                }
                while (true) {
                    object.move(n - 1);
                    if (!object.moveNext()) {
                        string = "";
                        return string;
                    }
                    string = object.embedded();
                    if (string == null) break;
                    object = string;
                }
                string = object.token();
                String string3 = string.id().name();
                String string4 = object.language().mimeType();
                Language language = LanguagesManager.getDefault().getLanguage(string4);
                List<Feature> list = language.getFeatureList().getFeatures("COMPLETION", string3);
                Iterator<Feature> iterator = list.iterator();
                while (iterator.hasNext()) {
                    Feature feature = iterator.next();
                    String string5 = (String)feature.getValue("confirmChars");
                    if (string5 == null) continue;
                    stringBuffer.append(string5);
                }
                return stringBuffer.toString();
            }
            finally {
                if (nbEditorDocument instanceof NbEditorDocument) {
                    nbEditorDocument.readUnlock();
                }
            }
        }
        catch (LanguageDefinitionNotFoundException languageDefinitionNotFoundException) {
            // empty catch block
        }
        return stringBuffer.toString();
    }

    private static String getCompletionType(Feature feature, String string) {
        String string2 = (String)feature.getValue("type");
        if (string2 != null) {
            return string2;
        }
        if (string.indexOf("whitespace") >= 0 || string.indexOf("operator") >= 0 || string.indexOf("separator") >= 0) {
            return "insert";
        }
        if (string.indexOf("comment") >= 0) {
            return "append";
        }
        return "complete";
    }
}

