/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.marker;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.marker.Mark;
import org.netbeans.lib.profiler.marker.Marker;
import org.netbeans.lib.profiler.results.cpu.marking.MarkMapping;

public class MethodMarker
implements Marker {
    private static Logger LOGGER = Logger.getLogger(MethodMarker.class.getName());
    private Map markMap = new HashMap();

    public MarkMapping[] getMappings() {
        ArrayList<MarkMapping> arrayList = new ArrayList<MarkMapping>();
        for (ClientUtils.SourceCodeSelection sourceCodeSelection : this.markMap.keySet()) {
            sourceCodeSelection.setMarkerMethod(true);
            arrayList.add(new MarkMapping(sourceCodeSelection, (Mark)this.markMap.get(sourceCodeSelection)));
        }
        return arrayList.toArray(new MarkMapping[arrayList.size()]);
    }

    public Mark[] getMarks() {
        return new HashSet(this.markMap.values()).toArray(new Mark[0]);
    }

    public void addMethodMark(String string, String string2, String string3, Mark mark) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("Marking method " + string + "#" + string2 + ":" + string3 + " with " + mark.getId());
        }
        this.markMap.put(new ClientUtils.SourceCodeSelection(string, string2, string3), mark);
    }

    public void removeMethodMark(String string, String string2, String string3) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("Unmarking method " + string + "#" + string2 + ":" + string3);
        }
        this.markMap.remove(new ClientUtils.SourceCodeSelection(string, string2, string3));
    }

    public void resetMethodMarks() {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("Unmarking all methods");
        }
        this.markMap.clear();
    }
}

