/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.actions;

import java.util.HashSet;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.refactoring.actions.RefactoringActionsProvider;
import org.netbeans.modules.cnd.refactoring.hints.infrastructure.Utilities;
import org.netbeans.modules.cnd.refactoring.spi.CsmActionsImplementationProvider;
import org.netbeans.modules.cnd.refactoring.support.CsmContext;
import org.netbeans.modules.cnd.refactoring.support.CsmRefactoringUtils;
import org.netbeans.modules.cnd.refactoring.ui.ChangeParametersUI;
import org.netbeans.modules.cnd.refactoring.ui.EncapsulateFieldUI;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

public class CsmRefactoringActionsProvider
extends CsmActionsImplementationProvider {
    public boolean canChangeParameters(Lookup lookup) {
        HashSet hashSet = new HashSet(lookup.lookupAll(Node.class));
        if (hashSet.size() != 1) {
            return false;
        }
        CsmObject csmObject = CsmRefactoringUtils.findContextObject(lookup);
        if (RefactoringActionsProvider.isFromEditor(lookup)) {
            CsmContext csmContext = CsmContext.create(lookup);
            if (csmContext != null) {
                CsmFunction csmFunction = csmContext.getEnclosingFunction();
                return csmFunction != null && !CsmKindUtilities.isDestructor((CsmObject)csmFunction);
            }
            return false;
        }
        return CsmKindUtilities.isFunction((CsmObject)csmObject);
    }

    public void doChangeParameters(Lookup lookup) {
        Runnable runnable = RefactoringActionsProvider.isFromEditor(lookup) ? new RefactoringActionsProvider.TextComponentTask(lookup){

            protected RefactoringUI createRefactoringUI(CsmObject csmObject, CsmContext csmContext) {
                return ChangeParametersUI.create(csmObject, csmContext);
            }
        } : new RefactoringActionsProvider.NodeToElementTask(lookup){

            protected RefactoringUI createRefactoringUI(CsmObject csmObject) {
                return ChangeParametersUI.create(csmObject, null);
            }
        };
        runnable.run();
    }

    public boolean canEncapsulateFields(Lookup lookup) {
        HashSet hashSet = new HashSet(lookup.lookupAll(Node.class));
        if (hashSet.size() != 1) {
            return false;
        }
        CsmObject csmObject = CsmRefactoringUtils.findContextObject(lookup);
        if (RefactoringActionsProvider.isFromEditor(lookup)) {
            CsmContext csmContext = CsmContext.create(lookup);
            if (csmContext != null) {
                CsmClass csmClass = Utilities.extractEnclosingClass(csmContext);
                return csmClass != null;
            }
            return false;
        }
        return CsmKindUtilities.isField((CsmObject)csmObject) || CsmKindUtilities.isClass((CsmObject)csmObject);
    }

    public void doEncapsulateFields(Lookup lookup) {
        Runnable runnable = RefactoringActionsProvider.isFromEditor(lookup) ? new RefactoringActionsProvider.TextComponentTask(lookup){

            protected RefactoringUI createRefactoringUI(CsmObject csmObject, CsmContext csmContext) {
                return EncapsulateFieldUI.create(csmObject, csmContext);
            }
        } : new RefactoringActionsProvider.NodeToElementTask(lookup){

            protected RefactoringUI createRefactoringUI(CsmObject csmObject) {
                return EncapsulateFieldUI.create(csmObject, null);
            }
        };
        runnable.run();
    }
}

