/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.plugins;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmField;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmVisibility;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.refactoring.api.EncapsulateFieldRefactoring;
import org.netbeans.modules.cnd.refactoring.api.EncapsulateFieldsRefactoring;
import org.netbeans.modules.cnd.refactoring.hints.infrastructure.Utilities;
import org.netbeans.modules.cnd.refactoring.plugins.CsmModificationRefactoringPlugin;
import org.netbeans.modules.cnd.refactoring.plugins.EncapsulateFieldRefactoringPlugin;
import org.netbeans.modules.cnd.refactoring.support.CsmContext;
import org.netbeans.modules.cnd.refactoring.support.CsmRefactoringUtils;
import org.netbeans.modules.cnd.refactoring.support.GeneratorUtils;
import org.netbeans.modules.cnd.refactoring.support.ModificationResult;
import org.netbeans.modules.cnd.refactoring.ui.EncapsulateFieldPanel;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.ProgressEvent;
import org.netbeans.modules.refactoring.api.ProgressListener;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EncapsulateFieldsPlugin
extends CsmModificationRefactoringPlugin {
    private static final int FAST_CHECK_PARAMETERS = 1;
    private static final int CHECK_PARAMETERS = 2;
    private List<EncapsulateFieldRefactoringPlugin> refactorings;
    private final EncapsulateFieldsRefactoring refactoring;
    private Collection<CsmField> referencedFields = new ArrayList<CsmField>();
    private CsmClass enclosingClass;
    private ProgressListener listener = new ProgressListener(){

        public void start(ProgressEvent progressEvent) {
            EncapsulateFieldsPlugin.this.fireProgressListenerStart(progressEvent.getOperationType(), progressEvent.getCount());
        }

        public void step(ProgressEvent progressEvent) {
            EncapsulateFieldsPlugin.this.fireProgressListenerStep();
        }

        public void stop(ProgressEvent progressEvent) {
            EncapsulateFieldsPlugin.this.fireProgressListenerStop();
        }
    };

    public EncapsulateFieldsPlugin(EncapsulateFieldsRefactoring encapsulateFieldsRefactoring) {
        super(encapsulateFieldsRefactoring);
        this.refactoring = encapsulateFieldsRefactoring;
    }

    @Override
    public Problem checkParameters() {
        return this.validation(2);
    }

    @Override
    public Problem fastCheckParameters() {
        Collection<EncapsulateFieldsRefactoring.EncapsulateFieldInfo> collection = this.refactoring.getRefactorFields();
        if (collection.isEmpty()) {
            return new Problem(true, NbBundle.getMessage(EncapsulateFieldsPlugin.class, (String)"ERR_EncapsulateNothingSelected"));
        }
        this.initRefactorings(collection, this.refactoring.getMethodModifiers(), this.refactoring.getFieldModifiers(), this.refactoring.isAlwaysUseAccessors(), this.refactoring.isMethodInline());
        return this.validation(1);
    }

    private CsmObject getRefactoredCsmElement() {
        CsmContext csmContext;
        CsmObject csmObject = this.getStartReferenceObject();
        if (csmObject == null && (csmContext = this.getEditorContext()) != null && !CsmKindUtilities.isField((CsmObject)(csmObject = csmContext.getObjectUnderOffset()))) {
            csmObject = Utilities.extractEnclosingClass(this.getEditorContext());
        }
        return csmObject;
    }

    @Override
    public Problem preCheck() {
        Problem problem = null;
        this.fireProgressListenerStart(1, 4);
        Collection<EncapsulateFieldsRefactoring.EncapsulateFieldInfo> collection = this.refactoring.getRefactorFields();
        CsmObject csmObject = this.getRefactoredCsmElement();
        problem = collection.isEmpty() ? this.isResovledElement(csmObject) : null;
        this.fireProgressListenerStep();
        if (problem != null) {
            return problem;
        }
        CsmObject csmObject2 = CsmRefactoringUtils.getReferencedElement(csmObject);
        this.initReferencedObjects(csmObject2, collection);
        this.fireProgressListenerStep();
        if (this.enclosingClass == null) {
            problem = EncapsulateFieldsPlugin.createProblem(problem, true, EncapsulateFieldsPlugin.getString("ERR_EncapsulateWrongType"));
            return problem;
        }
        problem = this.checkIfModificationPossible(problem, (CsmObject)this.enclosingClass, "", "");
        this.fireProgressListenerStop();
        if (collection.isEmpty()) {
            for (CsmMember csmMember : this.enclosingClass.getMembers()) {
                if (!CsmKindUtilities.isField((CsmObject)csmMember)) continue;
                return null;
            }
            return new Problem(true, EncapsulateFieldsPlugin.getString("ERR_EncapsulateNoFields", ((Object)this.enclosingClass.getQualifiedName()).toString()));
        }
        return null;
    }

    private static String getString(String string) {
        return NbBundle.getMessage(EncapsulateFieldsPlugin.class, (String)string);
    }

    private static String getString(String string, String string2) {
        return NbBundle.getMessage(EncapsulateFieldsPlugin.class, (String)string, (Object)string2);
    }

    private void initRefactorings(Collection<EncapsulateFieldsRefactoring.EncapsulateFieldInfo> collection, Set<CsmVisibility> set, Set<CsmVisibility> set2, boolean bl, boolean bl2) {
        this.refactorings = new ArrayList<EncapsulateFieldRefactoringPlugin>(collection.size());
        CsmFile[] csmFileArray = null;
        for (EncapsulateFieldsRefactoring.EncapsulateFieldInfo encapsulateFieldInfo : collection) {
            if (csmFileArray == null) {
                csmFileArray = GeneratorUtils.getDeclarationDefinitionFiles(encapsulateFieldInfo.getField().getContainingClass());
            }
            EncapsulateFieldRefactoring encapsulateFieldRefactoring = new EncapsulateFieldRefactoring(encapsulateFieldInfo.getField(), csmFileArray[0], csmFileArray[1]);
            encapsulateFieldRefactoring.setGetterName(encapsulateFieldInfo.getGetterName());
            encapsulateFieldRefactoring.setSetterName(encapsulateFieldInfo.getSetterName());
            encapsulateFieldRefactoring.setMethodModifiers(set);
            encapsulateFieldRefactoring.setFieldModifiers(set2);
            encapsulateFieldRefactoring.setAlwaysUseAccessors(bl);
            encapsulateFieldRefactoring.setMethodInline(bl2);
            encapsulateFieldRefactoring.setDefaultGetter(encapsulateFieldInfo.getDefaultGetter());
            encapsulateFieldRefactoring.setDefaultSetter(encapsulateFieldInfo.getDefaultSetter());
            encapsulateFieldRefactoring.getContext().add(this.refactoring.getContext().lookup(EncapsulateFieldPanel.InsertPoint.class));
            encapsulateFieldRefactoring.getContext().add(this.refactoring.getContext().lookup(EncapsulateFieldPanel.Documentation.class));
            encapsulateFieldRefactoring.getContext().add(this.refactoring.getContext().lookup(EncapsulateFieldPanel.SortBy.class));
            this.refactorings.add(new EncapsulateFieldRefactoringPlugin(encapsulateFieldRefactoring));
        }
    }

    private Problem validation(int n) {
        Problem problem = null;
        for (EncapsulateFieldRefactoringPlugin encapsulateFieldRefactoringPlugin : this.refactorings) {
            Problem problem2 = null;
            switch (n) {
                case 1: {
                    problem2 = encapsulateFieldRefactoringPlugin.fastCheckParameters();
                    break;
                }
                case 2: {
                    problem2 = encapsulateFieldRefactoringPlugin.preCheck();
                    problem = EncapsulateFieldsPlugin.chainProblems(problem, problem2);
                    if (problem != null && problem.isFatal()) {
                        return problem;
                    }
                    problem2 = encapsulateFieldRefactoringPlugin.checkParameters();
                    encapsulateFieldRefactoringPlugin.addProgressListener(this.listener);
                }
            }
            if ((problem = EncapsulateFieldsPlugin.chainProblems(problem, problem2)) == null || !problem.isFatal()) continue;
            return problem;
        }
        return problem;
    }

    private static Problem chainProblems(Problem problem, Problem problem2) {
        if (problem == null) {
            return problem2;
        }
        if (problem2 == null) {
            return problem;
        }
        if (problem2.isFatal()) {
            problem2.setNext(problem);
            return problem2;
        }
        Problem problem3 = problem;
        while (problem3.getNext() != null) {
            problem3 = problem3.getNext();
        }
        problem3.setNext(problem2);
        return problem;
    }

    @Override
    protected Collection<CsmFile> getRefactoredFiles() {
        if (this.enclosingClass == null) {
            return Collections.emptySet();
        }
        HashSet<CsmFile> hashSet = new HashSet<CsmFile>();
        CsmFile csmFile = CsmRefactoringUtils.getCsmFile((CsmObject)this.enclosingClass);
        if (this.refactoring.isAlwaysUseAccessors()) {
            Collection<CsmProject> collection = CsmRefactoringUtils.getRelatedCsmProjects((CsmObject)this.enclosingClass, null);
            CsmProject[] csmProjectArray = collection.toArray(new CsmProject[collection.size()]);
            this.refactoring.getContext().add((Object)csmProjectArray);
            hashSet.addAll(this.getRelevantFiles(csmFile, (CsmObject)this.enclosingClass, this.refactoring));
        } else {
            hashSet.add(csmFile);
            if (!this.refactoring.isMethodInline()) {
                Collection<CsmFunction> collection = GeneratorUtils.getAllOutOfClassMethodDefinitions(this.enclosingClass);
                for (CsmFunction csmFunction : collection) {
                    CsmFile csmFile2 = CsmRefactoringUtils.getCsmFile((CsmObject)csmFunction);
                    if (csmFile2 == null) continue;
                    hashSet.add(csmFile2);
                }
            }
        }
        return hashSet;
    }

    private void initReferencedObjects(CsmObject csmObject, Collection<EncapsulateFieldsRefactoring.EncapsulateFieldInfo> collection) {
        this.referencedFields = new ArrayList<CsmField>(collection.size());
        if (!collection.isEmpty()) {
            for (EncapsulateFieldsRefactoring.EncapsulateFieldInfo encapsulateFieldInfo : collection) {
                CsmField csmField = encapsulateFieldInfo.getField();
                this.referencedFields.add(csmField);
                if (this.enclosingClass != null) continue;
                this.enclosingClass = csmField.getContainingClass();
            }
        } else if (csmObject != null) {
            if (CsmKindUtilities.isClass((CsmObject)csmObject)) {
                this.enclosingClass = (CsmClass)csmObject;
            } else if (CsmKindUtilities.isField((CsmObject)csmObject)) {
                this.enclosingClass = ((CsmField)csmObject).getContainingClass();
            }
        }
    }

    @Override
    protected void processFile(CsmFile csmFile, ModificationResult modificationResult, AtomicReference<Problem> atomicReference) {
        for (EncapsulateFieldRefactoringPlugin encapsulateFieldRefactoringPlugin : this.refactorings) {
            encapsulateFieldRefactoringPlugin.processFile(csmFile, modificationResult, atomicReference);
        }
    }
}

