/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.support;

import java.util.EnumSet;
import java.util.Set;
import javax.swing.Icon;
import org.netbeans.modules.cnd.api.model.CsmField;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmVisibility;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelutil.CsmImageLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MemberInfo<H> {
    private final H member;
    private final String htmlText;
    private final Icon icon;
    private final Group group;
    private final Set<CsmVisibility> visibility;
    private boolean makeAbstract;
    private String name;

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public H getElementHandle() {
        return this.member;
    }

    public String getHtmlText() {
        return this.htmlText;
    }

    public static <T extends CsmMember> MemberInfo<T> create(T t) {
        Object object;
        CharSequence charSequence = t.getName();
        Group group = null;
        if (CsmKindUtilities.isField(t)) {
            object = (CsmField)t;
            charSequence = ((Object)object.getName()).toString() + ": " + object.getType().getText();
            group = Group.FIELD;
        } else if (CsmKindUtilities.isMethod(t)) {
            object = (CsmMethod)t;
            charSequence = object.getSignature() + ": " + object.getReturnType().getText();
            group = Group.METHOD;
        }
        object = new MemberInfo<T>(t, ((Object)charSequence).toString(), CsmImageLoader.getIcon(t), ((Object)t.getName()).toString(), group, EnumSet.of(t.getVisibility()), false);
        return object;
    }

    private MemberInfo(H h, String string, Icon icon, String string2, Group group, Set<CsmVisibility> set, boolean bl) {
        this.member = h;
        this.htmlText = string;
        this.icon = icon;
        this.name = string2;
        this.group = group;
        this.visibility = set;
        this.makeAbstract = bl;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public Group getGroup() {
        return this.group;
    }

    public boolean equals(Object object) {
        if (object instanceof MemberInfo && ((MemberInfo)object).member instanceof CsmObject) {
            return ((CsmObject)((MemberInfo)object).member).equals((CsmObject)this.member);
        }
        return super.equals(object);
    }

    public int hashCode() {
        return this.member.hashCode();
    }

    public Set<CsmVisibility> getModifiers() {
        return this.visibility;
    }

    public boolean isMakeAbstract() {
        return this.makeAbstract;
    }

    public void setMakeAbstract(Boolean bl) {
        this.makeAbstract = bl;
    }

    public String toString() {
        return this.htmlText;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Group {
        NONE,
        METHOD,
        FIELD,
        TYPE;

    }
}

