/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.wizard.unit;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.j2ee.persistence.dd.common.Persistence;
import org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.provider.InvalidPersistenceXmlException;
import org.netbeans.modules.j2ee.persistence.provider.Provider;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.unit.PUDataObject;
import org.openide.util.Parameters;

public abstract class PersistenceUnitWizardPanel
extends JPanel {
    protected final Project project;
    private static final Logger LOG = Logger.getLogger(PersistenceUnitWizardPanel.class.getName());
    public static final String IS_VALID = "PersistenceUnitWizardPanel_isValid";

    protected PersistenceUnitWizardPanel(Project project) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        this.project = project;
    }

    public abstract String getPersistenceUnitName();

    public abstract String getTableGeneration();

    public abstract boolean isValidPanel();

    public abstract void setPreselectedDB(String var1);

    public final boolean isNameUnique() throws InvalidPersistenceXmlException {
        if (!ProviderUtil.persistenceExists(this.project)) {
            return true;
        }
        PUDataObject pUDataObject = ProviderUtil.getPUDataObject(this.project);
        Persistence persistence = pUDataObject.getPersistence();
        return this.isUnique(this.getPersistenceUnitName(), persistence.getPersistenceUnit());
    }

    protected final String getCandidateName() {
        String string = ProjectUtils.getInformation((Project)this.project).getName() + "PU";
        try {
            if (!ProviderUtil.persistenceExists(this.project)) {
                return string;
            }
            PUDataObject pUDataObject = ProviderUtil.getPUDataObject(this.project);
            Persistence persistence = pUDataObject.getPersistence();
            int n = 2;
            PersistenceUnit[] persistenceUnitArray = persistence.getPersistenceUnit();
            String string2 = string;
            while (!this.isUnique(string2, persistenceUnitArray)) {
                string2 = string + n++;
            }
            return string2;
        }
        catch (InvalidPersistenceXmlException invalidPersistenceXmlException) {
            LOG.log(Level.FINE, "Invalid persistence.xml found", invalidPersistenceXmlException);
            return string;
        }
    }

    private boolean isUnique(String string, PersistenceUnit[] persistenceUnitArray) {
        for (PersistenceUnit persistenceUnit : persistenceUnitArray) {
            if (!string.equals(persistenceUnit.getName())) continue;
            return false;
        }
        return true;
    }

    public abstract Provider getSelectedProvider();

    public abstract void setErrorMessage(String var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TableGeneration {
        CREATE,
        DROP_CREATE,
        NONE;

    }
}

