/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.api.methodcontroller;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.math.BigDecimal;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.j2ee.common.method.MethodModel;
import org.netbeans.modules.j2ee.common.method.MethodModelSupport;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJarMetadata;
import org.netbeans.modules.j2ee.dd.api.ejb.EntityAndSession;
import org.netbeans.modules.j2ee.ejbcore.Utils;
import org.netbeans.modules.j2ee.ejbcore.api.methodcontroller.EjbMethodController;
import org.netbeans.modules.j2ee.ejbcore.api.methodcontroller.MethodType;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMethodController
extends EjbMethodController {
    private static final int LOCAL = 0;
    private static final int REMOTE = 1;
    private static final int LOCAL_HOME = 2;
    private static final int REMOTE_HOME = 3;
    private final String ejbClass;
    private final MetadataModel<EjbJarMetadata> model;
    protected Set classesForSave;
    private final boolean simplified;
    private final String local;
    private final String remote;
    private final String localHome;
    private final String remoteHome;

    public AbstractMethodController(final String string, MetadataModel<EjbJarMetadata> metadataModel) {
        this.ejbClass = string;
        this.model = metadataModel;
        final String[] stringArray = new String[4];
        BigDecimal bigDecimal = null;
        try {
            bigDecimal = (BigDecimal)metadataModel.runReadAction((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, BigDecimal>(){

                public BigDecimal run(EjbJarMetadata ejbJarMetadata) throws Exception {
                    EntityAndSession entityAndSession = (EntityAndSession)ejbJarMetadata.findByEjbClass(string);
                    if (entityAndSession != null) {
                        stringArray[0] = entityAndSession.getLocal();
                        stringArray[1] = entityAndSession.getRemote();
                        stringArray[2] = entityAndSession.getLocalHome();
                        stringArray[3] = entityAndSession.getHome();
                    }
                    return ejbJarMetadata.getRoot().getVersion();
                }
            });
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        this.simplified = bigDecimal == null ? true : bigDecimal.doubleValue() > 2.1;
        this.local = stringArray[0];
        this.remote = stringArray[1];
        this.localHome = stringArray[2];
        this.remoteHome = stringArray[3];
    }

    public abstract GenerateFromImpl createGenerateFromImpl();

    public abstract GenerateFromIntf createGenerateFromIntf();

    @Override
    public final MethodModel createAndAdd(MethodModel methodModel, boolean bl, boolean bl2) {
        String string = null;
        String string2 = null;
        if (bl) {
            string = this.localHome;
            string2 = this.findBusinessInterface(this.local);
        } else {
            string = this.remoteHome;
            string2 = this.findBusinessInterface(this.remote);
        }
        if (bl2) {
            try {
                this.addMethodToClass(string2, methodModel);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        } else {
            try {
                this.addMethodToClass(string, methodModel);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        if (this.hasJavaImplementation(methodModel)) {
            for (MethodModel methodModel2 : this.getImplementationMethods(methodModel)) {
                try {
                    if (this.findInClass(this.ejbClass, methodModel2)) continue;
                    this.addMethodToClass(this.ejbClass, methodModel2);
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        }
        Object object = methodModel;
        if (!bl && !this.simplified) {
            object = this.addExceptionIfNecessary(methodModel, RemoteException.class.getName());
        }
        return object;
    }

    @Override
    public final void createAndAddInterface(MethodModel methodModel, boolean bl) {
        MethodType methodType = this.getMethodTypeFromImpl(methodModel);
        GenerateFromImpl generateFromImpl = this.createGenerateFromImpl();
        String string = null;
        String string2 = null;
        if (bl) {
            string = this.localHome;
            string2 = this.findBusinessInterface(this.local);
        } else {
            string = this.remoteHome;
            string2 = this.findBusinessInterface(this.remote);
        }
        generateFromImpl.getInterfaceMethodFromImpl(methodType, string, string2);
        MethodModel methodModel2 = generateFromImpl.getInterfaceMethod();
        if (!bl && !this.simplified) {
            methodModel2 = this.addExceptionIfNecessary(methodModel2, RemoteException.class.getName());
        }
        methodModel2 = MethodModel.create((String)methodModel2.getName(), (String)methodModel2.getReturnType(), (String)methodModel2.getBody(), (List)methodModel2.getParameters(), (List)methodModel2.getExceptions(), Collections.emptySet());
        String string3 = generateFromImpl.getDestinationInterface();
        try {
            this.addMethodToClass(string3, methodModel2);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    @Override
    public final void createAndAddImpl(MethodModel methodModel) {
        MethodType methodType = this.getMethodTypeFromInterface(methodModel);
        GenerateFromIntf generateFromIntf = this.createGenerateFromIntf();
        generateFromIntf.getInterfaceMethodFromImpl(methodType);
        MethodModel methodModel2 = generateFromIntf.getImplMethod();
        try {
            this.addMethodToClass(this.ejbClass, methodModel2);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    private List<MethodModel> getImplementationMethods(MethodModel methodModel) {
        MethodType methodType = this.getMethodTypeFromInterface(methodModel);
        GenerateFromIntf generateFromIntf = this.createGenerateFromIntf();
        generateFromIntf.getInterfaceMethodFromImpl(methodType);
        MethodModel methodModel2 = generateFromIntf.getImplMethod();
        MethodModel methodModel3 = generateFromIntf.getSecondaryMethod();
        List<MethodModel> list = null;
        list = methodModel3 != null ? Arrays.asList(methodModel2, methodModel3) : Collections.singletonList(methodModel2);
        return list;
    }

    @Override
    public final List<MethodModel> getImplementation(MethodModel methodModel) {
        List<MethodModel> list = this.getImplementationMethods(methodModel);
        ArrayList<MethodModel> arrayList = new ArrayList<MethodModel>(list.size());
        for (MethodModel methodModel2 : list) {
            boolean bl = this.findInClass(this.getBeanClass(), methodModel2);
            if (!bl) continue;
            arrayList.add(methodModel2);
        }
        return arrayList;
    }

    @Override
    public final EjbMethodController.ClassMethodPair getInterface(MethodModel methodModel, boolean bl) {
        MethodType methodType = this.getMethodTypeFromImpl(methodModel);
        assert (methodType != null) : "method cannot be used in interface";
        GenerateFromImpl generateFromImpl = this.createGenerateFromImpl();
        String string = null;
        String string2 = null;
        if (bl) {
            string = this.localHome;
            string2 = this.findBusinessInterface(this.local);
        } else {
            string = this.remoteHome;
            string2 = this.findBusinessInterface(this.remote);
        }
        generateFromImpl.getInterfaceMethodFromImpl(methodType, string, string2);
        MethodModel methodModel2 = generateFromImpl.getInterfaceMethod();
        String string3 = generateFromImpl.getDestinationInterface();
        boolean bl2 = this.findInClass(string3, methodModel2);
        return bl2 ? new EjbMethodController.ClassMethodPair(string3, methodModel2) : null;
    }

    @Override
    public boolean hasMethodInInterface(MethodModel methodModel, MethodType methodType, boolean bl) {
        String string = null;
        MethodModel methodModel2 = methodModel;
        if (methodType.getKind() == MethodType.Kind.BUSINESS) {
            string = this.findBusinessInterface(bl ? this.local : this.remote);
        } else if (methodType.getKind() == MethodType.Kind.CREATE) {
            String string2 = this.chopAndUpper(methodModel2.getName(), "ejb");
            String string3 = bl ? this.local : this.remote;
            methodModel2 = MethodModel.create((String)string2, (String)string3, (String)methodModel2.getBody(), (List)methodModel2.getParameters(), (List)methodModel2.getExceptions(), (Set)methodModel2.getModifiers());
            String string4 = string = bl ? this.localHome : this.remoteHome;
        }
        if (methodModel2.getName() == null || string == null || methodModel2.getReturnType() == null) {
            return true;
        }
        return this.findInClass(string, methodModel2);
    }

    private String chopAndUpper(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.delete(0, string2.length());
        stringBuffer.setCharAt(0, Character.toLowerCase(stringBuffer.charAt(0)));
        return stringBuffer.toString();
    }

    private MethodModel addExceptionIfNecessary(MethodModel methodModel, String string) {
        if (!methodModel.getExceptions().contains(string)) {
            ArrayList<String> arrayList = new ArrayList<String>(methodModel.getExceptions());
            arrayList.add(string);
            return MethodModel.create((String)methodModel.getName(), (String)methodModel.getReturnType(), (String)methodModel.getBody(), (List)methodModel.getParameters(), arrayList, (Set)methodModel.getModifiers());
        }
        return methodModel;
    }

    private String findBusinessInterface(String string) {
        if (string == null || this.ejbClass == null) {
            return null;
        }
        List<Object> list = new ArrayList();
        try {
            list = this.getInterfaces(this.ejbClass);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        List<Object> list2 = new ArrayList();
        try {
            list2 = this.getInterfaces(string);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        list2.retainAll(list);
        if (list2.isEmpty()) {
            return string;
        }
        String string2 = (String)list2.get(0);
        return string2 == null ? string : string2;
    }

    private List<String> getInterfaces(final String string) throws IOException {
        FileObject fileObject = (FileObject)this.model.runReadAction((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, FileObject>(){

            public FileObject run(EjbJarMetadata ejbJarMetadata) throws Exception {
                return ejbJarMetadata.findResource(Utils.toResourceName(AbstractMethodController.this.ejbClass));
            }
        });
        final ArrayList<String> arrayList = new ArrayList<String>();
        if (fileObject != null) {
            JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
            try {
                javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController compilationController) throws IOException {
                        compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        TypeElement typeElement = compilationController.getElements().getTypeElement(string);
                        if (typeElement != null) {
                            Types types = compilationController.getTypes();
                            for (TypeMirror typeMirror : typeElement.getInterfaces()) {
                                Element element = types.asElement(typeMirror);
                                String string2 = ((TypeElement)element).getQualifiedName().toString();
                                arrayList.add(string2);
                            }
                        }
                    }
                }, true);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return arrayList;
    }

    @Override
    public final String getBeanClass() {
        return this.ejbClass;
    }

    public final List<String> getLocalInterfaces() {
        if (!this.hasLocal()) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>(2);
        if (this.localHome != null) {
            arrayList.add(this.localHome);
        }
        if (this.local != null) {
            arrayList.add(this.findBusinessInterface(this.local));
        }
        return arrayList;
    }

    public final List<String> getRemoteInterfaces() {
        if (!this.hasRemote()) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>(2);
        if (this.remoteHome != null) {
            arrayList.add(this.remoteHome);
        }
        if (this.remote != null) {
            arrayList.add(this.findBusinessInterface(this.remote));
        }
        return arrayList;
    }

    @Override
    public final void delete(MethodModel methodModel) {
        EjbMethodController.ClassMethodPair classMethodPair;
        if (this.hasLocal() && (classMethodPair = this.getInterface(methodModel, true)) != null) {
            try {
                this.removeMethodFromClass(classMethodPair.getClassName(), classMethodPair.getMethodModel());
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        if (this.hasRemote() && (classMethodPair = this.getInterface(methodModel, false)) != null) {
            try {
                this.removeMethodFromClass(classMethodPair.getClassName(), classMethodPair.getMethodModel());
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        try {
            this.removeMethodFromClass(this.getBeanClass(), methodModel);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    @Override
    public final void delete(MethodModel methodModel, boolean bl) {
        boolean bl2;
        List<MethodModel> list = this.getImplementation(methodModel);
        boolean bl3 = bl2 = bl ? this.hasRemote() : this.hasLocal();
        if (!list.isEmpty()) {
            for (MethodModel methodModel2 : list) {
                if (methodModel2 == null) continue;
                EjbMethodController.ClassMethodPair classMethodPair = this.getInterface(methodModel2, bl);
                if ((!bl2 || classMethodPair != null) && bl2) continue;
                try {
                    this.removeMethodFromClass(classMethodPair.getClassName(), classMethodPair.getMethodModel());
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
            try {
                this.removeMethodFromClass(this.getBeanClass(), methodModel);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    @Override
    public boolean hasRemote() {
        String string = this.remoteHome;
        if (!this.simplified && string == null) {
            return false;
        }
        string = this.remote;
        return string != null && this.findBusinessInterface(string) != null;
    }

    @Override
    public boolean hasLocal() {
        String string = this.localHome;
        if (!this.simplified && string == null) {
            return false;
        }
        string = this.local;
        return string != null && this.findBusinessInterface(string) != null;
    }

    @Override
    public MethodModel getPrimaryImplementation(MethodModel methodModel) {
        List<MethodModel> list = this.getImplementation(methodModel);
        return list.isEmpty() ? null : list.get(0);
    }

    @Override
    public String getRemote() {
        return this.remote;
    }

    @Override
    public String getLocal() {
        return this.local;
    }

    public String getLocalHome() {
        return this.localHome;
    }

    public String getHome() {
        return this.remoteHome;
    }

    protected boolean isSimplified() {
        return this.simplified;
    }

    public String getBeanInterface(boolean bl, boolean bl2) {
        if (bl2) {
            return this.findBusinessInterface(bl ? this.local : this.remote);
        }
        String string = bl ? this.localHome : this.remoteHome;
        return string;
    }

    private void createBeanMethod(MethodModel methodModel) throws IOException {
        if (this.hasJavaImplementation(methodModel)) {
            List<MethodModel> list = this.getImplementationMethods(methodModel);
            for (MethodModel methodModel2 : list) {
                if (this.findInClass(this.ejbClass, methodModel2)) continue;
                this.addMethodToClass(this.ejbClass, methodModel);
            }
        }
    }

    public final void removeMethod(MethodModel methodModel, boolean bl, boolean bl2) {
        String string = this.getBeanInterface(bl, bl2);
        MethodModel methodModel2 = methodModel;
        assert (string != null);
        if (!bl) {
            methodModel2 = this.addExceptionIfNecessary(methodModel2, RemoteException.class.getName());
        }
        try {
            this.removeMethodFromClass(string, methodModel2);
            this.createBeanMethod(methodModel2);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    protected boolean findInClass(final String string, final MethodModel methodModel) {
        if (string == null) {
            return false;
        }
        try {
            FileObject fileObject = (FileObject)this.model.runReadAction((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, FileObject>(){

                public FileObject run(EjbJarMetadata ejbJarMetadata) throws Exception {
                    return ejbJarMetadata.findResource(Utils.toResourceName(AbstractMethodController.this.ejbClass));
                }
            });
            final boolean[] blArray = new boolean[]{false};
            JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
            javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController compilationController) throws IOException {
                    compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    blArray[0] = AbstractMethodController.this.methodFindInClass(compilationController, string, methodModel) != null;
                }
            }, true);
            return blArray[0];
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return false;
        }
    }

    private ExecutableElement methodFindInClass(CompilationController compilationController, String string, MethodModel methodModel) throws IOException {
        TypeElement typeElement = compilationController.getElements().getTypeElement(string);
        if (typeElement != null) {
            for (ExecutableElement executableElement : ElementFilter.methodsIn(typeElement.getEnclosedElements())) {
                if (!MethodModelSupport.isSameMethod((CompilationController)compilationController, (ExecutableElement)executableElement, (MethodModel)methodModel)) continue;
                return executableElement;
            }
        }
        return null;
    }

    protected void addMethodToClass(final String string, final MethodModel methodModel) throws IOException {
        FileObject fileObject = (FileObject)this.model.runReadAction((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, FileObject>(){

            public FileObject run(EjbJarMetadata ejbJarMetadata) throws Exception {
                return ejbJarMetadata.findResource(Utils.toResourceName(string));
            }
        });
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        javaSource.runModificationTask((Task)new Task<WorkingCopy>(){

            public void run(WorkingCopy workingCopy) throws IOException {
                workingCopy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                Trees trees = workingCopy.getTrees();
                TypeElement typeElement = workingCopy.getElements().getTypeElement(string);
                ClassTree classTree = trees.getTree(typeElement);
                MethodTree methodTree = MethodModelSupport.createMethodTree((WorkingCopy)workingCopy, (MethodModel)methodModel);
                ClassTree classTree2 = workingCopy.getTreeMaker().addClassMember(classTree, (Tree)methodTree);
                workingCopy.rewrite((Tree)classTree, (Tree)classTree2);
            }
        }).commit();
    }

    protected void removeMethodFromClass(final String string, final MethodModel methodModel) throws IOException {
        FileObject fileObject = (FileObject)this.model.runReadAction((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, FileObject>(){

            public FileObject run(EjbJarMetadata ejbJarMetadata) throws Exception {
                return ejbJarMetadata.findResource(Utils.toResourceName(string));
            }
        });
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        javaSource.runModificationTask((Task)new Task<WorkingCopy>(){

            public void run(WorkingCopy workingCopy) throws IOException {
                workingCopy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                ExecutableElement executableElement = AbstractMethodController.this.methodFindInClass((CompilationController)workingCopy, string, methodModel);
                if (executableElement != null) {
                    TypeElement typeElement = workingCopy.getElements().getTypeElement(string);
                    Trees trees = workingCopy.getTrees();
                    ClassTree classTree = trees.getTree(typeElement);
                    MethodTree methodTree = trees.getTree(executableElement);
                    ClassTree classTree2 = workingCopy.getTreeMaker().removeClassMember(classTree, (Tree)methodTree);
                    workingCopy.rewrite((Tree)classTree, (Tree)classTree2);
                }
            }
        }).commit();
    }

    public static interface GenerateFromIntf {
        public void getInterfaceMethodFromImpl(MethodType var1);

        public MethodModel getImplMethod();

        public MethodModel getSecondaryMethod();
    }

    public static interface GenerateFromImpl {
        public void getInterfaceMethodFromImpl(MethodType var1, String var2, String var3);

        public String getDestinationInterface();

        public MethodModel getInterfaceMethod();
    }
}

