/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.shared;

import java.io.IOException;
import javax.swing.Action;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJarMetadata;
import org.netbeans.modules.j2ee.dd.api.ejb.EntityAndSession;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.action.AddActionGroup;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.action.GoToSourceAction;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.shared.EjbViewController;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.openide.cookies.OpenCookie;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class MethodsNode
extends AbstractNode
implements OpenCookie {
    private final String ejbClass;
    private final MetadataModel<EjbJarMetadata> model;
    private final EjbViewController controller;
    private DataObject dataObject;
    private ViewType viewType;

    public MethodsNode(String string, EjbJar ejbJar, Children children, ViewType viewType) {
        this(new InstanceContent(), string, ejbJar, children, viewType);
    }

    private MethodsNode(InstanceContent instanceContent, final String string, EjbJar ejbJar, Children children, final ViewType viewType) {
        super(children, (Lookup)new AbstractLookup((AbstractLookup.Content)instanceContent));
        this.ejbClass = string;
        this.model = ejbJar.getMetadataModel();
        this.controller = new EjbViewController(string, ejbJar);
        this.viewType = viewType;
        String string2 = null;
        try {
            string2 = (String)this.model.runReadAction((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, String>(){

                public String run(EjbJarMetadata ejbJarMetadata) throws Exception {
                    EntityAndSession entityAndSession = (EntityAndSession)ejbJarMetadata.findByEjbClass(string);
                    if (entityAndSession != null) {
                        switch (viewType) {
                            case NO_INTERFACE: {
                                return entityAndSession.getEjbClass();
                            }
                            case LOCAL: {
                                return entityAndSession.getLocal();
                            }
                            case REMOTE: {
                                return entityAndSession.getRemote();
                            }
                        }
                    }
                    return null;
                }
            });
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        this.dataObject = this.controller.getDataObject(string2);
        instanceContent.add((Object)this);
        if (this.dataObject != null) {
            instanceContent.add((Object)this.dataObject);
        }
    }

    public Action[] getActions(boolean bl) {
        return new Action[]{new GoToSourceAction(this.dataObject, NbBundle.getMessage(MethodsNode.class, (String)"LBL_GoToSourceGroup")), SystemAction.get(AddActionGroup.class)};
    }

    public Action getPreferredAction() {
        return new GoToSourceAction(this.dataObject, NbBundle.getMessage(MethodsNode.class, (String)"LBL_GoToSourceGroup"));
    }

    public void open() {
        OpenCookie openCookie;
        DataObject dataObject = this.controller.getBeanDo();
        if (dataObject != null && (openCookie = (OpenCookie)dataObject.getCookie(OpenCookie.class)) != null) {
            openCookie.open();
        }
    }

    public boolean isLocal() {
        return this.viewType == ViewType.LOCAL;
    }

    public boolean isRemote() {
        return this.viewType == ViewType.REMOTE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ViewType {
        NO_INTERFACE,
        LOCAL,
        REMOTE;

    }
}

