/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jpa.refactoring.rename;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.Tree;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.jpa.refactoring.EntityAnnotationReference;
import org.netbeans.modules.j2ee.jpa.refactoring.EntityAssociationResolver;
import org.netbeans.modules.j2ee.jpa.refactoring.JPARefactoring;
import org.netbeans.modules.j2ee.jpa.refactoring.RefactoringUtil;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.persistence.api.PersistenceScope;
import org.netbeans.modules.j2ee.persistence.api.PersistenceScopes;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.EntityMappingsMetadata;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.openide.filesystems.FileObject;
import org.openide.text.PositionBounds;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityRename
implements JPARefactoring {
    private final RenameRefactoring rename;
    private TreePathHandle treePathHandle;

    public EntityRename(RenameRefactoring renameRefactoring) {
        this.rename = renameRefactoring;
        try {
            this.treePathHandle = RefactoringUtil.resolveTreePathHandle((AbstractRefactoring)renameRefactoring);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    private PersistenceScope getPersistenceScope() {
        if (this.treePathHandle == null) {
            return null;
        }
        Project project = FileOwnerQuery.getOwner((FileObject)this.treePathHandle.getFileObject());
        if (project == null) {
            return null;
        }
        PersistenceScopes persistenceScopes = PersistenceScopes.getPersistenceScopes((Project)project);
        if (persistenceScopes == null) {
            return null;
        }
        if (persistenceScopes.getPersistenceScopes().length == 0) {
            return null;
        }
        return persistenceScopes.getPersistenceScopes()[0];
    }

    private MetadataModel<EntityMappingsMetadata> getEntityMappingsModel() {
        PersistenceScope persistenceScope = this.getPersistenceScope();
        return persistenceScope != null ? persistenceScope.getEntityMappingsModel(null) : null;
    }

    @Override
    public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        MetadataModel<EntityMappingsMetadata> metadataModel = this.getEntityMappingsModel();
        if (metadataModel == null) {
            return null;
        }
        EntityAssociationResolver entityAssociationResolver = new EntityAssociationResolver(this.treePathHandle, metadataModel);
        try {
            List<EntityAnnotationReference> list = entityAssociationResolver.resolveReferences();
            for (EntityAnnotationReference entityAnnotationReference : list) {
                EntityRenameElement entityRenameElement = new EntityRenameElement(entityAnnotationReference, this.rename);
                refactoringElementsBag.add((AbstractRefactoring)this.rename, (RefactoringElementImplementation)entityRenameElement);
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return null;
    }

    @Override
    public Problem preCheck() {
        return null;
    }

    private static class EntityRenameElement
    extends SimpleRefactoringElementImplementation {
        private final RenameRefactoring rename;
        private final EntityAnnotationReference reference;

        public EntityRenameElement(EntityAnnotationReference entityAnnotationReference, RenameRefactoring renameRefactoring) {
            this.reference = entityAnnotationReference;
            this.rename = renameRefactoring;
        }

        public String getText() {
            return this.getDisplayText();
        }

        public String getDisplayText() {
            Object[] objectArray = new Object[]{this.reference.getHandle().getFileObject().getNameExt(), this.reference.getAttributeValue(), this.rename.getNewName()};
            return MessageFormat.format(NbBundle.getMessage(EntityRename.class, (String)"TXT_EntityAnnotationRename"), objectArray);
        }

        public void performChange() {
            try {
                JavaSource javaSource = JavaSource.forFileObject((FileObject)this.reference.getHandle().getFileObject());
                javaSource.runModificationTask((Task)new CancellableTask<WorkingCopy>(){

                    public void cancel() {
                    }

                    public void run(WorkingCopy workingCopy) throws Exception {
                        workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                        Element element = EntityRenameElement.this.reference.getHandle().resolveElement((CompilationInfo)workingCopy);
                        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
                            if (!annotationMirror.getAnnotationType().toString().equals(EntityRenameElement.this.reference.getAnnotation())) continue;
                            Map<? extends ExecutableElement, ? extends AnnotationValue> map = annotationMirror.getElementValues();
                            for (ExecutableElement executableElement : map.keySet()) {
                                if (!executableElement.getSimpleName().contentEquals(EntityRenameElement.this.reference.getAttribute())) continue;
                                AnnotationValue annotationValue = map.get(executableElement);
                                if (!EntityRenameElement.this.reference.getAttributeValue().equals(annotationValue.getValue().toString())) continue;
                                TreeMaker treeMaker = workingCopy.getTreeMaker();
                                LiteralTree literalTree = treeMaker.Literal((Object)EntityRenameElement.this.rename.getNewName());
                                AssignmentTree assignmentTree = treeMaker.Assignment((ExpressionTree)treeMaker.Identifier((CharSequence)EntityRenameElement.this.reference.getAttribute()), (ExpressionTree)literalTree);
                                TypeElement typeElement = workingCopy.getElements().getTypeElement(EntityRenameElement.this.reference.getAnnotation());
                                AnnotationTree annotationTree = treeMaker.Annotation((Tree)treeMaker.QualIdent((Element)typeElement), Collections.singletonList(assignmentTree));
                                Tree tree = workingCopy.getTrees().getTree(element, annotationMirror, annotationValue);
                                workingCopy.rewrite(tree, (Tree)annotationTree);
                            }
                        }
                    }
                }).commit();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }

        public Lookup getLookup() {
            return Lookups.singleton((Object)this.reference.getHandle().getFileObject());
        }

        public FileObject getParentFile() {
            return this.reference.getHandle().getFileObject();
        }

        public PositionBounds getPosition() {
            return null;
        }
    }
}

