/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.visual.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.css.visual.model.FontModel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;

public class FontFamilyEditorDialog
extends JPanel {
    private JDialog dialog;
    private DialogDescriptor dlg = null;
    private String closeButtonLabel = NbBundle.getMessage(FontFamilyEditorDialog.class, (String)"Close_Button_Label");
    private JButton closeButton = new JButton(this.closeButtonLabel);
    DefaultListModel fontFamilies = null;
    DefaultListModel selectedFonts = new DefaultListModel();
    DefaultListModel availableFonts = new DefaultListModel();
    FontModel fontModel = new FontModel();
    int currentIndex = 1;
    private JButton addButton;
    private JPanel addRemoveButtonPanel;
    private JList availableFontList;
    private JScrollPane availableFontScroll;
    private JLabel availableLabel;
    private JLabel currentFontFamiliesLabel;
    private JPanel currentFontFamilyPanel;
    private JButton deleteButton;
    private JButton downButton;
    private JList fontFaceList;
    private JPanel fontFamilyEditor;
    private JScrollPane fontFamilyScroll;
    private JComboBox fontSelectionCombo;
    private JButton newButton;
    private JPanel newDeleteButtonPanel;
    private JButton removeButton;
    private JList selectedFontList;
    private JScrollPane selectedFontScroll;
    private JLabel selectedLabel;
    private JButton upButton;
    private JPanel upDownPanel;

    public FontFamilyEditorDialog(DefaultListModel defaultListModel, int n) {
        this.initComponents();
        this.currentIndex = n;
        this.fontFamilies = defaultListModel;
        this.fontFaceList.setModel(defaultListModel);
        this.fontFaceList.setSelectedIndex(this.currentIndex);
        this.fontSelectionCombo.setModel(this.fontModel.getFontSelectionList());
        this.fontSelectionCombo.setSelectedIndex(0);
        this.availableFonts = this.fontModel.getFontList();
        this.availableFontList.setModel(this.availableFonts);
        this.selectedFontList.setModel(this.selectedFonts);
        this.availableFontList.setSelectedIndex(0);
    }

    public void showDialog() {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FontFamilyEditorDialog.this.dialog.setVisible(false);
            }
        };
        this.dlg = new DialogDescriptor((Object)this, NbBundle.getMessage(FontFamilyEditorDialog.class, (String)"FONT_FAMILY_EDITOR_TITLE"), true, actionListener);
        this.dlg.setOptions(new Object[]{this.closeButton});
        this.dlg.setClosingOptions(new Object[]{this.closeButton});
        this.dialog = (JDialog)DialogDisplayer.getDefault().createDialog(this.dlg);
        this.dialog.setResizable(true);
        this.dialog.pack();
        this.dialog.setVisible(true);
    }

    public int getSelectedIndex() {
        return this.currentIndex;
    }

    private void initComponents() {
        this.currentFontFamilyPanel = new JPanel();
        this.fontFamilyScroll = new JScrollPane();
        this.fontFaceList = new JList();
        this.newDeleteButtonPanel = new JPanel();
        this.newButton = new JButton();
        this.deleteButton = new JButton();
        this.currentFontFamiliesLabel = new JLabel();
        this.fontFamilyEditor = new JPanel();
        this.availableFontScroll = new JScrollPane();
        this.availableFontList = new JList();
        this.selectedFontScroll = new JScrollPane();
        this.selectedFontList = new JList();
        this.availableLabel = new JLabel();
        this.selectedLabel = new JLabel();
        this.addRemoveButtonPanel = new JPanel();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.upDownPanel = new JPanel();
        this.upButton = new JButton();
        this.downButton = new JButton();
        this.fontSelectionCombo = new JComboBox();
        this.setLayout(new BorderLayout(5, 5));
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.currentFontFamilyPanel.setLayout(new GridBagLayout());
        this.fontFaceList.setSelectionMode(0);
        this.fontFaceList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                FontFamilyEditorDialog.this.fontFaceListValueChanged(listSelectionEvent);
            }
        });
        this.fontFamilyScroll.setViewportView(this.fontFaceList);
        this.fontFaceList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FontFamilyEditorDialog.class, (String)"CURRENT_FONTS"));
        this.fontFaceList.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/css/visual/ui/Bundle").getString("FONT_FAMILY_LIST_ACCESS_DESC"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.currentFontFamilyPanel.add((Component)this.fontFamilyScroll, gridBagConstraints);
        this.newDeleteButtonPanel.setLayout(new GridLayout(0, 1, 0, 5));
        this.newButton.setMnemonic(NbBundle.getMessage(FontFamilyEditorDialog.class, (String)"FONT_FAMILY_NEW_BUTTON_MNEMONIC").charAt(0));
        this.newButton.setText(NbBundle.getMessage(FontFamilyEditorDialog.class, (String)"NEW"));
        this.newButton.setMargin(new Insets(2, 10, 2, 10));
        this.newButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FontFamilyEditorDialog.this.newButtonActionPerformed(actionEvent);
            }
        });
        this.newDeleteButtonPanel.add(this.newButton);
        this.newButton.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/css/visual/ui/Bundle").getString("ADD_FONT_FAMILY_ACCESS_DESC"));
        this.deleteButton.setMnemonic(NbBundle.getMessage(FontFamilyEditorDialog.class, (String)"FONT_FAMILY_DELETE_BUTTON_MNEMONIC").charAt(0));
        this.deleteButton.setText(NbBundle.getMessage(FontFamilyEditorDialog.class, (String)"DELETE"));
        this.deleteButton.setMargin(new Insets(2, 10, 2, 10));
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FontFamilyEditorDialog.this.deleteButtonActionPerformed(actionEvent);
            }
        });
        this.newDeleteButtonPanel.add(this.deleteButton);
        this.deleteButton.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/css/visual/ui/Bundle").getString("DELETE_FONT_FAMILY_ACCESS_DESC"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.currentFontFamilyPanel.add((Component)this.newDeleteButtonPanel, gridBagConstraints);
        this.currentFontFamiliesLabel.setLabelFor(this.fontFaceList);
        this.currentFontFamiliesLabel.setText(NbBundle.getMessage(FontFamilyEditorDialog.class, (String)"CURRENT_FONTS"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.currentFontFamilyPanel.add((Component)this.currentFontFamiliesLabel, gridBagConstraints);
        this.add((Component)this.currentFontFamilyPanel, "Center");
        this.fontFamilyEditor.setLayout(new GridBagLayout());
        this.availableFontScroll.setPreferredSize(new Dimension(200, 138));
        this.availableFontList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                FontFamilyEditorDialog.this.availableFontListValueChanged(listSelectionEvent);
            }
        });
        this.availableFontScroll.setViewportView(this.availableFontList);
        this.availableFontList.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/modules/css/visual/ui/Bundle").getString("AVAILABLE_FONT_LIST_ACCESS_NAME"));
        this.availableFontList.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/css/visual/ui/Bundle").getString("AVAILABLE_FONT_LIST_ACCESS_DESC"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 10);
        this.fontFamilyEditor.add((Component)this.availableFontScroll, gridBagConstraints);
        this.selectedFontScroll.setPreferredSize(new Dimension(200, 130));
        this.selectedFontList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                FontFamilyEditorDialog.this.selectedFontListValueChanged(listSelectionEvent);
            }
        });
        this.selectedFontScroll.setViewportView(this.selectedFontList);
        this.selectedFontList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FontFamilyEditorDialog.class, (String)"SELECTED"));
        this.selectedFontList.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/css/visual/ui/Bundle").getString("SELECTED_FONT_LIST_ACCESS_DESC"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.fontFamilyEditor.add((Component)this.selectedFontScroll, gridBagConstraints);
        this.availableLabel.setLabelFor(this.fontSelectionCombo);
        this.availableLabel.setText(NbBundle.getMessage(FontFamilyEditorDialog.class, (String)"AVAILABLE"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        this.fontFamilyEditor.add((Component)this.availableLabel, gridBagConstraints);
        this.selectedLabel.setLabelFor(this.selectedFontList);
        this.selectedLabel.setText(NbBundle.getMessage(FontFamilyEditorDialog.class, (String)"SELECTED"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.fontFamilyEditor.add((Component)this.selectedLabel, gridBagConstraints);
        this.selectedLabel.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/css/visual/ui/Bundle").getString("SELECTED_FONT_LIST_ACCESS_DESC"));
        this.addRemoveButtonPanel.setLayout(new GridLayout(2, 1, 0, 5));
        this.addButton.setText(">");
        this.addButton.setToolTipText(NbBundle.getMessage(FontFamilyEditorDialog.class, (String)"Add_selected_fonts"));
        this.addButton.setMargin(new Insets(2, 10, 2, 10));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FontFamilyEditorDialog.this.addButtonActionPerformed(actionEvent);
            }
        });
        this.addRemoveButtonPanel.add(this.addButton);
        this.addButton.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/modules/css/visual/ui/Bundle").getString("ADD_FONT_ACCESS_NAME"));
        this.removeButton.setText("<");
        this.removeButton.setToolTipText(NbBundle.getMessage(FontFamilyEditorDialog.class, (String)"Remove_selected_fonts"));
        this.removeButton.setMargin(new Insets(2, 10, 2, 10));
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FontFamilyEditorDialog.this.removeButtonActionPerformed(actionEvent);
            }
        });
        this.addRemoveButtonPanel.add(this.removeButton);
        this.removeButton.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/modules/css/visual/ui/Bundle").getString("REMOVE_FONT_ACCESS_NAME"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.fontFamilyEditor.add((Component)this.addRemoveButtonPanel, gridBagConstraints);
        this.upDownPanel.setLayout(new GridLayout(0, 1, 0, 5));
        this.upButton.setMnemonic(NbBundle.getMessage(FontFamilyEditorDialog.class, (String)"FONT_FAMILY_UP_BUTTON_MNEMONIC").charAt(0));
        this.upButton.setText(NbBundle.getMessage(FontFamilyEditorDialog.class, (String)"UP"));
        this.upButton.setMargin(new Insets(2, 10, 2, 10));
        this.upButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FontFamilyEditorDialog.this.upButtonActionPerformed(actionEvent);
            }
        });
        this.upDownPanel.add(this.upButton);
        this.upButton.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/css/visual/ui/Bundle").getString("MOVE_FONT_UP_ACCESS_NAME"));
        this.downButton.setMnemonic(NbBundle.getMessage(FontFamilyEditorDialog.class, (String)"FONT_FAMILY_DOWN_BUTTON_MNEMONIC").charAt(0));
        this.downButton.setText(NbBundle.getMessage(FontFamilyEditorDialog.class, (String)"DOWN"));
        this.downButton.setMargin(new Insets(2, 10, 2, 10));
        this.downButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FontFamilyEditorDialog.this.downButtonActionPerformed(actionEvent);
            }
        });
        this.upDownPanel.add(this.downButton);
        this.downButton.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/css/visual/ui/Bundle").getString("MOVE_FONT_DOWN_ACCESS_NAME"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.fontFamilyEditor.add((Component)this.upDownPanel, gridBagConstraints);
        this.fontSelectionCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                FontFamilyEditorDialog.this.fontSelectionComboItemStateChanged(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 10);
        this.fontFamilyEditor.add((Component)this.fontSelectionCombo, gridBagConstraints);
        this.fontSelectionCombo.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/css/visual/ui/Bundle").getString("AVAILABLE_FONT_COMBO_ACCESS_DESC"));
        this.add((Component)this.fontFamilyEditor, "South");
    }

    private void downButtonActionPerformed(ActionEvent actionEvent) {
        int n;
        if (this.selectedFonts.getSize() > 0 && (n = this.selectedFontList.getSelectedIndex()) >= 0 && n < this.selectedFonts.getSize()) {
            Object e = this.selectedFonts.get(n);
            Object e2 = this.selectedFonts.get(n + 1);
            this.selectedFonts.setElementAt(e, n + 1);
            this.selectedFonts.setElementAt(e2, n);
            this.selectedFontList.setSelectedIndex(n + 1);
            this.resetFontFamilySet();
        }
    }

    private void upButtonActionPerformed(ActionEvent actionEvent) {
        int n;
        if (this.selectedFonts.getSize() > 0 && (n = this.selectedFontList.getSelectedIndex()) > 0) {
            Object e = this.selectedFonts.get(n);
            Object e2 = this.selectedFonts.get(n - 1);
            this.selectedFonts.setElementAt(e, n - 1);
            this.selectedFonts.setElementAt(e2, n);
            this.selectedFontList.setSelectedIndex(n - 1);
            this.resetFontFamilySet();
        }
    }

    private void deleteButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.fontFaceList.getSelectedIndex();
        if (n <= 0) {
            return;
        }
        this.fontFamilies.remove(n);
        if (!this.fontFamilies.isEmpty()) {
            if (n == this.fontFamilies.getSize()) {
                --n;
            }
            this.fontFaceList.setSelectedIndex(n);
        }
    }

    private void newButtonActionPerformed(ActionEvent actionEvent) {
        this.fontFamilies.insertElementAt(" ", 1);
        this.fontFaceList.setSelectedIndex(1);
    }

    private void selectedFontListValueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            int n = this.selectedFontList.getSelectedIndex();
            if (n == 0) {
                this.upButton.setEnabled(false);
            } else {
                this.upButton.setEnabled(true);
            }
            if (n == this.selectedFonts.getSize() - 1) {
                this.downButton.setEnabled(false);
            } else {
                this.downButton.setEnabled(true);
            }
        }
    }

    private void availableFontListValueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            // empty if block
        }
    }

    private void removeButtonActionPerformed(ActionEvent actionEvent) {
        Object[] objectArray = this.selectedFontList.getSelectedValues();
        for (int i = 0; i < objectArray.length; ++i) {
            if (!this.selectedFonts.contains(objectArray[i])) continue;
            this.selectedFonts.removeElement(objectArray[i]);
        }
        if (!this.selectedFonts.isEmpty()) {
            this.selectedFontList.setSelectedIndex(0);
        } else {
            this.removeButton.setEnabled(false);
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(false);
        }
        this.resetFontFamilySet();
    }

    private void fontFaceListValueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            this.currentIndex = this.fontFaceList.getSelectedIndex();
            this.selectedFonts.removeAllElements();
            if (this.currentIndex > 0) {
                this.addButton.setEnabled(true);
                this.deleteButton.setEnabled(true);
                this.upButton.setEnabled(true);
                this.downButton.setEnabled(true);
                String string = (String)this.fontFaceList.getSelectedValue();
                if (string != null && !string.trim().equals("")) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                    while (stringTokenizer.hasMoreTokens()) {
                        String string2 = stringTokenizer.nextToken();
                        if (string2.trim().equals("")) continue;
                        string2 = string2.replaceAll("'", "");
                        this.selectedFonts.addElement(string2);
                    }
                }
                if (!this.selectedFonts.isEmpty()) {
                    this.removeButton.setEnabled(true);
                    this.selectedFontList.setSelectedIndex(0);
                }
            } else {
                this.addButton.setEnabled(false);
                this.removeButton.setEnabled(false);
                this.deleteButton.setEnabled(false);
                this.upButton.setEnabled(false);
                this.downButton.setEnabled(false);
            }
        }
    }

    private void addButtonActionPerformed(ActionEvent actionEvent) {
        Object[] objectArray = this.availableFontList.getSelectedValues();
        for (int i = 0; i < objectArray.length; ++i) {
            if (this.selectedFonts.contains(objectArray[i])) continue;
            this.selectedFonts.addElement(objectArray[i]);
            this.selectedFontList.setSelectedValue(objectArray[i], true);
        }
        this.removeButton.setEnabled(true);
        this.resetFontFamilySet();
    }

    private void fontSelectionComboItemStateChanged(ItemEvent itemEvent) {
        this.fontSelectionCombo.getSelectedIndex();
        switch (this.fontSelectionCombo.getSelectedIndex()) {
            case 0: {
                this.availableFonts = this.fontModel.getFontList();
                break;
            }
            case 1: {
                this.availableFonts = this.fontModel.getFontFamilyList();
                break;
            }
            case 2: {
                this.availableFonts = this.fontModel.getWebFontList();
            }
        }
        this.availableFontList.setModel(this.availableFonts);
        this.availableFontList.setSelectedIndex(0);
    }

    private void resetFontFamilySet() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.selectedFonts.size(); ++i) {
            String string = ((String)this.selectedFonts.get(i)).trim();
            if (string.indexOf(" ") != -1) {
                string = "'" + string + "'";
            }
            stringBuffer.append(string);
            if (i >= this.selectedFonts.size() - 1) continue;
            stringBuffer.append(",");
        }
        if (stringBuffer.length() == 0) {
            stringBuffer.append(" ");
        }
        this.fontFamilies.setElementAt(stringBuffer.toString(), this.currentIndex);
    }
}

