/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Formatter;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;

public class EditList {
    private BaseDocument doc;
    private List<Edit> edits;
    private boolean formatAll;
    private List<DelegatedPosition> positions = new ArrayList<DelegatedPosition>();

    public EditList(BaseDocument baseDocument) {
        this.doc = baseDocument;
        this.edits = new ArrayList<Edit>();
    }

    public String toString() {
        return "EditList(" + this.edits + ")";
    }

    public Position createPosition(int n) {
        return this.createPosition(n, Position.Bias.Forward);
    }

    public Position createPosition(int n, Position.Bias bias) {
        DelegatedPosition delegatedPosition = new DelegatedPosition(n, bias);
        this.positions.add(delegatedPosition);
        return delegatedPosition;
    }

    public EditList replace(int n, int n2, String string, boolean bl, int n3) {
        this.edits.add(new Edit(n, n2, string, bl, n3));
        return this;
    }

    public void applyToDocument(BaseDocument baseDocument) {
        EditList editList = new EditList(baseDocument);
        editList.formatAll = this.formatAll;
        editList.edits = this.edits;
        editList.apply();
    }

    public void setFormatAll(boolean bl) {
        this.formatAll = bl;
    }

    public void apply() {
        if (this.edits.size() == 0) {
            return;
        }
        Collections.sort(this.edits);
        Collections.reverse(this.edits);
        this.doc.runAtomic(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                block11: {
                    try {
                        Edit edit2;
                        int n = ((Edit)((EditList)EditList.this).edits.get((int)0)).offset;
                        Position position = EditList.this.doc.createPosition(n, Position.Bias.Forward);
                        for (Edit edit2 : EditList.this.edits) {
                            if (edit2.removeLen > 0) {
                                EditList.this.doc.remove(edit2.offset, edit2.removeLen);
                            }
                            if (edit2.getInsertText() == null) continue;
                            EditList.this.doc.insertString(edit2.offset, edit2.insertText, null);
                            int n2 = edit2.offset + edit2.insertText.length();
                            for (int i = 0; i < EditList.this.positions.size(); ++i) {
                                DelegatedPosition delegatedPosition = (DelegatedPosition)EditList.this.positions.get(i);
                                int n3 = delegatedPosition.originalOffset;
                                if (edit2.getOffset() > n3 || n2 < n3) continue;
                                delegatedPosition.delegate = EditList.this.doc.createPosition(n3, delegatedPosition.bias);
                            }
                            if (!edit2.format) continue;
                            Formatter formatter = EditList.this.doc.getFormatter();
                            try {
                                formatter.reformatLock();
                                formatter.reformat(EditList.this.doc, edit2.offset, n2);
                            }
                            finally {
                                formatter.reformatUnlock();
                            }
                        }
                        if (!EditList.this.formatAll) break block11;
                        int n4 = ((Edit)((EditList)EditList.this).edits.get((int)(((EditList)EditList.this).edits.size() - 1))).offset;
                        n = position.getOffset();
                        edit2 = EditList.this.doc.getFormatter();
                        try {
                            edit2.reformatLock();
                            edit2.reformat(EditList.this.doc, n4, n);
                        }
                        finally {
                            edit2.reformatUnlock();
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        Exceptions.printStackTrace((Throwable)badLocationException);
                    }
                }
            }
        });
    }

    public OffsetRange getRange() {
        int n;
        if (this.edits.size() == 0) {
            return OffsetRange.NONE;
        }
        int n2 = n = this.edits.get((int)0).offset;
        for (Edit edit : this.edits) {
            if (edit.offset < n) {
                n = edit.offset;
            }
            if (edit.offset <= n2) continue;
            n2 = edit.offset;
        }
        return new OffsetRange(n, n2);
    }

    public int firstLine(BaseDocument baseDocument) {
        OffsetRange offsetRange = this.getRange();
        if (offsetRange == OffsetRange.NONE) {
            return -1;
        }
        return NbDocument.findLineNumber((StyledDocument)((StyledDocument)baseDocument), (int)offsetRange.getStart());
    }

    private class DelegatedPosition
    implements Position {
        private int originalOffset;
        private Position delegate;
        private Position.Bias bias;

        private DelegatedPosition(int n, Position.Bias bias) {
            this.originalOffset = n;
            this.bias = bias;
        }

        public int getOffset() {
            if (this.delegate != null) {
                return this.delegate.getOffset();
            }
            return -1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Edit
    implements Comparable<Edit> {
        int offset;
        int removeLen;
        String insertText;
        boolean format;
        int offsetOrdinal;

        private Edit(int n, int n2, String string, boolean bl) {
            this.offset = n;
            this.removeLen = n2;
            this.insertText = string;
            this.format = bl;
        }

        private Edit(int n, int n2, String string, boolean bl, int n3) {
            this(n, n2, string, bl);
            this.offsetOrdinal = n3;
        }

        @Override
        public int compareTo(Edit edit) {
            if (this.offset == edit.offset) {
                return edit.offsetOrdinal - this.offsetOrdinal;
            }
            return this.offset - edit.offset;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getRemoveLen() {
            return this.removeLen;
        }

        public String getInsertText() {
            return this.insertText;
        }

        public String toString() {
            return "Edit(pos=" + this.offset + ",delete=" + this.removeLen + ",insert=" + this.insertText + ")";
        }
    }
}

