/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.codetemplates.textsync;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.lib.editor.codetemplates.textsync.TextRegionManager;
import org.netbeans.lib.editor.codetemplates.textsync.TextSync;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TextSyncGroup<I> {
    private TextRegionManager manager;
    private List<TextSync> textSyncs;
    private int activeTextSyncIndex = -1;
    private I clientInfo;

    public TextSyncGroup(TextSync ... textSyncArray) {
        this.initTextSyncs(textSyncArray.length);
        for (TextSync textSync : textSyncArray) {
            this.addTextSync(textSync);
        }
    }

    public TextSyncGroup() {
        this.initTextSyncs(4);
    }

    private void initTextSyncs(int n) {
        this.textSyncs = new ArrayList<TextSync>(n);
    }

    public List<TextSync> textSyncs() {
        return Collections.unmodifiableList(this.textSyncs);
    }

    public void addTextSync(TextSync textSync) {
        if (textSync == null) {
            throw new IllegalArgumentException("textSync cannot be null");
        }
        if (textSync.group() != null) {
            throw new IllegalArgumentException("textSync " + textSync + " already assigned to group " + textSync.group());
        }
        this.textSyncs.add(textSync);
        textSync.setGroup(this);
    }

    public void removeTextSync(TextSync textSync) {
        if (this.textSyncs.remove(textSync)) {
            textSync.setGroup(null);
        }
    }

    List<TextSync> textSyncsModifiable() {
        return this.textSyncs;
    }

    public TextRegionManager textRegionManager() {
        return this.manager;
    }

    void setTextRegionManager(TextRegionManager textRegionManager) {
        this.manager = textRegionManager;
    }

    public I clientInfo() {
        return this.clientInfo;
    }

    public void setClientInfo(I i) {
        this.clientInfo = i;
    }

    public TextSync activeTextSync() {
        return this.activeTextSyncIndex >= 0 && this.activeTextSyncIndex < this.textSyncs.size() ? this.textSyncs.get(this.activeTextSyncIndex) : null;
    }

    public int activeTextSyncIndex() {
        return this.activeTextSyncIndex;
    }

    void setActiveTextSyncIndex(int n) {
        this.activeTextSyncIndex = n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.textSyncs.size() * 50 + 2);
        stringBuilder.append(super.toString());
        if (this.clientInfo != null) {
            stringBuilder.append(" ").append(this.clientInfo);
        }
        stringBuilder.append('\n');
        for (TextSync textSync : this.textSyncs) {
            stringBuilder.append("  ").append(textSync).append('\n');
        }
        return stringBuilder.toString();
    }
}

