/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.qnavigator.navigator;

import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.netbeans.modules.cnd.api.model.CsmListeners;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmModelListener;
import org.netbeans.modules.cnd.api.model.CsmProgressListener;
import org.netbeans.modules.cnd.qnavigator.navigator.ItemEvent;
import org.netbeans.modules.cnd.qnavigator.navigator.NavigatorModel;
import org.netbeans.modules.cnd.qnavigator.navigator.NavigatorPanelUI;
import org.netbeans.modules.cnd.utils.MIMENames;
import org.netbeans.spi.navigator.NavigatorPanel;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;

public class NavigatorComponent
implements NavigatorPanel,
LookupListener {
    private Lookup.Result<DataObject> doContext;
    private NavigatorPanelUI panelUI;
    private NavigatorModel curModel;
    private DataObject curData;

    public String getDisplayName() {
        return NbBundle.getBundle(NavigatorComponent.class).getString("LBL_members");
    }

    public String getDisplayHint() {
        return NbBundle.getBundle(NavigatorComponent.class).getString("HINT_NavigatorTopComponen");
    }

    public JComponent getComponent() {
        return this.getPanelUI();
    }

    private String getMime(DataObject dataObject) {
        FileObject fileObject = dataObject == null ? null : dataObject.getPrimaryFile();
        String string = fileObject == null ? "" : fileObject.getMIMEType();
        return string;
    }

    public synchronized void panelActivated(Lookup lookup) {
        this.doContext = lookup.lookupResult(DataObject.class);
        this.doContext.addLookupListener((LookupListener)this);
        this.resultChanged(null);
    }

    public synchronized void panelDeactivated() {
        this.doContext.removeLookupListener((LookupListener)this);
        this.doContext = null;
        this.detachFromModel(this.curModel);
        this.curModel = null;
        this.curData = null;
    }

    public synchronized void resultChanged(LookupEvent lookupEvent) {
        for (DataObject dataObject : this.doContext.allInstances()) {
            if (!MIMENames.isHeaderOrCppOrC((String)this.getMime(dataObject))) continue;
            if (dataObject.equals(this.curData)) break;
            this.detachFromModel(this.curModel);
            this.curData = dataObject;
            this.setNewContent(dataObject);
            break;
        }
    }

    public Lookup getLookup() {
        return this.panelUI.getLookup();
    }

    public void busyStart() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.getPanelUI().setBusyState(true);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    NavigatorComponent.this.getPanelUI().setBusyState(true);
                }
            });
        }
    }

    public void busyEnd() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.getPanelUI().setBusyState(false);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    NavigatorComponent.this.getPanelUI().setBusyState(false);
                }
            });
        }
    }

    public void newContentReady() {
        this.getPanelUI().newContentReady();
    }

    public void itemsChanged(ItemEvent itemEvent) {
    }

    public void itemsCleared(ItemEvent itemEvent) {
        this.getPanelUI().getContent().repaint();
    }

    private void setNewContent(final DataObject dataObject) {
        final NavigatorPanelUI navigatorPanelUI = this.getPanelUI();
        CsmModelAccessor.getModel().enqueue(new Runnable(){

            public void run() {
                NavigatorComponent.this.setNewContentImpl(dataObject, navigatorPanelUI);
            }
        }, (CharSequence)"Updating QuickNavigator Content");
    }

    private void setNewContentImpl(DataObject dataObject, NavigatorPanelUI navigatorPanelUI) {
        this.curModel = new NavigatorModel(dataObject, navigatorPanelUI, this);
        CsmListeners.getDefault().addProgressListener((CsmProgressListener)this.curModel);
        CsmListeners.getDefault().addModelListener((CsmModelListener)this.curModel);
        navigatorPanelUI.getContent().setModel(this.curModel);
        try {
            this.curModel.addBusyListener(this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.curModel.addNotify();
    }

    private void detachFromModel(NavigatorModel navigatorModel) {
        if (navigatorModel != null) {
            CsmListeners.getDefault().removeProgressListener((CsmProgressListener)navigatorModel);
            CsmListeners.getDefault().removeModelListener((CsmModelListener)navigatorModel);
            navigatorModel.removeBusyListener(this);
            navigatorModel.removeNotify();
        }
    }

    private NavigatorPanelUI getPanelUI() {
        if (this.panelUI == null) {
            this.panelUI = new NavigatorPanelUI();
        }
        return this.panelUI;
    }
}

