/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.devmodules.api;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ModuleType;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.j2ee.deployment.config.J2eeModuleAccessor;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.impl.ServerInstance;
import org.netbeans.modules.j2ee.deployment.plugins.spi.J2eePlatformImpl;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.netbeans.spi.project.libraries.support.LibrariesSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.Parameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class J2eePlatform {
    public static final String LIBRARY_TYPE = "serverlibrary";
    public static final String PROP_DISPLAY_NAME = "displayName";
    public static final String PROP_LIBRARIES = "libraries";
    public static final String PROP_CLASSPATH = "classpath";
    public static final String PROP_PLATFORM_ROOTS = "platformRoots";
    public static final String TOOL_APP_CLIENT_RUNTIME = "appClientRuntime";
    public static final String TOOL_JSR109 = "jsr109";
    public static final String TOOL_WSCOMPILE = "wscompile";
    public static final String TOOL_EMBEDDABLE_EJB = "embeddableejb";
    public static final String TOOL_WSIMPORT = "wsimport";
    public static final String TOOL_WSGEN = "wsgen";
    public static final String TOOL_WSIT = "wsit";
    public static final String TOOL_JWSDP = "jwsdp";
    public static final String TOOL_KEYSTORE = "keystore";
    public static final String TOOL_KEYSTORE_CLIENT = "keystoreClient";
    public static final String TOOL_TRUSTSTORE = "truststore";
    public static final String TOOL_TRUSTSTORE_CLIENT = "truststoreClient";
    public static final String TOOL_PROP_MAIN_CLASS = "main.class";
    public static final String TOOL_PROP_MAIN_CLASS_ARGS = "main.class.args";
    public static final String TOOL_PROP_JVM_OPTS = "jvm.opts";
    public static final String TOOL_PROP_CLIENT_JAR_LOCATION = "client.jar.location";
    public static final String CLIENT_PROP_DIST_ARCHIVE = "client.dist.archive";
    private static final String DEFAULT_ICON = "org/netbeans/modules/j2ee/deployment/impl/ui/resources/Servers.png";
    private static final Logger LOGGER = Logger.getLogger(J2eePlatform.class.getName());
    private final J2eePlatformImpl impl;
    private File[] classpathCache;
    private String currentClasspath;
    private final ServerInstance serverInstance;
    private PropertyChangeListener librariesChangeListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("content")) {
                J2eePlatform.access$002(J2eePlatform.this, null);
                String string = J2eePlatform.this.getClasspathAsString();
                if (J2eePlatform.this.currentClasspath == null || !J2eePlatform.this.currentClasspath.equals(string)) {
                    J2eePlatform.this.currentClasspath = string;
                    J2eePlatform.this.impl.firePropertyChange(J2eePlatform.PROP_CLASSPATH, null, null);
                }
            }
        }
    };

    private J2eePlatform(ServerInstance serverInstance, J2eePlatformImpl j2eePlatformImpl) {
        assert (serverInstance != null);
        this.impl = j2eePlatformImpl;
        this.serverInstance = serverInstance;
        this.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals(J2eePlatform.PROP_LIBRARIES)) {
                    LibraryImplementation[] libraryImplementationArray = J2eePlatform.this.getLibraries();
                    for (int i = 0; i < libraryImplementationArray.length; ++i) {
                        libraryImplementationArray[i].removePropertyChangeListener(J2eePlatform.this.librariesChangeListener);
                        libraryImplementationArray[i].addPropertyChangeListener(J2eePlatform.this.librariesChangeListener);
                    }
                    J2eePlatform.access$002(J2eePlatform.this, null);
                    String string = J2eePlatform.this.getClasspathAsString();
                    if (J2eePlatform.this.currentClasspath == null || !J2eePlatform.this.currentClasspath.equals(string)) {
                        J2eePlatform.this.currentClasspath = string;
                        J2eePlatform.this.impl.firePropertyChange(J2eePlatform.PROP_CLASSPATH, null, null);
                    }
                }
            }
        });
        LibraryImplementation[] libraryImplementationArray = this.getLibraries();
        for (int i = 0; i < libraryImplementationArray.length; ++i) {
            libraryImplementationArray[i].addPropertyChangeListener(this.librariesChangeListener);
        }
        this.currentClasspath = this.getClasspathAsString();
    }

    static J2eePlatform create(ServerInstance serverInstance) {
        J2eePlatformImpl j2eePlatformImpl;
        J2eePlatform j2eePlatform = serverInstance.getJ2eePlatform();
        if (j2eePlatform == null && (j2eePlatformImpl = serverInstance.getJ2eePlatformImpl()) != null) {
            j2eePlatform = new J2eePlatform(serverInstance, j2eePlatformImpl);
            serverInstance.setJ2eePlatform(j2eePlatform);
        }
        return j2eePlatform;
    }

    public File[] getClasspathEntries() {
        if (this.classpathCache == null) {
            LibraryImplementation[] libraryImplementationArray = this.impl.getLibraries();
            ArrayList<File> arrayList = new ArrayList<File>();
            for (int i = 0; i < libraryImplementationArray.length; ++i) {
                List list = libraryImplementationArray[i].getContent(PROP_CLASSPATH);
                for (URL uRL : list) {
                    File file;
                    FileObject fileObject;
                    if ("jar".equals(uRL.getProtocol())) {
                        uRL = FileUtil.getArchiveFile((URL)uRL);
                    }
                    if ((fileObject = URLMapper.findFileObject((URL)uRL)) == null || (file = FileUtil.toFile((FileObject)fileObject)) == null) continue;
                    arrayList.add(file);
                }
            }
            this.classpathCache = arrayList.toArray(new File[arrayList.size()]);
        }
        return this.classpathCache;
    }

    public File[] getToolClasspathEntries(String string) {
        return this.impl.getToolClasspathEntries(string);
    }

    public String getToolProperty(String string, String string2) {
        return this.impl.getToolProperty(string, string2);
    }

    public boolean isToolSupported(String string) {
        return this.impl.isToolSupported(string);
    }

    LibraryImplementation[] getLibraries() {
        return this.impl.getLibraries();
    }

    public String getDisplayName() {
        return this.serverInstance.getDisplayName();
    }

    public Image getIcon() {
        Image image = this.impl.getIcon();
        if (image == null) {
            image = ImageUtilities.loadImage((String)DEFAULT_ICON);
        }
        return image;
    }

    public File[] getPlatformRoots() {
        return this.impl.getPlatformRoots();
    }

    public Set getSupportedSpecVersions() {
        boolean bl = false;
        if (!$assertionsDisabled) {
            bl = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (bl) {
            LOGGER.log(Level.INFO, "Call to deprecated method " + J2eePlatform.class.getName() + "getSupportedSpecVersions", new Exception());
        }
        return this.convertProfilesToKnownSpecVersions(this.getSupportedProfiles());
    }

    public Set<String> getSupportedSpecVersions(Object object) {
        J2eeModule.Type type;
        boolean bl = false;
        if (!$assertionsDisabled) {
            bl = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (bl) {
            LOGGER.log(Level.INFO, "Call to deprecated method " + J2eePlatform.class.getName() + "getSupportedSpecVersions", new Exception());
        }
        if ((type = J2eeModule.Type.fromJsrType(object)) != null) {
            return this.convertProfilesToKnownSpecVersions(this.getSupportedProfiles(type));
        }
        return Collections.emptySet();
    }

    @NonNull
    public Set<Profile> getSupportedProfiles() {
        return this.impl.getSupportedProfiles();
    }

    @NonNull
    public Set<Profile> getSupportedProfiles(@NonNull J2eeModule.Type type) {
        return this.impl.getSupportedProfiles(type);
    }

    public Set getSupportedModuleTypes() {
        boolean bl = false;
        if (!$assertionsDisabled) {
            bl = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (bl) {
            LOGGER.log(Level.INFO, "Call to deprecated method " + J2eePlatform.class.getName() + "getSupportedModuleTypes", new Exception());
        }
        HashSet<ModuleType> hashSet = new HashSet<ModuleType>();
        for (J2eeModule.Type type : this.getSupportedTypes()) {
            ModuleType moduleType = J2eeModuleAccessor.getDefault().getJsrModuleType(type);
            if (moduleType == null) continue;
            hashSet.add(moduleType);
        }
        return hashSet;
    }

    public Set<J2eeModule.Type> getSupportedTypes() {
        return this.impl.getSupportedTypes();
    }

    public Set getSupportedJavaPlatformVersions() {
        return this.impl.getSupportedJavaPlatformVersions();
    }

    public boolean supportsProfiling() {
        return true;
    }

    public JavaPlatform getJavaPlatform() {
        return this.impl.getJavaPlatform();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.impl.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.impl.removePropertyChangeListener(propertyChangeListener);
    }

    public String toString() {
        return this.impl.getDisplayName() + " [" + this.getClasspathAsString() + "]";
    }

    public Library createLibrary(File file, String string) throws IOException {
        Parameters.notNull((CharSequence)"location", (Object)file);
        File file2 = file.getAbsoluteFile().getParentFile();
        if (file2 == null) {
            throw new IOException("Wrong library location " + file);
        }
        FileObject fileObject = FileUtil.toFileObject((File)file2);
        if (fileObject == null) {
            fileObject = FileUtil.createFolder((File)file2);
        }
        LibraryManager libraryManager = LibraryManager.forLocation((URL)file.toURI().toURL());
        HashMap<String, ArrayList<URI>> hashMap = new HashMap<String, ArrayList<URI>>();
        String string2 = this.getFolderName(fileObject, string);
        FileObject fileObject2 = FileUtil.createFolder((FileObject)fileObject, (String)string2);
        HashMap<String, Integer> hashMap2 = new HashMap<String, Integer>();
        HashMap<FileObject, String> hashMap3 = new HashMap<FileObject, String>();
        ArrayList<URI> arrayList = new ArrayList<URI>();
        hashMap.put(PROP_CLASSPATH, arrayList);
        this.copyFiles(hashMap3, hashMap2, fileObject2, string2, this.getVolumeContent(this, PROP_CLASSPATH), arrayList);
        arrayList = new ArrayList();
        hashMap.put("embedabbleejb", arrayList);
        this.copyFiles(hashMap3, hashMap2, fileObject2, string2, this.getToolClasspathEntries(TOOL_EMBEDDABLE_EJB), arrayList);
        arrayList = new ArrayList();
        hashMap.put(TOOL_WSCOMPILE, arrayList);
        this.copyFiles(hashMap3, hashMap2, fileObject2, string2, this.getToolClasspathEntries(TOOL_WSCOMPILE), arrayList);
        arrayList = new ArrayList();
        hashMap.put("wsgenerate", arrayList);
        this.copyFiles(hashMap3, hashMap2, fileObject2, string2, this.getToolClasspathEntries(TOOL_WSGEN), arrayList);
        arrayList = new ArrayList();
        hashMap.put(TOOL_WSIMPORT, arrayList);
        this.copyFiles(hashMap3, hashMap2, fileObject2, string2, this.getToolClasspathEntries(TOOL_WSIMPORT), arrayList);
        arrayList = new ArrayList();
        hashMap.put("wsinterop", arrayList);
        this.copyFiles(hashMap3, hashMap2, fileObject2, string2, this.getToolClasspathEntries(TOOL_WSIT), arrayList);
        arrayList = new ArrayList();
        hashMap.put("wsjwsdp", arrayList);
        this.copyFiles(hashMap3, hashMap2, fileObject2, string2, this.getToolClasspathEntries(TOOL_JWSDP), arrayList);
        arrayList = new ArrayList();
        hashMap.put("javadoc", arrayList);
        this.copyFiles(hashMap3, hashMap2, fileObject2, string2, this.getVolumeContent(this, "javadoc"), arrayList);
        arrayList = new ArrayList();
        hashMap.put("src", arrayList);
        this.copyFiles(hashMap3, hashMap2, fileObject2, string2, this.getVolumeContent(this, "src"), arrayList);
        return libraryManager.createURILibrary(LIBRARY_TYPE, string, hashMap);
    }

    public Lookup getLookup() {
        return this.impl.getLookup();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        J2eePlatform j2eePlatform = (J2eePlatform)object;
        return this.serverInstance.getUrl() == j2eePlatform.serverInstance.getUrl() || this.serverInstance.getUrl() != null && this.serverInstance.getUrl().equals(j2eePlatform.serverInstance.getUrl());
    }

    public int hashCode() {
        int n = 3;
        n = 71 * n + (this.serverInstance.getUrl() != null ? this.serverInstance.getUrl().hashCode() : 0);
        return n;
    }

    @NonNull
    private Set<String> convertProfilesToKnownSpecVersions(Iterable<Profile> iterable) {
        HashSet<String> hashSet = new HashSet<String>();
        for (Profile profile : iterable) {
            String string = profile.toPropertiesString();
            if (!"1.3".equals(string) && !"1.4".equals(string) && !"1.5".equals(string)) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    private FileObject[] getVolumeContent(J2eePlatform j2eePlatform, String string) {
        LibraryImplementation[] libraryImplementationArray = j2eePlatform.getLibraries();
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        for (int i = 0; i < libraryImplementationArray.length; ++i) {
            for (URL uRL : libraryImplementationArray[i].getContent(string)) {
                FileObject fileObject;
                if ("jar".equals(uRL.getProtocol())) {
                    uRL = FileUtil.getArchiveFile((URL)uRL);
                }
                if ((fileObject = URLMapper.findFileObject((URL)uRL)) == null) continue;
                arrayList.add(fileObject);
            }
        }
        return arrayList.toArray(new FileObject[arrayList.size()]);
    }

    private void copyFiles(Map<FileObject, String> map, Map<String, Integer> map2, FileObject fileObject, String string, File[] fileArray, List<URI> list) throws IOException {
        if (fileArray == null) {
            return;
        }
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        for (File file : fileArray) {
            File file2 = FileUtil.normalizeFile((File)file);
            FileObject fileObject2 = FileUtil.toFileObject((File)file2);
            if (fileObject2 != null) {
                arrayList.add(fileObject2);
                continue;
            }
            LOGGER.log(Level.INFO, "Could not find " + file);
        }
        this.copyFiles(map, map2, fileObject, string, arrayList.toArray(new FileObject[arrayList.size()]), list);
    }

    private void copyFiles(Map<FileObject, String> map, Map<String, Integer> map2, FileObject fileObject, String string, FileObject[] fileObjectArray, List<URI> list) throws IOException {
        if (fileObjectArray == null) {
            return;
        }
        for (FileObject fileObject2 : fileObjectArray) {
            Object object;
            Object object2;
            if (!map.containsKey(fileObject2)) {
                object2 = fileObject2.getName() + this.getEntrySuffix(fileObject2.getNameExt(), map2);
                if (fileObject2.isFolder()) {
                    object = FileUtil.createFolder((FileObject)fileObject, (String)object2);
                    this.copyFolder(fileObject2, (FileObject)object);
                } else {
                    FileUtil.copyFile((FileObject)fileObject2, (FileObject)fileObject, (String)object2, (String)fileObject2.getExt());
                }
                map.put(fileObject2, fileObject2.getNameExt().replace(fileObject2.getName(), (CharSequence)object2));
            }
            object2 = fileObject.getFileObject(map.get(fileObject2));
            object = LibrariesSupport.convertFilePathToURI((String)(string + File.separator + map.get(fileObject2)));
            if (FileUtil.isArchiveFile((FileObject)object2)) {
                object = LibrariesSupport.getArchiveRoot((URI)object);
            }
            if (list.contains(object)) continue;
            list.add((URI)object);
        }
    }

    private void copyFolder(FileObject fileObject, FileObject fileObject2) throws IOException {
        assert (fileObject.isFolder()) : "Source is not a folder";
        assert (fileObject2.isFolder()) : "Source is not a folder";
        for (FileObject fileObject3 : fileObject.getChildren()) {
            if (fileObject3.isFolder()) {
                FileObject fileObject4 = FileUtil.createFolder((FileObject)fileObject2, (String)fileObject3.getNameExt());
                this.copyFolder(fileObject3, fileObject4);
                continue;
            }
            FileUtil.copyFile((FileObject)fileObject3, (FileObject)fileObject2, (String)fileObject3.getName(), (String)fileObject3.getExt());
        }
    }

    private String getEntrySuffix(String string, Map<String, Integer> map) {
        Integer n = map.get(string);
        n = n == null ? Integer.valueOf(0) : Integer.valueOf(n + 1);
        map.put(string, n);
        if (n == 0) {
            return "";
        }
        return "-" + n.toString();
    }

    private String getFolderName(FileObject fileObject, String string) {
        String string2;
        int n = 2;
        String string3 = string2 = string;
        while (fileObject.getFileObject(string3) != null) {
            string3 = string2 + "-" + n;
            ++n;
        }
        return string3;
    }

    private String getClasspathAsString() {
        File[] fileArray = this.getClasspathEntries();
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("path.separator");
        for (int i = 0; i < fileArray.length; ++i) {
            stringBuffer.append(fileArray[i].getAbsolutePath());
            if (i + 1 >= fileArray.length) continue;
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    static /* synthetic */ File[] access$002(J2eePlatform j2eePlatform, File[] fileArray) {
        j2eePlatform.classpathCache = fileArray;
        return fileArray;
    }
}

