/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.factories.DeploymentFactory;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.j2ee.deployment.impl.ServerInstance;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.lookup.Lookups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerInstanceLookup
extends Lookup {
    private final ServerInstance instance;
    private final DeploymentFactory factory;
    private final Target target;

    public ServerInstanceLookup(ServerInstance serverInstance, DeploymentFactory deploymentFactory, Target target) {
        assert (serverInstance != null);
        assert (deploymentFactory != null);
        this.instance = serverInstance;
        this.factory = deploymentFactory;
        this.target = target;
    }

    public <T> T lookup(Class<T> clazz) {
        if (DeploymentFactory.class.isAssignableFrom(clazz)) {
            return clazz.cast(this.factory);
        }
        if (DeploymentManager.class.isAssignableFrom(clazz)) {
            if (this.instance.isConnected()) {
                return clazz.cast(this.instance.getDeploymentManager());
            }
            try {
                return clazz.cast(this.instance.getDisconnectedDeploymentManager());
            }
            catch (DeploymentManagerCreationException deploymentManagerCreationException) {
                Exceptions.printStackTrace((Throwable)deploymentManagerCreationException);
            }
        } else if (this.target != null && Target.class.isAssignableFrom(clazz)) {
            return clazz.cast(this.target);
        }
        return null;
    }

    public <T> Lookup.Result<T> lookup(Lookup.Template<T> template) {
        if (DeploymentFactory.class.isAssignableFrom(template.getType())) {
            return new SimpleResult<DeploymentFactory>(this.factory);
        }
        if (DeploymentManager.class.isAssignableFrom(template.getType())) {
            return new DeploymentManagerResult(this.instance);
        }
        if (Target.class.isAssignableFrom(template.getType())) {
            return new SimpleResult<Target>(this.target);
        }
        return new EmptyResult();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DeploymentManagerResult
    extends AbstractResult<DeploymentManager>
    implements ChangeListener {
        private final ServerInstance instance;
        private final List<LookupListener> listeners = new ArrayList<LookupListener>();

        public DeploymentManagerResult(ServerInstance serverInstance) {
            this.instance = serverInstance;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addLookupListener(LookupListener lookupListener) {
            if (lookupListener == null) {
                return;
            }
            List<LookupListener> list = this.listeners;
            synchronized (list) {
                if (this.listeners.isEmpty()) {
                    this.instance.addManagerChangeListener(this);
                }
                this.listeners.add(lookupListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeLookupListener(LookupListener lookupListener) {
            if (lookupListener == null) {
                return;
            }
            List<LookupListener> list = this.listeners;
            synchronized (list) {
                this.listeners.remove(lookupListener);
                if (this.listeners.isEmpty()) {
                    this.instance.removeManagerChangeListener(this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            ArrayList<LookupListener> arrayList = new ArrayList<LookupListener>();
            List<LookupListener> list = this.listeners;
            synchronized (list) {
                arrayList.addAll(this.listeners);
            }
            for (LookupListener lookupListener : arrayList) {
                lookupListener.resultChanged(new LookupEvent((Lookup.Result)this));
            }
        }

        @Override
        public DeploymentManager getInstance() {
            if (this.instance.isConnected()) {
                return this.instance.getDeploymentManager();
            }
            try {
                return this.instance.getDisconnectedDeploymentManager();
            }
            catch (DeploymentManagerCreationException deploymentManagerCreationException) {
                Exceptions.printStackTrace((Throwable)deploymentManagerCreationException);
                return null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SimpleResult<T>
    extends AbstractResult<T> {
        private final T instance;

        public SimpleResult(T t) {
            this.instance = t;
        }

        public void addLookupListener(LookupListener lookupListener) {
        }

        public void removeLookupListener(LookupListener lookupListener) {
        }

        @Override
        public T getInstance() {
            return this.instance;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class AbstractResult<T>
    extends Lookup.Result<T> {
        public abstract T getInstance();

        public synchronized Collection<? extends T> allInstances() {
            T t = this.getInstance();
            if (t == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(t);
        }

        public synchronized Set<Class<? extends T>> allClasses() {
            T t = this.getInstance();
            if (t == null) {
                return Collections.emptySet();
            }
            Class<?> clazz = t.getClass();
            return Collections.singleton(clazz);
        }

        public synchronized Collection<? extends Lookup.Item<T>> allItems() {
            T t = this.getInstance();
            if (t == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(Lookups.lookupItem(t, null));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EmptyResult<T>
    extends Lookup.Result<T> {
        private EmptyResult() {
        }

        public void addLookupListener(LookupListener lookupListener) {
        }

        public void removeLookupListener(LookupListener lookupListener) {
        }

        public Collection<? extends T> allInstances() {
            return Collections.emptyList();
        }
    }
}

