/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl.bridge;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.InstanceListener;
import org.netbeans.modules.j2ee.deployment.impl.Server;
import org.netbeans.modules.j2ee.deployment.impl.ServerInstance;
import org.netbeans.modules.j2ee.deployment.impl.ServerRegistry;
import org.netbeans.modules.j2ee.deployment.impl.bridge.BridgingServerInstance;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.spi.server.ServerInstanceProvider;
import org.openide.util.ChangeSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BridgingServerInstanceProvider
implements ServerInstanceProvider,
InstanceListener {
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private final Server server;
    private Map<ServerInstance, BridgingServerInstance> instances = new HashMap<ServerInstance, BridgingServerInstance>();

    public BridgingServerInstanceProvider(Server server) {
        assert (server != null) : "Server must not be null";
        this.server = server;
    }

    public final void addInstanceListener() {
        ServerRegistry.getInstance().addInstanceListener(this);
    }

    public final void removeInstanceListener() {
        ServerRegistry.getInstance().removeInstanceListener(this);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    public void changeDefaultInstance(String string, String string2) {
    }

    @Override
    public void instanceAdded(String string) {
        if (this.server.handlesUri(string)) {
            this.changeSupport.fireChange();
        }
    }

    @Override
    public void instanceRemoved(String string) {
        InstanceProperties instanceProperties = InstanceProperties.getInstanceProperties(string);
        if (this.server.handlesUri(string) && (instanceProperties == null || this.isRegisteredWithUI(instanceProperties))) {
            this.changeSupport.fireChange();
        }
    }

    public synchronized List<org.netbeans.api.server.ServerInstance> getInstances() {
        this.refreshCache();
        ArrayList<org.netbeans.api.server.ServerInstance> arrayList = new ArrayList<org.netbeans.api.server.ServerInstance>(this.instances.size());
        for (BridgingServerInstance bridgingServerInstance : this.instances.values()) {
            arrayList.add(bridgingServerInstance.getCommonInstance());
        }
        return arrayList;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        BridgingServerInstanceProvider bridgingServerInstanceProvider = (BridgingServerInstanceProvider)object;
        return this.server == bridgingServerInstanceProvider.server || this.server != null && this.server.equals(bridgingServerInstanceProvider.server);
    }

    public int hashCode() {
        int n = 3;
        n = 67 * n + (this.server != null ? this.server.hashCode() : 0);
        return n;
    }

    public synchronized org.netbeans.api.server.ServerInstance getBridge(ServerInstance serverInstance) {
        this.refreshCache();
        BridgingServerInstance bridgingServerInstance = this.instances.get(serverInstance);
        return bridgingServerInstance == null ? null : bridgingServerInstance.getCommonInstance();
    }

    private synchronized void refreshCache() {
        ArrayList<ServerInstance> arrayList = new ArrayList<ServerInstance>(this.instances.keySet());
        for (ServerInstance serverInstance : ServerRegistry.getInstance().getServerInstances()) {
            if (!serverInstance.getServer().equals(this.server) || !this.isRegisteredWithUI(serverInstance.getInstanceProperties())) continue;
            if (!this.instances.containsKey(serverInstance)) {
                this.instances.put(serverInstance, BridgingServerInstance.createInstance(serverInstance));
                continue;
            }
            arrayList.remove(serverInstance);
        }
        this.instances.keySet().removeAll(arrayList);
    }

    private boolean isRegisteredWithUI(InstanceProperties instanceProperties) {
        String string = instanceProperties.getProperty("registeredWithoutUI");
        if (string == null) {
            return true;
        }
        return Boolean.valueOf(string) == false;
    }
}

