/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl.ui.actions;

import org.netbeans.modules.j2ee.deployment.impl.ServerException;
import org.netbeans.modules.j2ee.deployment.impl.ServerInstance;
import org.netbeans.modules.j2ee.deployment.impl.ServerRegistry;
import org.netbeans.modules.j2ee.deployment.impl.ui.ProgressUI;
import org.netbeans.modules.j2ee.deployment.impl.ui.actions.DebugAction;
import org.netbeans.modules.j2ee.deployment.profiler.api.ProfilerServerSettings;
import org.netbeans.modules.j2ee.deployment.profiler.spi.Profiler;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.NodeAction;

public class ProfileAction
extends NodeAction {
    public String getName() {
        return NbBundle.getMessage(DebugAction.class, (String)"LBL_Profile");
    }

    protected void performAction(Node[] nodeArray) {
        ProfileAction.performActionImpl(nodeArray);
    }

    protected boolean enable(Node[] nodeArray) {
        return ProfileAction.enableImpl(nodeArray);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    private static void performActionImpl(Node[] nodeArray) {
        if (nodeArray.length != 1) {
            return;
        }
        final ServerInstance serverInstance = (ServerInstance)nodeArray[0].getCookie(ServerInstance.class);
        if (serverInstance != null) {
            Profiler profiler = ServerRegistry.getProfiler();
            if (profiler == null) {
                return;
            }
            final ProfilerServerSettings profilerServerSettings = profiler.getSettings(serverInstance.getUrl());
            if (profilerServerSettings == null) {
                return;
            }
            RequestProcessor.getDefault().post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    String string = NbBundle.getMessage(DebugAction.class, (String)"LBL_Profiling", (Object)serverInstance.getDisplayName());
                    ProgressUI progressUI = new ProgressUI(string, false);
                    try {
                        progressUI.start();
                        serverInstance.startProfile(profilerServerSettings, false, progressUI);
                    }
                    catch (ServerException serverException) {
                        String string2 = serverException.getLocalizedMessage();
                        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string2, 0);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                    }
                    finally {
                        progressUI.finish();
                    }
                }
            });
        }
    }

    private static boolean enableImpl(Node[] nodeArray) {
        if (nodeArray.length != 1) {
            return false;
        }
        ServerInstance serverInstance = (ServerInstance)nodeArray[0].getCookie(ServerInstance.class);
        return serverInstance != null && serverInstance.getServerState() == 2 && serverInstance.isProfileSupported();
    }
}

