/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.server.impl.jcdi;

import com.sun.jersey.api.container.ContainerException;
import com.sun.jersey.core.spi.component.ComponentContext;
import com.sun.jersey.core.spi.component.ComponentScope;
import com.sun.jersey.core.spi.component.ioc.IoCComponentProcessor;
import com.sun.jersey.core.spi.component.ioc.IoCComponentProcessorFactory;
import com.sun.jersey.core.spi.component.ioc.IoCComponentProcessorFactoryInitializer;
import com.sun.jersey.core.spi.component.ioc.IoCComponentProvider;
import com.sun.jersey.core.spi.component.ioc.IoCComponentProviderFactory;
import com.sun.jersey.core.spi.component.ioc.IoCDestroyable;
import com.sun.jersey.core.spi.component.ioc.IoCFullyManagedComponentProvider;
import com.sun.jersey.core.spi.component.ioc.IoCInstantiatedComponentProvider;
import com.sun.jersey.server.impl.jcdi.JCDIComponentExtension;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.ManagedBean;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.AmbiguousResolutionException;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.ProcessInjectionTarget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCDIComponentProviderFactory
implements IoCComponentProviderFactory,
IoCComponentProcessorFactoryInitializer {
    private static final Logger LOGGER = Logger.getLogger(JCDIComponentProviderFactory.class.getName());
    private final BeanManager bm;
    private final Map<Class<? extends Annotation>, ComponentScope> scopeMap = this.createScopeMap();

    public JCDIComponentProviderFactory(Object bm) {
        this.bm = (BeanManager)bm;
    }

    public void init(IoCComponentProcessorFactory cpf) {
        JCDIComponentExtension e = this.getRef(JCDIComponentExtension.class);
        if (e == null) {
            throw new ContainerException("Reference to " + JCDIComponentExtension.class + " is null");
        }
        for (ProcessInjectionTarget pit : e.getProcessInjectionTargets()) {
            IoCComponentProcessor icp;
            Class s;
            Class c = pit.getAnnotatedType().getJavaClass();
            Bean<?> b = this.getBean(c);
            if (b == null || (s = b.getScope()) == Dependent.class && !c.isAnnotationPresent(ManagedBean.class) || (icp = cpf.get(c, this.getComponentScope(b))) == null) continue;
            LOGGER.info("Adapting InjectionTarget for " + c.getName() + " in the scope " + b.getScope());
            final InjectionTarget it = pit.getInjectionTarget();
            InjectionTarget nit = new InjectionTarget(){

                public void inject(Object t, CreationalContext cc) {
                    it.inject(t, cc);
                    icp.postConstruct(t);
                }

                public void postConstruct(Object t) {
                    it.postConstruct(t);
                }

                public void preDestroy(Object t) {
                    it.preDestroy(t);
                }

                public Object produce(CreationalContext cc) {
                    return it.produce(cc);
                }

                public void dispose(Object t) {
                    it.dispose(t);
                }

                public Set getInjectionPoints() {
                    return it.getInjectionPoints();
                }
            };
            pit.setInjectionTarget(nit);
        }
        e.clear();
    }

    public IoCComponentProvider getComponentProvider(Class<?> c) {
        return this.getComponentProvider(null, c);
    }

    public IoCComponentProvider getComponentProvider(ComponentContext cc, final Class<?> c) {
        final Bean<?> b = this.getBean(c);
        if (b == null) {
            return null;
        }
        Class s = b.getScope();
        ComponentScope cs = this.getComponentScope(b);
        if (s == Dependent.class) {
            if (!c.isAnnotationPresent(ManagedBean.class)) {
                return null;
            }
            LOGGER.info("Binding the JCDI managed-bean class " + c.getName() + " in the scope " + s.getName() + " to JCDIComponentProviderFactory");
            return new ComponentProviderDestroyable(){

                public Object getInjectableInstance(Object o) {
                    return o;
                }

                public Object getInstance() {
                    CreationalContext bcc = JCDIComponentProviderFactory.this.bm.createCreationalContext((Contextual)b);
                    return c.cast(JCDIComponentProviderFactory.this.bm.getReference(b, (Type)c, bcc));
                }

                public void destroy(Object o) {
                    CreationalContext cc = JCDIComponentProviderFactory.this.bm.createCreationalContext((Contextual)b);
                    b.destroy(o, cc);
                }
            };
        }
        LOGGER.info("Binding the JCDI managed class " + c.getName() + " in the scope " + s.getName() + " to JCDIComponentProviderFactory in the scope " + cs);
        return new IoCFullyManagedComponentProvider(){

            public Object getInstance() {
                CreationalContext bcc = JCDIComponentProviderFactory.this.bm.createCreationalContext((Contextual)b);
                return c.cast(JCDIComponentProviderFactory.this.bm.getReference(b, (Type)c, bcc));
            }
        };
    }

    private Bean<?> getBean(Class<?> c) {
        Set bs = this.bm.getBeans(c, new Annotation[0]);
        if (bs.isEmpty()) {
            return null;
        }
        try {
            return this.bm.resolve(bs);
        }
        catch (AmbiguousResolutionException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
            return null;
        }
    }

    private <T> T getRef(Class<T> c) {
        Bean<?> b = this.getBean(c);
        if (b == null) {
            return null;
        }
        CreationalContext cc = this.bm.createCreationalContext(b);
        return c.cast(this.bm.getReference(b, c, cc));
    }

    private ComponentScope getComponentScope(Bean<?> b) {
        ComponentScope cs = this.scopeMap.get(b.getScope());
        return cs != null ? cs : ComponentScope.Undefined;
    }

    private Map<Class<? extends Annotation>, ComponentScope> createScopeMap() {
        HashMap<Class<? extends Annotation>, ComponentScope> m = new HashMap<Class<? extends Annotation>, ComponentScope>();
        m.put(ApplicationScoped.class, ComponentScope.Singleton);
        m.put(RequestScoped.class, ComponentScope.PerRequest);
        m.put(Dependent.class, ComponentScope.PerRequest);
        return m;
    }

    private static interface ComponentProviderDestroyable
    extends IoCInstantiatedComponentProvider,
    IoCDestroyable {
    }
}

