/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.projects;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.AssertTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.LineMap;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreeScanner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ExpressionScanner
extends TreeScanner<List<Tree>, ExpressionsInfo> {
    private int lineNumber;
    private CompilationUnitTree tree;
    private SourcePositions positions;
    private LineMap lineMap;
    private boolean checkBounds = true;

    public ExpressionScanner(int n, CompilationUnitTree compilationUnitTree, SourcePositions sourcePositions) {
        this.tree = compilationUnitTree;
        this.lineNumber = n;
        this.positions = sourcePositions;
        this.lineMap = compilationUnitTree.getLineMap();
    }

    private boolean acceptsTree(Tree tree) {
        if (!this.checkBounds) {
            return true;
        }
        int n = (int)this.lineMap.getLineNumber(this.positions.getStartPosition(this.tree, tree));
        return n == this.lineNumber;
    }

    private boolean isCurrentTree(Tree tree) {
        int n = (int)this.lineMap.getLineNumber(this.positions.getStartPosition(this.tree, tree));
        if ((long)n == -1L) {
            return false;
        }
        int n2 = (int)this.lineMap.getLineNumber(this.positions.getEndPosition(this.tree, tree));
        if ((long)n2 == -1L) {
            return false;
        }
        return n <= this.lineNumber && this.lineNumber <= n2;
    }

    @Override
    public List<Tree> reduce(List<Tree> list, List<Tree> list2) {
        if (list == null || list.size() == 0) {
            return list2;
        }
        if (list2 == null || list2.size() == 0) {
            return list;
        }
        list.addAll(list2);
        return list;
    }

    @Override
    public List<Tree> scan(Iterable<? extends Tree> iterable, ExpressionsInfo expressionsInfo) {
        List<Tree> list = null;
        if (iterable != null) {
            boolean bl = true;
            for (Tree tree : iterable) {
                list = bl ? (List<Tree>)this.scan(tree, expressionsInfo) : this.reduce(list, (List)this.scan(tree, expressionsInfo));
                bl = false;
            }
        }
        return list;
    }

    private List<Tree> scan(Tree tree, Tree tree2, ExpressionsInfo expressionsInfo) {
        List<Tree> list = (List<Tree>)this.scan(tree, expressionsInfo);
        list = this.reduce(list, (List)this.scan(tree2, expressionsInfo));
        return list;
    }

    @Override
    public List<Tree> visitAnnotation(AnnotationTree annotationTree, ExpressionsInfo expressionsInfo) {
        return null;
    }

    @Override
    public List<Tree> visitMethodInvocation(MethodInvocationTree methodInvocationTree, ExpressionsInfo expressionsInfo) {
        List<Tree> list = this.scan((Iterable<? extends Tree>)methodInvocationTree.getTypeArguments(), expressionsInfo);
        list = this.reduce(list, (List)this.scan(methodInvocationTree.getMethodSelect(), expressionsInfo));
        if ((list = this.reduce(list, this.scan((Iterable<? extends Tree>)methodInvocationTree.getArguments(), expressionsInfo))) == null) {
            list = new ArrayList<Tree>();
        }
        list.add(methodInvocationTree);
        return list;
    }

    @Override
    public List<Tree> visitAssert(AssertTree assertTree, ExpressionsInfo expressionsInfo) {
        if (this.acceptsTree(assertTree)) {
            List<Tree> list = (List<Tree>)this.scan(assertTree.getCondition(), expressionsInfo);
            list = this.reduce(list, (List)this.scan(assertTree.getDetail(), expressionsInfo));
            return list;
        }
        return null;
    }

    @Override
    public List<Tree> visitAssignment(AssignmentTree assignmentTree, ExpressionsInfo expressionsInfo) {
        return this.scan(assignmentTree.getVariable(), assignmentTree.getExpression(), expressionsInfo);
    }

    @Override
    public List<Tree> visitCompoundAssignment(CompoundAssignmentTree compoundAssignmentTree, ExpressionsInfo expressionsInfo) {
        return this.scan(compoundAssignmentTree.getVariable(), compoundAssignmentTree.getExpression(), expressionsInfo);
    }

    @Override
    public List<Tree> visitBinary(BinaryTree binaryTree, ExpressionsInfo expressionsInfo) {
        return this.scan(binaryTree.getLeftOperand(), binaryTree.getRightOperand(), expressionsInfo);
    }

    @Override
    public List<Tree> visitCase(CaseTree caseTree, ExpressionsInfo expressionsInfo) {
        List<Tree> list = (List<Tree>)this.scan(caseTree.getExpression(), expressionsInfo);
        list = this.reduce(list, this.scan((Iterable<? extends Tree>)caseTree.getStatements(), expressionsInfo));
        return list;
    }

    @Override
    public List<Tree> visitConditionalExpression(ConditionalExpressionTree conditionalExpressionTree, ExpressionsInfo expressionsInfo) {
        List list = (List)this.scan(conditionalExpressionTree.getCondition(), expressionsInfo);
        Tree tree = null;
        if (list != null) {
            tree = (Tree)list.get(list.size() - 1);
        }
        List list2 = (List)this.scan(conditionalExpressionTree.getTrueExpression(), expressionsInfo);
        List list3 = (List)this.scan(conditionalExpressionTree.getFalseExpression(), expressionsInfo);
        if (tree != null) {
            if (list2 != null) {
                expressionsInfo.addNextExpression(tree, (Tree)list2.get(0));
            }
            if (list3 != null) {
                expressionsInfo.addNextExpression(tree, (Tree)list3.get(0));
            }
        }
        return this.reduce(this.reduce(list, list2), list3);
    }

    @Override
    public List<Tree> visitDoWhileLoop(DoWhileLoopTree doWhileLoopTree, ExpressionsInfo expressionsInfo) {
        List list = (List)this.scan(doWhileLoopTree.getStatement(), expressionsInfo);
        List list2 = null;
        if (this.acceptsTree(doWhileLoopTree.getCondition())) {
            list2 = (List)this.scan(doWhileLoopTree.getCondition(), expressionsInfo);
        }
        if (list2 != null && list2.size() > 0 && list != null && list.size() > 0) {
            Tree tree = (Tree)list2.get(list2.size() - 1);
            expressionsInfo.addNextExpression(tree, (Tree)list.get(0));
        }
        return this.reduce(list, list2);
    }

    @Override
    public List<Tree> visitExpressionStatement(ExpressionStatementTree expressionStatementTree, ExpressionsInfo expressionsInfo) {
        if (this.acceptsTree(expressionStatementTree)) {
            return (List)this.scan(expressionStatementTree.getExpression(), expressionsInfo);
        }
        return null;
    }

    @Override
    public List<Tree> visitEnhancedForLoop(EnhancedForLoopTree enhancedForLoopTree, ExpressionsInfo expressionsInfo) {
        List list = null;
        if (this.acceptsTree(enhancedForLoopTree.getExpression())) {
            list = (List)this.scan(enhancedForLoopTree.getExpression(), expressionsInfo);
        }
        List list2 = (List)this.scan(enhancedForLoopTree.getStatement(), expressionsInfo);
        if (list != null && list.size() > 0 && list2 != null && list2.size() > 0) {
            expressionsInfo.addNextExpression((Tree)list.get(list.size() - 1), (Tree)list2.get(0));
            expressionsInfo.addNextExpression((Tree)list2.get(list2.size() - 1), (Tree)list.get(0));
        }
        return this.reduce(list, list2);
    }

    @Override
    public List<Tree> visitForLoop(ForLoopTree forLoopTree, ExpressionsInfo expressionsInfo) {
        if (!this.isCurrentTree(forLoopTree)) {
            return null;
        }
        List<Tree> list = this.scan((Iterable<? extends Tree>)forLoopTree.getInitializer(), expressionsInfo);
        this.checkBounds = false;
        List list2 = (List)this.scan(forLoopTree.getCondition(), expressionsInfo);
        List<Tree> list3 = this.scan((Iterable<? extends Tree>)forLoopTree.getUpdate(), expressionsInfo);
        this.checkBounds = true;
        List list4 = null;
        if (this.acceptsTree(forLoopTree.getCondition())) {
            list4 = (List)this.scan(forLoopTree.getCondition(), expressionsInfo);
        }
        List<Tree> list5 = this.scan((Iterable<? extends Tree>)forLoopTree.getUpdate(), expressionsInfo);
        List list6 = (List)this.scan(forLoopTree.getStatement(), expressionsInfo);
        if (list != null) {
            if (list2 != null) {
                expressionsInfo.addNextExpression(list.get(list.size() - 1), (Tree)list2.get(0));
            } else if (list6 != null) {
                expressionsInfo.addNextExpression(list.get(list.size() - 1), (Tree)list6.get(0));
            } else if (list3 != null) {
                expressionsInfo.addNextExpression(list.get(list.size() - 1), list3.get(0));
            }
        }
        if (list4 != null) {
            if (list6 != null) {
                expressionsInfo.addNextExpression((Tree)list4.get(list4.size() - 1), (Tree)list6.get(0));
            } else if (list3 != null) {
                expressionsInfo.addNextExpression((Tree)list4.get(list4.size() - 1), list3.get(0));
            }
        }
        if (list6 != null) {
            if (list3 != null) {
                expressionsInfo.addNextExpression((Tree)list6.get(list6.size() - 1), list3.get(0));
            } else if (list2 != null) {
                expressionsInfo.addNextExpression((Tree)list6.get(list6.size() - 1), (Tree)list2.get(0));
            }
        }
        if (list5 != null) {
            if (list2 != null) {
                expressionsInfo.addNextExpression(list5.get(list5.size() - 1), (Tree)list2.get(0));
            } else if (list6 != null) {
                expressionsInfo.addNextExpression(list5.get(list5.size() - 1), (Tree)list6.get(0));
            }
        }
        return this.reduce(this.reduce(this.reduce(list, list4), list6), list5);
    }

    @Override
    public List<Tree> visitIf(IfTree ifTree, ExpressionsInfo expressionsInfo) {
        List list = null;
        Tree tree = null;
        if (this.acceptsTree(ifTree) && (list = (List)this.scan(ifTree.getCondition(), expressionsInfo)) != null) {
            tree = (Tree)list.get(list.size() - 1);
        }
        StatementTree statementTree = ifTree.getThenStatement();
        StatementTree statementTree2 = ifTree.getElseStatement();
        List list2 = null;
        if (this.isCurrentTree(statementTree)) {
            list2 = (List)this.scan(statementTree, expressionsInfo);
            if (tree != null && list2 != null) {
                expressionsInfo.addNextExpression(tree, (Tree)list2.get(0));
            }
        }
        List list3 = null;
        if (this.isCurrentTree(statementTree2)) {
            list3 = (List)this.scan(statementTree2, expressionsInfo);
            if (tree != null && list3 != null) {
                expressionsInfo.addNextExpression(tree, (Tree)list3.get(0));
            }
        }
        return this.reduce(this.reduce(list, list2), list3);
    }

    @Override
    public List<Tree> visitArrayAccess(ArrayAccessTree arrayAccessTree, ExpressionsInfo expressionsInfo) {
        return this.scan(arrayAccessTree.getExpression(), arrayAccessTree.getIndex(), expressionsInfo);
    }

    @Override
    public List<Tree> visitModifiers(ModifiersTree modifiersTree, ExpressionsInfo expressionsInfo) {
        return null;
    }

    @Override
    public List<Tree> visitNewArray(NewArrayTree newArrayTree, ExpressionsInfo expressionsInfo) {
        List<Tree> list = (List<Tree>)this.scan(newArrayTree.getType(), expressionsInfo);
        list = this.reduce(list, this.scan((Iterable<? extends Tree>)newArrayTree.getDimensions(), expressionsInfo));
        list = this.reduce(list, this.scan((Iterable<? extends Tree>)newArrayTree.getInitializers(), expressionsInfo));
        return list;
    }

    @Override
    public List<Tree> visitNewClass(NewClassTree newClassTree, ExpressionsInfo expressionsInfo) {
        List<Tree> list = this.scan(newClassTree.getEnclosingExpression(), newClassTree.getIdentifier(), expressionsInfo);
        list = this.reduce(list, this.scan((Iterable<? extends Tree>)newClassTree.getArguments(), expressionsInfo));
        if ((list = this.reduce(list, (List)this.scan(newClassTree.getClassBody(), expressionsInfo))) == null) {
            list = new ArrayList<Tree>();
        }
        list.add(newClassTree);
        return list;
    }

    @Override
    public List<Tree> visitSwitch(SwitchTree switchTree, ExpressionsInfo expressionsInfo) {
        List list = null;
        if (this.acceptsTree(switchTree)) {
            list = (List)this.scan(switchTree.getExpression(), expressionsInfo);
        }
        return this.reduce(list, this.scan((Iterable<? extends Tree>)switchTree.getCases(), expressionsInfo));
    }

    @Override
    public List<Tree> visitSynchronized(SynchronizedTree synchronizedTree, ExpressionsInfo expressionsInfo) {
        List list = null;
        if (this.acceptsTree(synchronizedTree)) {
            list = (List)this.scan(synchronizedTree.getExpression(), expressionsInfo);
        }
        return this.reduce(list, (List)this.scan(synchronizedTree.getBlock(), expressionsInfo));
    }

    @Override
    public List<Tree> visitThrow(ThrowTree throwTree, ExpressionsInfo expressionsInfo) {
        List list = null;
        if (this.acceptsTree(throwTree)) {
            list = (List)this.scan(throwTree.getExpression(), expressionsInfo);
        }
        return list;
    }

    @Override
    public List<Tree> visitParameterizedType(ParameterizedTypeTree parameterizedTypeTree, ExpressionsInfo expressionsInfo) {
        return null;
    }

    @Override
    public List<Tree> visitTypeCast(TypeCastTree typeCastTree, ExpressionsInfo expressionsInfo) {
        return (List)this.scan(typeCastTree.getExpression(), expressionsInfo);
    }

    @Override
    public List<Tree> visitInstanceOf(InstanceOfTree instanceOfTree, ExpressionsInfo expressionsInfo) {
        return this.scan(instanceOfTree.getExpression(), instanceOfTree.getType(), expressionsInfo);
    }

    @Override
    public List<Tree> visitUnary(UnaryTree unaryTree, ExpressionsInfo expressionsInfo) {
        return (List)this.scan(unaryTree.getExpression(), expressionsInfo);
    }

    @Override
    public List<Tree> visitVariable(VariableTree variableTree, ExpressionsInfo expressionsInfo) {
        if (this.acceptsTree(variableTree)) {
            return (List)this.scan(variableTree.getInitializer(), expressionsInfo);
        }
        return null;
    }

    @Override
    public List<Tree> visitWhileLoop(WhileLoopTree whileLoopTree, ExpressionsInfo expressionsInfo) {
        List list = null;
        if (this.acceptsTree(whileLoopTree.getCondition())) {
            list = (List)this.scan(whileLoopTree.getCondition(), expressionsInfo);
        }
        List list2 = (List)this.scan(whileLoopTree.getStatement(), expressionsInfo);
        if (list != null && list2 != null && list2.size() > 0) {
            expressionsInfo.addNextExpression((Tree)list2.get(list2.size() - 1), (Tree)list.get(0));
        }
        return this.reduce(list, list2);
    }

    @Override
    public List<Tree> visitReturn(ReturnTree returnTree, ExpressionsInfo expressionsInfo) {
        if (this.acceptsTree(returnTree)) {
            return (List)this.scan(returnTree.getExpression(), expressionsInfo);
        }
        return null;
    }

    @Override
    public List<Tree> visitOther(Tree tree, ExpressionsInfo expressionsInfo) {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ExpressionsInfo {
        private Map<Tree, Set<Tree>> nextExpressions = new HashMap<Tree, Set<Tree>>();
        Stack<StatementTree> wrappingStatements = new Stack();

        synchronized void addNextExpression(Tree tree, Tree tree2) {
            Set<Tree> set = this.nextExpressions.get(tree);
            if (set == null) {
                set = new HashSet<Tree>();
                this.nextExpressions.put(tree, set);
            }
            set.add(tree2);
        }

        synchronized Set<Tree> getNextExpressions(Tree tree) {
            Set<Tree> set = this.nextExpressions.get(tree);
            if (set == null) {
                return Collections.emptySet();
            }
            return set;
        }
    }
}

