/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.projects;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventListener;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.modules.debugger.jpda.projects.MainProjectManager;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class SourcesTabs
extends JTabbedPane {
    private PropertyChangeListener mainProjectListener;
    private DebuggerManagerListener debuggerListener;

    public SourcesTabs() {
        this.initComponent();
        this.mainProjectListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Project project = MainProjectManager.getDefault().getMainProject();
                SourcesTabs.this.setProjectTitle(project);
            }
        };
        MainProjectManager.getDefault().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.mainProjectListener, (Object)MainProjectManager.getDefault()));
        this.debuggerListener = new DebuggerManagerAdapter(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if ("currentSession".equals(string)) {
                    Session session = DebuggerManager.getDebuggerManager().getCurrentSession();
                    SourcesTabs.this.setSessionTitle(session);
                }
            }
        };
        DebuggerManager.getDebuggerManager().addDebuggerListener((DebuggerManagerListener)WeakListeners.create(DebuggerManagerListener.class, (EventListener)this.debuggerListener, (Object)DebuggerManager.getDebuggerManager()));
        this.setSessionTitle(DebuggerManager.getDebuggerManager().getCurrentSession());
    }

    private void initComponent() {
        this.addTab(NbBundle.getMessage(SourcesTabs.class, (String)"LBL_SourcesTabbs.Current"), new JLabel("Current"));
        this.addTab(NbBundle.getMessage(SourcesTabs.class, (String)"LBL_SourcesTabbs.Remote"), new JLabel("Remote"));
    }

    private void setProjectTitle(Project project) {
        if (project == null) {
            this.setTitleAt(0, NbBundle.getMessage(SourcesTabs.class, (String)"LBL_SourcesTabbs.Current"));
        } else {
            ProjectInformation projectInformation = (ProjectInformation)project.getLookup().lookup(ProjectInformation.class);
            this.setTitleAt(0, projectInformation.getDisplayName());
        }
    }

    private void setSessionTitle(Session session) {
        if (session != null) {
            this.setTitleAt(0, session.getName());
            this.setEnabledAt(1, false);
        } else {
            this.setProjectTitle(MainProjectManager.getDefault().getMainProject());
            this.setEnabledAt(1, true);
        }
    }
}

