/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.fortran.options;

import java.util.prefs.Preferences;
import javax.swing.text.Document;
import org.netbeans.modules.cnd.editor.api.CodeStyle;
import org.netbeans.modules.cnd.editor.fortran.options.FmtOptions;
import org.netbeans.modules.editor.indent.spi.CodeStylePreferences;

public final class FortranCodeStyle {
    private Preferences preferences;

    private FortranCodeStyle(Preferences preferences) {
        this.preferences = preferences;
    }

    public static FortranCodeStyle get(Preferences preferences) {
        return new FortranCodeStyle(preferences);
    }

    public static FortranCodeStyle get(Document document) {
        return new FortranCodeStyle(CodeStylePreferences.get((Document)document).getPreferences());
    }

    public boolean absoluteLabelIndent() {
        return true;
    }

    public boolean expandTabToSpaces() {
        return this.preferences.getBoolean("expand-tabs", FmtOptions.getDefaultAsBoolean("expand-tabs"));
    }

    public int getTabSize() {
        return this.preferences.getInt("tab-size", FmtOptions.getDefaultAsInt("tab-size"));
    }

    public boolean indentCasesFromSwitch() {
        return true;
    }

    public CodeStyle.PreprocessorIndent indentPreprocessorDirectives() {
        return CodeStyle.PreprocessorIndent.START_LINE;
    }

    public int indentSize() {
        return this.preferences.getInt("indent-shift-width", FmtOptions.getDefaultAsInt("indent-shift-width"));
    }

    public boolean isFreeFormatFortran() {
        return this.preferences.getBoolean("freeFormat", FmtOptions.getDefaultAsBoolean("freeFormat"));
    }

    public void setFreeFormatFortran(boolean bl) {
        this.preferences.putBoolean("freeFormat", bl);
    }

    public boolean sharpAtStartLine() {
        return true;
    }

    public boolean spaceAfterComma() {
        return true;
    }

    public boolean spaceAroundAssignOps() {
        return true;
    }

    public boolean spaceAroundBinaryOps() {
        return true;
    }

    public boolean spaceAroundUnaryOps() {
        return false;
    }

    public boolean spaceBeforeComma() {
        return false;
    }

    public boolean spaceBeforeForParen() {
        return true;
    }

    public boolean spaceBeforeIfParen() {
        return true;
    }

    public boolean spaceBeforeKeywordParen() {
        return true;
    }

    public boolean spaceBeforeMethodCallParen() {
        return false;
    }

    public boolean spaceBeforeMethodDeclParen() {
        return false;
    }

    public boolean spaceBeforeSwitchParen() {
        return true;
    }

    public boolean spaceBeforeWhile() {
        return true;
    }

    public boolean spaceBeforeWhileParen() {
        return true;
    }

    public boolean spaceWithinForParens() {
        return false;
    }

    public boolean spaceWithinIfParens() {
        return false;
    }

    public boolean spaceWithinMethodCallParens() {
        return false;
    }

    public boolean spaceWithinMethodDeclParens() {
        return false;
    }

    public boolean spaceWithinParens() {
        return false;
    }

    public boolean spaceWithinSwitchParens() {
        return false;
    }

    public boolean spaceWithinWhileParens() {
        return false;
    }
}

