/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.fortran.reformat;

import java.util.Iterator;
import java.util.LinkedList;
import org.netbeans.modules.cnd.editor.fortran.reformat.FortranExtendedTokenSequence;
import org.netbeans.modules.cnd.editor.fortran.reformat.FortranReformatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FortranDiffLinkedList {
    private LinkedList<FortranReformatter.Diff> storage = new LinkedList();

    FortranDiffLinkedList() {
    }

    FortranReformatter.Diff addFirst(int n, int n2, int n3, int n4, boolean bl) {
        FortranReformatter.Diff diff = new FortranReformatter.Diff(n, n2, n3, n4, bl);
        this.storage.add(this.getIndex(n, n2), diff);
        return diff;
    }

    private int getIndex(int n, int n2) {
        int n3 = 0;
        Iterator iterator = this.storage.iterator();
        while (iterator.hasNext()) {
            FortranReformatter.Diff diff = (FortranReformatter.Diff)iterator.next();
            if (diff.getStartOffset() <= n) {
                if (diff.getStartOffset() != n || diff.getEndOffset() != n2) break;
                iterator.remove();
                break;
            }
            ++n3;
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DiffResult getDiffs(FortranExtendedTokenSequence fortranExtendedTokenSequence, int n) {
        int n2;
        int n3;
        if (n != 0) {
            int n4 = fortranExtendedTokenSequence.index();
            try {
                if (n > 0) {
                    while (fortranExtendedTokenSequence.moveNext() && --n != 0) {
                    }
                } else {
                    while (fortranExtendedTokenSequence.movePrevious() && ++n != 0) {
                    }
                }
                n3 = fortranExtendedTokenSequence.offset();
                n2 = fortranExtendedTokenSequence.offset() + fortranExtendedTokenSequence.token().length();
            }
            finally {
                fortranExtendedTokenSequence.moveIndex(n4);
                fortranExtendedTokenSequence.moveNext();
            }
        } else {
            n3 = fortranExtendedTokenSequence.offset();
            n2 = fortranExtendedTokenSequence.offset() + fortranExtendedTokenSequence.token().length();
        }
        return this.getDiffs(n3, n2);
    }

    DiffResult getDiffs(int n, int n2) {
        DiffResult diffResult = null;
        for (FortranReformatter.Diff diff : this.storage) {
            if (diff.getStartOffset() == n) {
                if (diff.getEndOffset() == n2) {
                    if (diffResult == null) {
                        diffResult = new DiffResult();
                    }
                    diffResult.replace = diff;
                } else {
                    if (diffResult == null) {
                        diffResult = new DiffResult();
                    }
                    diffResult.before = diff;
                }
            } else if (diff.getEndOffset() == n2) {
                if (diffResult == null) {
                    diffResult = new DiffResult();
                }
                diffResult.after = diff;
            }
            if (diff.getEndOffset() >= n) continue;
            return diffResult;
        }
        return diffResult;
    }

    FortranReformatter.Diff getFirst() {
        if (this.storage.isEmpty()) {
            return null;
        }
        return this.storage.getFirst();
    }

    LinkedList<FortranReformatter.Diff> getStorage() {
        return this.storage;
    }

    static class DiffResult {
        FortranReformatter.Diff before;
        FortranReformatter.Diff replace;
        FortranReformatter.Diff after;

        DiffResult() {
        }
    }
}

