/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.reformat;

import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.modules.cnd.editor.reformat.DiffLinkedList;
import org.netbeans.modules.cnd.editor.reformat.Reformatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedTokenSequence {
    private final TokenSequence<CppTokenId> ts;
    private final DiffLinkedList diffs;
    private int tabSize;

    ExtendedTokenSequence(TokenSequence<CppTokenId> tokenSequence, DiffLinkedList diffLinkedList, int n) {
        this.ts = tokenSequence;
        this.diffs = diffLinkedList;
        this.tabSize = n;
    }

    Reformatter.Diff replacePrevious(Token<CppTokenId> token, int n, int n2, boolean bl) {
        String string = ((Object)token.text()).toString();
        if (!Reformatter.Diff.equals(string, n, n2, bl)) {
            return this.diffs.addFirst(this.ts.offset() - token.length(), this.ts.offset(), n, n2, bl);
        }
        return null;
    }

    Reformatter.Diff addBeforeCurrent(int n, int n2, boolean bl) {
        if (n + n2 > 0) {
            return this.diffs.addFirst(this.ts.offset(), this.ts.offset(), n, n2, bl);
        }
        return null;
    }

    Reformatter.Diff replaceCurrent(Token<CppTokenId> token, int n, int n2, boolean bl) {
        String string = ((Object)token.text()).toString();
        if (!Reformatter.Diff.equals(string, n, n2, bl)) {
            return this.diffs.addFirst(this.ts.offset(), this.ts.offset() + token.length(), n, n2, bl);
        }
        return null;
    }

    Reformatter.Diff addAfterCurrent(Token<CppTokenId> token, int n, int n2, boolean bl) {
        if (n + n2 > 0) {
            return this.diffs.addFirst(this.ts.offset() + token.length(), this.ts.offset() + token.length(), n, n2, bl);
        }
        return null;
    }

    Reformatter.Diff replaceNext(Token<CppTokenId> token, Token<CppTokenId> token2, int n, int n2, boolean bl) {
        String string = ((Object)token2.text()).toString();
        if (!Reformatter.Diff.equals(string, n, n2, bl)) {
            return this.diffs.addFirst(this.ts.offset() + token.length(), this.ts.offset() + token.length() + token2.length(), n, n2, bl);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getTokenPosition() {
        int n = this.ts.index();
        try {
            int n2 = 0;
            block12: while (this.ts.movePrevious()) {
                DiffLinkedList.DiffResult diffResult = this.diffs.getDiffs(this, 0);
                if (diffResult != null) {
                    if (diffResult.before != null) {
                        n2 += diffResult.before.spaceLength();
                        if (diffResult.before.hasNewLine()) {
                            int n3 = n2;
                            return n3;
                        }
                    }
                    if (diffResult.replace != null) {
                        n2 += diffResult.replace.spaceLength();
                        if (!diffResult.replace.hasNewLine()) continue;
                        int n4 = n2;
                        return n4;
                    }
                }
                switch ((CppTokenId)this.ts.token().id()) {
                    case NEW_LINE: 
                    case PREPROCESSOR_DIRECTIVE: {
                        int n5 = n2;
                        return n5;
                    }
                    case DOXYGEN_COMMENT: 
                    case BLOCK_COMMENT: {
                        String string = ((Object)this.ts.token().text()).toString();
                        int n6 = string.lastIndexOf(10);
                        if (n6 < 0) {
                            n2 += string.length();
                            break;
                        }
                        int n7 = n2 += string.length() - n6 + 1;
                        return n7;
                    }
                    case WHITESPACE: {
                        int n7;
                        int n6;
                        String string = ((Object)this.ts.token().text()).toString();
                        for (n6 = 0; n6 < string.length(); ++n6) {
                            n7 = string.charAt(n6);
                            if (n7 == 9) {
                                n2 = (n2 / this.tabSize + 1) * this.tabSize;
                                continue;
                            }
                            ++n2;
                        }
                        continue block12;
                    }
                    default: {
                        n2 += this.ts.token().length();
                    }
                }
            }
            int n8 = n2;
            return n8;
        }
        finally {
            this.ts.moveIndex(n);
            this.ts.moveNext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Token<CppTokenId> lookNextImportant() {
        int n = this.ts.index();
        try {
            block7: while (this.ts.moveNext()) {
                switch ((CppTokenId)this.ts.token().id()) {
                    case NEW_LINE: 
                    case PREPROCESSOR_DIRECTIVE: 
                    case DOXYGEN_COMMENT: 
                    case BLOCK_COMMENT: 
                    case WHITESPACE: 
                    case ESCAPED_WHITESPACE: 
                    case LINE_COMMENT: 
                    case DOXYGEN_LINE_COMMENT: {
                        continue block7;
                    }
                }
                Token token = this.ts.token();
                return token;
            }
            Token<CppTokenId> token = null;
            return token;
        }
        finally {
            this.ts.moveIndex(n);
            this.ts.moveNext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Token<CppTokenId> lookNextImportant(int n) {
        int n2 = this.ts.index();
        try {
            block7: while (this.ts.moveNext()) {
                switch ((CppTokenId)this.ts.token().id()) {
                    case NEW_LINE: 
                    case PREPROCESSOR_DIRECTIVE: 
                    case DOXYGEN_COMMENT: 
                    case BLOCK_COMMENT: 
                    case WHITESPACE: 
                    case ESCAPED_WHITESPACE: 
                    case LINE_COMMENT: 
                    case DOXYGEN_LINE_COMMENT: {
                        continue block7;
                    }
                }
                if (--n > 0) continue;
                Token token = this.ts.token();
                return token;
            }
            Token<CppTokenId> token = null;
            return token;
        }
        finally {
            this.ts.moveIndex(n2);
            this.ts.moveNext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Token<CppTokenId> lookNextLineImportant() {
        int n = this.ts.index();
        try {
            block11: while (this.ts.moveNext()) {
                switch ((CppTokenId)this.ts.token().id()) {
                    case NEW_LINE: 
                    case PREPROCESSOR_DIRECTIVE: 
                    case ESCAPED_WHITESPACE: 
                    case LINE_COMMENT: 
                    case DOXYGEN_LINE_COMMENT: {
                        Token<CppTokenId> token = null;
                        return token;
                    }
                    case DOXYGEN_COMMENT: 
                    case BLOCK_COMMENT: {
                        if (((Object)this.ts.token().text()).toString().indexOf(10) < 0) continue block11;
                        Token<CppTokenId> token = null;
                        return token;
                    }
                    case WHITESPACE: {
                        continue block11;
                    }
                }
                Token token = this.ts.token();
                return token;
            }
            Token<CppTokenId> token = null;
            return token;
        }
        finally {
            this.ts.moveIndex(n);
            this.ts.moveNext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Token<CppTokenId> lookPreviousStatement() {
        int n = this.ts.index();
        int n2 = 0;
        if (this.ts.token().id() == CppTokenId.RPAREN) {
            n2 = 1;
        }
        try {
            block10: while (this.ts.movePrevious()) {
                switch ((CppTokenId)this.ts.token().id()) {
                    case LPAREN: {
                        if (n2 == 0) {
                            Token<CppTokenId> token = null;
                            return token;
                        }
                        --n2;
                        continue block10;
                    }
                    case RPAREN: {
                        ++n2;
                        continue block10;
                    }
                    case NEW_LINE: 
                    case PREPROCESSOR_DIRECTIVE: 
                    case DOXYGEN_COMMENT: 
                    case BLOCK_COMMENT: 
                    case WHITESPACE: 
                    case ESCAPED_WHITESPACE: 
                    case LINE_COMMENT: 
                    case DOXYGEN_LINE_COMMENT: {
                        continue block10;
                    }
                }
                if (n2 != 0) continue;
                Token token = this.ts.token();
                return token;
            }
            Token<CppTokenId> token = null;
            return token;
        }
        finally {
            this.ts.moveIndex(n);
            this.ts.moveNext();
        }
    }

    Token<CppTokenId> lookNext() {
        if (this.ts.moveNext()) {
            Token token = this.ts.token();
            this.ts.movePrevious();
            return token;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Token<CppTokenId> lookNext(int n) {
        int n2 = this.ts.index();
        try {
            while (n-- > 0) {
                if (this.ts.moveNext()) continue;
                Token<CppTokenId> token = null;
                return token;
            }
            Token token = this.ts.token();
            return token;
        }
        finally {
            this.ts.moveIndex(n2);
            this.ts.moveNext();
        }
    }

    boolean isLastLineToken() {
        int n = this.ts.index();
        try {
            block13: while (true) {
                if (!this.ts.moveNext()) {
                    boolean bl = true;
                    return bl;
                }
                DiffLinkedList.DiffResult diffResult = this.diffs.getDiffs(this, 0);
                if (diffResult != null && diffResult.replace != null) {
                    if (!diffResult.replace.hasNewLine()) continue;
                    boolean bl = true;
                    return bl;
                }
                CppTokenId cppTokenId = (CppTokenId)this.ts.token().id();
                switch (cppTokenId) {
                    case DOXYGEN_COMMENT: 
                    case BLOCK_COMMENT: {
                        if (((Object)this.ts.token().text()).toString().indexOf(10) < 0) continue block13;
                        boolean bl = true;
                        return bl;
                    }
                    case NEW_LINE: 
                    case ESCAPED_WHITESPACE: 
                    case LINE_COMMENT: 
                    case DOXYGEN_LINE_COMMENT: {
                        boolean bl = true;
                        return bl;
                    }
                    case WHITESPACE: {
                        break;
                    }
                    default: {
                        boolean bl = false;
                        return bl;
                    }
                }
            }
        }
        finally {
            this.ts.moveIndex(n);
            this.ts.moveNext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Token<CppTokenId> lookPreviousLineImportant() {
        int n = this.ts.index();
        try {
            block11: while (this.ts.movePrevious()) {
                switch ((CppTokenId)this.ts.token().id()) {
                    case NEW_LINE: 
                    case PREPROCESSOR_DIRECTIVE: 
                    case ESCAPED_WHITESPACE: 
                    case LINE_COMMENT: 
                    case DOXYGEN_LINE_COMMENT: {
                        Token<CppTokenId> token = null;
                        return token;
                    }
                    case DOXYGEN_COMMENT: 
                    case BLOCK_COMMENT: {
                        if (((Object)this.ts.token().text()).toString().indexOf(10) < 0) continue block11;
                        Token<CppTokenId> token = null;
                        return token;
                    }
                    case WHITESPACE: {
                        continue block11;
                    }
                }
                Token token = this.ts.token();
                return token;
            }
            Token<CppTokenId> token = null;
            return token;
        }
        finally {
            this.ts.moveIndex(n);
            this.ts.moveNext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Token<CppTokenId> lookPreviousLineImportant(CppTokenId ... cppTokenIdArray) {
        int n = this.ts.index();
        try {
            CppTokenId[] cppTokenIdArray2;
            block11: while (this.ts.movePrevious()) {
                switch ((CppTokenId)this.ts.token().id()) {
                    case NEW_LINE: 
                    case PREPROCESSOR_DIRECTIVE: 
                    case ESCAPED_WHITESPACE: 
                    case LINE_COMMENT: 
                    case DOXYGEN_LINE_COMMENT: {
                        cppTokenIdArray2 = null;
                        return cppTokenIdArray2;
                    }
                    case DOXYGEN_COMMENT: 
                    case BLOCK_COMMENT: {
                        if (((Object)this.ts.token().text()).toString().indexOf(10) < 0) continue block11;
                        cppTokenIdArray2 = null;
                        return cppTokenIdArray2;
                    }
                    case WHITESPACE: {
                        continue block11;
                    }
                }
                for (CppTokenId cppTokenId : cppTokenIdArray) {
                    if (cppTokenId != this.ts.token().id()) continue;
                    Token token = this.ts.token();
                    return token;
                }
            }
            cppTokenIdArray2 = null;
            return cppTokenIdArray2;
        }
        finally {
            this.ts.moveIndex(n);
            this.ts.moveNext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Token<CppTokenId> lookPreviousImportant() {
        int n = this.ts.index();
        try {
            block7: while (this.ts.movePrevious()) {
                switch ((CppTokenId)this.ts.token().id()) {
                    case NEW_LINE: 
                    case PREPROCESSOR_DIRECTIVE: 
                    case DOXYGEN_COMMENT: 
                    case BLOCK_COMMENT: 
                    case WHITESPACE: 
                    case ESCAPED_WHITESPACE: 
                    case LINE_COMMENT: 
                    case DOXYGEN_LINE_COMMENT: {
                        continue block7;
                    }
                }
                Token token = this.ts.token();
                return token;
            }
            Token<CppTokenId> token = null;
            return token;
        }
        finally {
            this.ts.moveIndex(n);
            this.ts.moveNext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Token<CppTokenId> lookPreviousImportant(int n) {
        int n2 = this.ts.index();
        try {
            block7: while (this.ts.movePrevious()) {
                switch ((CppTokenId)this.ts.token().id()) {
                    case NEW_LINE: 
                    case PREPROCESSOR_DIRECTIVE: 
                    case DOXYGEN_COMMENT: 
                    case BLOCK_COMMENT: 
                    case WHITESPACE: 
                    case ESCAPED_WHITESPACE: 
                    case LINE_COMMENT: 
                    case DOXYGEN_LINE_COMMENT: {
                        continue block7;
                    }
                }
                if (--n > 0) continue;
                Token token = this.ts.token();
                return token;
            }
            Token<CppTokenId> token = null;
            return token;
        }
        finally {
            this.ts.moveIndex(n2);
            this.ts.moveNext();
        }
    }

    Token<CppTokenId> lookPrevious() {
        if (this.ts.movePrevious()) {
            Token token = this.ts.token();
            this.ts.moveNext();
            return token;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Token<CppTokenId> lookPrevious(int n) {
        int n2 = this.ts.index();
        try {
            while (n-- > 0) {
                if (this.ts.movePrevious()) continue;
                Token<CppTokenId> token = null;
                return token;
            }
            Token token = this.ts.token();
            return token;
        }
        finally {
            this.ts.moveIndex(n2);
            this.ts.moveNext();
        }
    }

    boolean isFirstLineToken() {
        int n = this.ts.index();
        try {
            while (true) {
                if (!this.ts.movePrevious()) {
                    boolean bl = true;
                    return bl;
                }
                DiffLinkedList.DiffResult diffResult = this.diffs.getDiffs(this, 0);
                if (diffResult != null) {
                    if (diffResult.after != null && diffResult.after.hasNewLine()) {
                        boolean bl = true;
                        return bl;
                    }
                    if (diffResult.replace != null) {
                        if (!diffResult.replace.hasNewLine()) continue;
                        boolean bl = true;
                        return bl;
                    }
                }
                if (this.ts.token().id() == CppTokenId.NEW_LINE || this.ts.token().id() == CppTokenId.PREPROCESSOR_DIRECTIVE || this.ts.token().id() == CppTokenId.ESCAPED_WHITESPACE) {
                    boolean bl = true;
                    return bl;
                }
                if (this.ts.token().id() == CppTokenId.WHITESPACE) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.ts.moveIndex(n);
            this.ts.moveNext();
        }
    }

    Token<CppTokenId> findOpenParenToken(int n) {
        int n2 = this.ts.index();
        try {
            while (true) {
                if (!this.ts.movePrevious()) {
                    Token<CppTokenId> token = null;
                    return token;
                }
                if (this.ts.token().id() == CppTokenId.LPAREN) {
                    if (--n != 0) continue;
                    Token<CppTokenId> token = this.lookPreviousImportant();
                    return token;
                }
                if (this.ts.token().id() != CppTokenId.RPAREN) continue;
                ++n;
            }
        }
        finally {
            this.ts.moveIndex(n2);
            this.ts.moveNext();
        }
    }

    int openParenIndent(int n) {
        return this.openBraceIndent(n, CppTokenId.LPAREN, CppTokenId.RPAREN);
    }

    int openBraceIndent(int n) {
        return this.openBraceIndent(n, CppTokenId.LBRACE, CppTokenId.RBRACE);
    }

    private int openBraceIndent(int n, CppTokenId cppTokenId, CppTokenId cppTokenId2) {
        int n2 = this.ts.index();
        try {
            while (true) {
                if (!this.ts.movePrevious()) {
                    int n3 = -1;
                    return n3;
                }
                if (this.ts.token().id() == cppTokenId) {
                    if (--n != 0) continue;
                    this.ts.moveNext();
                    int n4 = this.getTokenPosition();
                    return n4;
                }
                if (this.ts.token().id() != cppTokenId2) continue;
                ++n;
            }
        }
        finally {
            this.ts.moveIndex(n2);
            this.ts.moveNext();
        }
    }

    boolean isOpenBraceLastLineToken(int n) {
        int n2 = this.ts.index();
        try {
            while (true) {
                if (!this.ts.movePrevious()) {
                    boolean bl = false;
                    return bl;
                }
                if (this.ts.token().id() == CppTokenId.LBRACE) {
                    if (--n != 0) continue;
                    boolean bl = this.isLastLineToken();
                    return bl;
                }
                if (this.ts.token().id() != CppTokenId.RBRACE) continue;
                ++n;
            }
        }
        finally {
            this.ts.moveIndex(n2);
            this.ts.moveNext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int[] getNewLinesBeforeDeclaration(int n) {
        int[] nArray = new int[]{-1, -1, 0};
        int n2 = this.ts.index();
        try {
            block14: {
                boolean bl = false;
                this.ts.moveIndex(n);
                while (true) {
                    if (!this.ts.movePrevious()) {
                        nArray[0] = 0;
                        int[] nArray2 = nArray;
                        return nArray2;
                    }
                    if (this.ts.token().id() == CppTokenId.NEW_LINE || this.ts.token().id() == CppTokenId.WHITESPACE) {
                        if (nArray[1] == -1) {
                            nArray[1] = this.ts.index();
                        }
                        nArray[0] = this.ts.index();
                        continue;
                    }
                    if (this.ts.token().id() != CppTokenId.BLOCK_COMMENT && this.ts.token().id() != CppTokenId.DOXYGEN_COMMENT) break block14;
                    if (!this.isFirstLineToken()) break;
                    if (bl) {
                        nArray[2] = 1;
                        int[] nArray3 = nArray;
                        return nArray3;
                    }
                    nArray[0] = -1;
                    nArray[1] = -1;
                    bl = true;
                }
                nArray[2] = 1;
                int[] nArray4 = nArray;
                return nArray4;
            }
            if (this.ts.token().id() == CppTokenId.PREPROCESSOR_DIRECTIVE) {
                if (nArray[0] == -1) {
                    nArray[0] = this.ts.index() + 1;
                    nArray[1] = this.ts.index();
                }
                int[] nArray5 = nArray;
                return nArray5;
            }
            nArray[2] = 1;
            int[] nArray6 = nArray;
            return nArray6;
        }
        finally {
            this.ts.moveIndex(n2);
            this.ts.moveNext();
        }
    }

    public Language<CppTokenId> language() {
        return this.ts.language();
    }

    public LanguagePath languagePath() {
        return this.ts.languagePath();
    }

    public Token<CppTokenId> token() {
        return this.ts.token();
    }

    public Token<CppTokenId> offsetToken() {
        return this.ts.offsetToken();
    }

    public int offset() {
        return this.ts.offset();
    }

    public int index() {
        return this.ts.index();
    }

    public <ET extends TokenId> TokenSequence<ET> embedded(Language<ET> language) {
        return this.ts.embedded(language);
    }

    public boolean moveNext() {
        return this.ts.moveNext();
    }

    public boolean movePrevious() {
        return this.ts.movePrevious();
    }

    public int moveIndex(int n) {
        return this.ts.moveIndex(n);
    }

    public void moveStart() {
        this.ts.moveStart();
    }

    public void moveEnd() {
        this.ts.moveEnd();
    }

    public int move(int n) {
        return this.ts.move(n);
    }

    public boolean isEmpty() {
        return this.ts.isEmpty();
    }

    public int tokenCount() {
        return this.ts.tokenCount();
    }

    public String toString() {
        return ExtendedTokenSequence.apply(this.diffs, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String apply(DiffLinkedList diffLinkedList, ExtendedTokenSequence extendedTokenSequence) {
        int n = extendedTokenSequence.index();
        StringBuilder stringBuilder = new StringBuilder();
        try {
            extendedTokenSequence.moveStart();
            while (extendedTokenSequence.moveNext()) {
                stringBuilder.append(extendedTokenSequence.token().text());
            }
            int n2 = 0;
            int n3 = stringBuilder.length();
            for (Reformatter.Diff diff : diffLinkedList.getStorage()) {
                int n4 = diff.getStartOffset();
                int n5 = diff.getEndOffset();
                String string = diff.getText();
                if (n2 > n5 || n3 < n4) {
                    System.err.println("What?" + n2 + ":" + n4 + "-" + n5);
                    continue;
                }
                if (n3 < n5) {
                    if (string != null && string.length() > 0) {
                        string = n5 - n3 >= string.length() ? null : string.substring(0, string.length() - n5 + n3);
                    }
                    n5 = n3;
                }
                if (n5 - n4 > 0) {
                    stringBuilder.delete(n4, n5);
                }
                if (string == null || string.length() <= 0) continue;
                stringBuilder.insert(n4, string);
            }
            String string = stringBuilder.toString().replaceAll("\n", "\\\\n\n");
            return string;
        }
        finally {
            extendedTokenSequence.moveIndex(n);
            extendedTokenSequence.moveNext();
        }
    }
}

