/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.ruby;

import java.awt.Color;
import java.io.CharConversionException;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.text.AttributeSet;
import javax.swing.text.StyleConstants;
import org.jrubyparser.ast.AliasNode;
import org.jrubyparser.ast.Colon2Node;
import org.jrubyparser.ast.INameNode;
import org.jrubyparser.ast.IScopingNode;
import org.jrubyparser.ast.Node;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.modules.refactoring.ruby.RubyElementCtx;
import org.netbeans.modules.ruby.AstPath;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.RubyIndex;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.elements.IndexedMethod;
import org.netbeans.modules.ruby.lexer.RubyTokenId;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.xml.XMLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RetoucheUtils {
    private RetoucheUtils() {
    }

    public static BaseDocument getDocument(ParserResult parserResult, FileObject fileObject) {
        BaseDocument baseDocument = null;
        if (parserResult != null) {
            baseDocument = RubyUtils.getDocument((Parser.Result)parserResult);
        }
        if (baseDocument == null) {
            try {
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
                if (editorCookie != null) {
                    baseDocument = (BaseDocument)editorCookie.openDocument();
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return baseDocument;
    }

    public static BaseDocument getDocument(ParserResult parserResult) {
        BaseDocument baseDocument = null;
        if (parserResult != null) {
            baseDocument = RubyUtils.getDocument((Parser.Result)parserResult, (boolean)true);
        }
        return baseDocument;
    }

    public static String[] getNodeNames(Node node) {
        Colon2Node colon2Node;
        String string = null;
        String string2 = null;
        if (node instanceof Colon2Node) {
            colon2Node = (Colon2Node)node;
            string2 = colon2Node.getName();
            string = AstUtilities.getFqn((Colon2Node)colon2Node);
        } else if (node instanceof AliasNode) {
            string = ((AliasNode)node).getNewName();
        }
        if (string == null && node instanceof INameNode) {
            string = ((INameNode)node).getName();
        }
        if (string == null && node instanceof IScopingNode) {
            if (((IScopingNode)node).getCPath() instanceof Colon2Node) {
                colon2Node = (Colon2Node)((IScopingNode)node).getCPath();
                string2 = colon2Node.getName();
                string = AstUtilities.getFqn((Colon2Node)colon2Node);
            } else {
                string = AstUtilities.getClassOrModuleName((IScopingNode)((IScopingNode)node));
            }
        }
        if (string2 == null) {
            string2 = string;
        }
        return new String[]{string, string2};
    }

    public static CloneableEditorSupport findCloneableEditorSupport(ParserResult parserResult) {
        DataObject dataObject = null;
        try {
            dataObject = DataObject.find((FileObject)RubyUtils.getFileObject((Parser.Result)parserResult));
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
        }
        return RetoucheUtils.findCloneableEditorSupport(dataObject);
    }

    public static CloneableEditorSupport findCloneableEditorSupport(DataObject dataObject) {
        Node.Cookie cookie = dataObject.getCookie(OpenCookie.class);
        if (cookie instanceof CloneableEditorSupport) {
            return (CloneableEditorSupport)cookie;
        }
        cookie = dataObject.getCookie(EditorCookie.class);
        if (cookie instanceof CloneableEditorSupport) {
            return (CloneableEditorSupport)cookie;
        }
        return null;
    }

    public static String htmlize(String string) {
        try {
            return XMLUtil.toElementContent((String)string);
        }
        catch (CharConversionException charConversionException) {
            Exceptions.printStackTrace((Throwable)charConversionException);
            return string;
        }
    }

    public static IndexedMethod getOverridingMethod(RubyElementCtx rubyElementCtx, ParserResult parserResult) {
        return RetoucheUtils.getOverridingMethod(rubyElementCtx, RubyIndex.get((Parser.Result)parserResult));
    }

    public static IndexedMethod getOverridingMethod(RubyElementCtx rubyElementCtx, FileObject fileObject) {
        return RetoucheUtils.getOverridingMethod(rubyElementCtx, RubyIndex.get((FileObject)fileObject));
    }

    private static IndexedMethod getOverridingMethod(RubyElementCtx rubyElementCtx, RubyIndex rubyIndex) {
        if (rubyIndex == null) {
            return null;
        }
        String string = AstUtilities.getFqnName((AstPath)rubyElementCtx.getPath());
        return rubyIndex.getSuperMethod(string, rubyElementCtx.getName(), false);
    }

    public static String getHtml(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        TokenHierarchy tokenHierarchy = TokenHierarchy.create((CharSequence)string, (Language)RubyTokenId.language());
        Lookup lookup = MimeLookup.getLookup((MimePath)MimePath.get((String)"text/x-ruby"));
        FontColorSettings fontColorSettings = (FontColorSettings)lookup.lookup(FontColorSettings.class);
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
        while (tokenSequence.moveNext()) {
            Token token = tokenSequence.token();
            String string2 = token.id().name();
            AttributeSet attributeSet = fontColorSettings.getTokenFontColors(string2);
            if (attributeSet == null) {
                string2 = token.id().primaryCategory();
                if (string2 == null) {
                    string2 = "whitespace";
                }
                attributeSet = fontColorSettings.getTokenFontColors(string2);
            }
            String string3 = RetoucheUtils.htmlize(((Object)token.text()).toString());
            stringBuffer.append(RetoucheUtils.color(string3, attributeSet));
        }
        return stringBuffer.toString();
    }

    private static String color(String string, AttributeSet attributeSet) {
        if (attributeSet == null) {
            return string;
        }
        if (string.trim().length() == 0) {
            return string.replace(" ", "&nbsp;").replace("\n", "<br>");
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        if (StyleConstants.isBold(attributeSet)) {
            stringBuffer.insert(0, "<b>");
            stringBuffer.append("</b>");
        }
        if (StyleConstants.isItalic(attributeSet)) {
            stringBuffer.insert(0, "<i>");
            stringBuffer.append("</i>");
        }
        if (StyleConstants.isStrikeThrough(attributeSet)) {
            stringBuffer.insert(0, "<s>");
            stringBuffer.append("</s>");
        }
        stringBuffer.insert(0, "<font color=" + RetoucheUtils.getHTMLColor(StyleConstants.getForeground(attributeSet)) + ">");
        stringBuffer.append("</font>");
        return stringBuffer.toString();
    }

    private static String getHTMLColor(Color color) {
        String string = "0" + Integer.toHexString(color.getRed());
        string = string.substring(string.length() - 2);
        String string2 = "0" + Integer.toHexString(color.getGreen());
        string2 = string2.substring(string2.length() - 2);
        String string3 = "0" + Integer.toHexString(color.getBlue());
        string3 = string3.substring(string3.length() - 2);
        String string4 = "#" + string + string2 + string3;
        return string4;
    }

    public static boolean isFileInOpenProject(FileObject fileObject) {
        assert (fileObject != null);
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        return OpenProjects.getDefault().isProjectOpen(project);
    }

    public static boolean isOnSourceClasspath(FileObject fileObject) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return false;
        }
        Project[] projectArray = OpenProjects.getDefault().getOpenProjects();
        for (int i = 0; i < projectArray.length; ++i) {
            if (!project.equals(projectArray[i]) && !projectArray[i].equals(project)) continue;
            SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)project).getSourceGroups("ruby");
            for (int j = 0; j < sourceGroupArray.length; ++j) {
                if (fileObject == sourceGroupArray[j].getRootFolder()) {
                    return true;
                }
                if (!FileUtil.isParentOf((FileObject)sourceGroupArray[j].getRootFolder(), (FileObject)fileObject)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean isRefactorable(FileObject fileObject) {
        return RubyUtils.canContainRuby((FileObject)fileObject) && RetoucheUtils.isFileInOpenProject(fileObject) && RetoucheUtils.isOnSourceClasspath(fileObject);
    }

    public static String getPackageName(FileObject fileObject) {
        assert (fileObject.isFolder()) : "argument must be folder";
        return ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source").getResourceName(fileObject, '.', false);
    }

    public static Set<FileObject> getRubyFilesInProject(FileObject fileObject) {
        HashSet<FileObject> hashSet = new HashSet<FileObject>(100);
        Collection collection = QuerySupport.findRoots((FileObject)fileObject, null, Collections.emptySet(), Collections.emptySet());
        for (FileObject fileObject2 : collection) {
            String string = fileObject2.getName();
            if (string.equals("vendor") || string.equals("script")) continue;
            RetoucheUtils.addRubyFiles(hashSet, fileObject2);
        }
        return hashSet;
    }

    private static void addRubyFiles(Set<FileObject> set, FileObject fileObject) {
        if (fileObject.isFolder()) {
            for (FileObject fileObject2 : fileObject.getChildren()) {
                RetoucheUtils.addRubyFiles(set, fileObject2);
            }
        } else if (RubyUtils.canContainRuby((FileObject)fileObject)) {
            set.add(fileObject);
        }
    }
}

