/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.ruby.ui;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.refactoring.ruby.RetoucheUtils;
import org.netbeans.modules.refactoring.ruby.RubyElementCtx;
import org.netbeans.modules.refactoring.ruby.ui.RenameRefactoringUI;
import org.netbeans.modules.refactoring.ruby.ui.WhereUsedQueryUI;
import org.netbeans.modules.refactoring.spi.ui.ActionsImplementationProvider;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.spi.ui.UI;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.RubyParseResult;
import org.netbeans.modules.ruby.RubyStructureAnalyzer;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.elements.AstElement;
import org.netbeans.modules.ruby.elements.Element;
import org.netbeans.modules.ruby.lexer.LexUtilities;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class RefactoringActionsProvider
extends ActionsImplementationProvider {
    private static final Logger LOG = Logger.getLogger(RefactoringActionsProvider.class.getName());
    private static boolean isFindUsages;

    public void doRename(Lookup lookup) {
        EditorCookie editorCookie = (EditorCookie)lookup.lookup(EditorCookie.class);
        final Dictionary dictionary = (Dictionary)lookup.lookup(Dictionary.class);
        UserTask userTask = RefactoringActionsProvider.isFromEditor(editorCookie) ? new TextComponentTask(editorCookie){

            protected RefactoringUI createRefactoringUI(RubyElementCtx rubyElementCtx, int n, int n2, ParserResult parserResult) {
                return new RenameRefactoringUI(rubyElementCtx, parserResult);
            }
        } : new NodeToFileObjectTask(lookup.lookupAll(Node.class)){

            @Override
            protected RefactoringUI createRefactoringUI(FileObject[] fileObjectArray, Collection<RubyElementCtx> collection) {
                String string = RefactoringActionsProvider.getName(dictionary);
                if (string != null) {
                    if (this.pkg[0] != null) {
                        return new RenameRefactoringUI(this.pkg[0], string);
                    }
                    return new RenameRefactoringUI(fileObjectArray[0], string, collection == null || collection.isEmpty() ? null : collection.iterator().next(), this.cinfo == null ? null : (ParserResult)this.cinfo.get());
                }
                if (this.pkg[0] != null) {
                    return new RenameRefactoringUI(this.pkg[0]);
                }
                return new RenameRefactoringUI(fileObjectArray[0], collection == null || collection.isEmpty() ? null : collection.iterator().next(), this.cinfo == null ? null : (ParserResult)this.cinfo.get());
            }
        };
        userTask.run();
    }

    public boolean canRename(Lookup lookup) {
        Collection collection = lookup.lookupAll(Node.class);
        if (collection.size() != 1) {
            return false;
        }
        Node node = (Node)collection.iterator().next();
        DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
        if (dataObject == null) {
            return false;
        }
        FileObject fileObject = dataObject.getPrimaryFile();
        if (this.isOutsideRuby(lookup, fileObject)) {
            return false;
        }
        return RetoucheUtils.isRefactorable(fileObject);
    }

    public boolean canCopy(Lookup lookup) {
        return false;
    }

    private boolean isOutsideRuby(Lookup lookup, FileObject fileObject) {
        EditorCookie editorCookie;
        if (RubyUtils.isRhtmlOrYamlFile((FileObject)fileObject) && RefactoringActionsProvider.isFromEditor(editorCookie = (EditorCookie)lookup.lookup(EditorCookie.class))) {
            JEditorPane jEditorPane = editorCookie.getOpenedPanes()[0];
            Document document = jEditorPane.getDocument();
            if (!(document instanceof BaseDocument)) {
                return true;
            }
            int n = jEditorPane.getCaretPosition();
            if (LexUtilities.getToken((BaseDocument)((BaseDocument)document), (int)n) == null) {
                return true;
            }
        }
        return false;
    }

    public boolean canFindUsages(Lookup lookup) {
        Collection collection = lookup.lookupAll(Node.class);
        if (collection.size() != 1) {
            return false;
        }
        Node node = (Node)collection.iterator().next();
        DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
        if (dataObject == null) {
            return false;
        }
        FileObject fileObject = dataObject.getPrimaryFile();
        if (this.isOutsideRuby(lookup, fileObject)) {
            return false;
        }
        return dataObject != null && RubyUtils.canContainRuby((FileObject)fileObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFindUsages(Lookup lookup) {
        EditorCookie editorCookie = (EditorCookie)lookup.lookup(EditorCookie.class);
        UserTask userTask = RefactoringActionsProvider.isFromEditor(editorCookie) ? new TextComponentTask(editorCookie){

            protected RefactoringUI createRefactoringUI(RubyElementCtx rubyElementCtx, int n, int n2, ParserResult parserResult) {
                return new WhereUsedQueryUI(rubyElementCtx, parserResult);
            }
        } : new NodeToElementTask(lookup.lookupAll(Node.class)){

            protected RefactoringUI createRefactoringUI(RubyElementCtx rubyElementCtx, ParserResult parserResult) {
                return new WhereUsedQueryUI(rubyElementCtx, parserResult);
            }
        };
        try {
            isFindUsages = true;
            userTask.run();
        }
        finally {
            isFindUsages = false;
        }
    }

    public boolean canDelete(Lookup lookup) {
        return false;
    }

    static String getName(Dictionary dictionary) {
        if (dictionary == null) {
            return null;
        }
        return (String)dictionary.get("name");
    }

    public boolean canMove(Lookup lookup) {
        return false;
    }

    public void doMove(Lookup lookup) {
    }

    static boolean isFromEditor(EditorCookie editorCookie) {
        return editorCookie != null && editorCookie.getOpenedPanes() != null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class NodeToFileObjectTask
    extends UserTask
    implements Runnable {
        private final Collection<? extends Node> nodes;
        public final NonRecursiveFolder[] pkg;
        public WeakReference<ParserResult> cinfo;
        Collection<RubyElementCtx> handles = new ArrayList<RubyElementCtx>();

        public NodeToFileObjectTask(Collection<? extends Node> collection) {
            assert (collection != null);
            this.nodes = collection;
            this.pkg = new NonRecursiveFolder[collection.size()];
        }

        public void cancel() {
        }

        public void run(ResultIterator resultIterator) throws ParseException {
            if (resultIterator.getSnapshot().getMimeType().equals("text/x-ruby")) {
                RubyStructureAnalyzer.AnalysisResult analysisResult;
                List list;
                RubyParseResult rubyParseResult = AstUtilities.getParseResult((Parser.Result)resultIterator.getParserResult());
                org.jrubyparser.ast.Node node = AstUtilities.getRoot((Parser.Result)rubyParseResult);
                if (node != null && rubyParseResult != null && (list = (analysisResult = rubyParseResult.getStructure()).getElements()).size() > 0) {
                    AstElement astElement = (AstElement)list.get(0);
                    org.jrubyparser.ast.Node node2 = astElement.getNode();
                    RubyElementCtx rubyElementCtx = new RubyElementCtx(node, node2, (Element)astElement, RubyUtils.getFileObject((Parser.Result)rubyParseResult), (ParserResult)rubyParseResult);
                    rubyElementCtx.setNames(astElement.getFqn(), astElement.getName());
                    this.handles.add(rubyElementCtx);
                }
                this.cinfo = new WeakReference<RubyParseResult>(rubyParseResult);
            }
        }

        @Override
        public void run() {
            FileObject[] fileObjectArray = new FileObject[this.nodes.size()];
            int n = 0;
            for (Node node : this.nodes) {
                DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
                if (dataObject == null) continue;
                fileObjectArray[n] = dataObject.getPrimaryFile();
                Source source = Source.create((FileObject)fileObjectArray[n]);
                try {
                    ParserManager.parse(Collections.singleton(source), (UserTask)this);
                }
                catch (ParseException parseException) {
                    LOG.log(Level.WARNING, null, parseException);
                }
                this.pkg[n++] = (NonRecursiveFolder)node.getLookup().lookup(NonRecursiveFolder.class);
            }
            UI.openRefactoringUI((RefactoringUI)this.createRefactoringUI(fileObjectArray, this.handles));
        }

        protected abstract RefactoringUI createRefactoringUI(FileObject[] var1, Collection<RubyElementCtx> var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class NodeToElementTask
    extends UserTask
    implements Runnable {
        private final Node node;
        private RefactoringUI ui;

        public NodeToElementTask(Collection<? extends Node> collection) {
            assert (collection.size() == 1);
            this.node = collection.iterator().next();
        }

        public void run(ResultIterator resultIterator) throws ParseException {
            if (resultIterator.getSnapshot().getMimeType().equals("text/x-ruby")) {
                RubyParseResult rubyParseResult = AstUtilities.getParseResult((Parser.Result)resultIterator.getParserResult());
                org.jrubyparser.ast.Node node = AstUtilities.getRoot((Parser.Result)rubyParseResult);
                if (node != null) {
                    AstElement astElement = AstElement.create((ParserResult)rubyParseResult, (org.jrubyparser.ast.Node)node);
                    RubyElementCtx rubyElementCtx = new RubyElementCtx(node, node, (Element)astElement, RubyUtils.getFileObject((Parser.Result)rubyParseResult), (ParserResult)rubyParseResult);
                    this.ui = this.createRefactoringUI(rubyElementCtx, (ParserResult)rubyParseResult);
                }
            } else {
                for (Embedding embedding : resultIterator.getEmbeddings()) {
                    this.run(resultIterator.getResultIterator(embedding));
                }
            }
        }

        @Override
        public final void run() {
            Object object;
            try {
                object = (DataObject)this.node.getCookie(DataObject.class);
                Source source = Source.create((FileObject)object.getPrimaryFile());
                ParserManager.parse(Collections.singleton(source), (UserTask)this);
            }
            catch (ParseException parseException) {
                LOG.log(Level.WARNING, null, parseException);
                return;
            }
            if (this.ui != null) {
                UI.openRefactoringUI((RefactoringUI)this.ui);
            } else {
                object = "ERR_CannotRenameLoc";
                if (isFindUsages) {
                    object = "ERR_CannotFindUsages";
                }
                JOptionPane.showMessageDialog(null, NbBundle.getMessage(RefactoringActionsProvider.class, (String)object));
            }
        }

        protected abstract RefactoringUI createRefactoringUI(RubyElementCtx var1, ParserResult var2);
    }

    public static abstract class TextComponentTask
    extends UserTask
    implements Runnable {
        private final JTextComponent textC;
        private final int caret;
        private final int start;
        private final int end;
        private RefactoringUI ui;

        public TextComponentTask(EditorCookie editorCookie) {
            this.textC = editorCookie.getOpenedPanes()[0];
            this.caret = this.textC.getCaretPosition();
            this.start = this.textC.getSelectionStart();
            this.end = this.textC.getSelectionEnd();
            assert (this.caret != -1);
            assert (this.start != -1);
            assert (this.end != -1);
        }

        public void run(ResultIterator resultIterator) throws Exception {
            if (resultIterator.getSnapshot().getMimeType().equals("text/x-ruby")) {
                RubyParseResult rubyParseResult = AstUtilities.getParseResult((Parser.Result)resultIterator.getParserResult());
                org.jrubyparser.ast.Node node = AstUtilities.getRoot((Parser.Result)rubyParseResult);
                if (node != null) {
                    RubyElementCtx rubyElementCtx = new RubyElementCtx((ParserResult)rubyParseResult, this.caret);
                    if (rubyElementCtx.getSimpleName() != null) {
                        this.ui = this.createRefactoringUI(rubyElementCtx, this.start, this.end, (ParserResult)rubyParseResult);
                    }
                } else {
                    System.out.println("FAILURE - can't refactor uncompileable sources");
                }
            } else {
                for (Embedding embedding : resultIterator.getEmbeddings()) {
                    this.run(resultIterator.getResultIterator(embedding));
                }
            }
        }

        public final void run() {
            Source source;
            try {
                source = Source.create((Document)this.textC.getDocument());
                ParserManager.parse(Collections.singleton(source), (UserTask)this);
            }
            catch (ParseException parseException) {
                LOG.log(Level.WARNING, null, parseException);
                return;
            }
            source = TopComponent.getRegistry().getActivated();
            if (this.ui != null) {
                UI.openRefactoringUI((RefactoringUI)this.ui, (TopComponent)source);
            } else {
                String string = "ERR_CannotRenameLoc";
                if (isFindUsages) {
                    string = "ERR_CannotFindUsages";
                }
                JOptionPane.showMessageDialog(null, NbBundle.getMessage(RefactoringActionsProvider.class, (String)string));
            }
        }

        protected abstract RefactoringUI createRefactoringUI(RubyElementCtx var1, int var2, int var3, ParserResult var4);
    }
}

