/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui;

import java.util.LinkedHashMap;
import java.util.Map;
import org.netbeans.api.debugger.Properties;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariablesFormatter
implements Cloneable {
    private String name;
    private boolean enabled = true;
    private String[] classTypes = new String[0];
    private boolean includeSubTypes = true;
    private String valueFormatCode = "";
    private String childrenFormatCode = "";
    private Map<String, String> childrenVariables = new LinkedHashMap<String, String>();
    private boolean useChildrenVariables = false;
    private String childrenExpandTestCode = "";
    private boolean isDefault = false;

    public VariablesFormatter(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public String[] getClassTypes() {
        return this.classTypes;
    }

    public String getClassTypesCommaSeparated() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.classTypes.length; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.classTypes[i]);
        }
        return stringBuilder.toString();
    }

    public void setClassTypes(String[] stringArray) {
        this.classTypes = stringArray;
    }

    public void setClassTypes(String string) {
        this.classTypes = string.split("[, ]+");
    }

    public boolean isIncludeSubTypes() {
        return this.includeSubTypes;
    }

    public void setIncludeSubTypes(boolean bl) {
        this.includeSubTypes = bl;
    }

    public String getValueFormatCode() {
        return this.valueFormatCode;
    }

    public void setValueFormatCode(String string) {
        this.valueFormatCode = string;
    }

    public String getChildrenFormatCode() {
        return this.childrenFormatCode;
    }

    public void setChildrenFormatCode(String string) {
        this.childrenFormatCode = string;
    }

    public Map<String, String> getChildrenVariables() {
        return this.childrenVariables;
    }

    public void setChildrenVariables(Map<String, String> map) {
        this.childrenVariables = map;
    }

    public void addChildrenVariable(String string, String string2) {
        this.childrenVariables.put(string, string2);
    }

    public boolean isUseChildrenVariables() {
        return this.useChildrenVariables;
    }

    public void setUseChildrenVariables(boolean bl) {
        this.useChildrenVariables = bl;
    }

    public String getChildrenExpandTestCode() {
        return this.childrenExpandTestCode;
    }

    public void setChildrenExpandTestCode(String string) {
        this.childrenExpandTestCode = string;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public VariablesFormatter clone() {
        VariablesFormatter variablesFormatter = new VariablesFormatter(this.name);
        variablesFormatter.childrenExpandTestCode = this.childrenExpandTestCode;
        variablesFormatter.childrenFormatCode = this.childrenFormatCode;
        variablesFormatter.childrenVariables = new LinkedHashMap<String, String>(this.childrenVariables);
        variablesFormatter.classTypes = (String[])this.classTypes.clone();
        variablesFormatter.enabled = this.enabled;
        variablesFormatter.includeSubTypes = this.includeSubTypes;
        variablesFormatter.useChildrenVariables = this.useChildrenVariables;
        variablesFormatter.valueFormatCode = this.valueFormatCode;
        return variablesFormatter;
    }

    public static VariablesFormatter[] loadFormatters() {
        Properties properties = Properties.getDefault().getProperties("debugger.options.JPDA");
        VariablesFormatter[] variablesFormatterArray = (VariablesFormatter[])properties.getArray("VariableFormatters", null);
        VariablesFormatter[] variablesFormatterArray2 = VariablesFormatter.createDefaultFormatters();
        if (variablesFormatterArray == null) {
            variablesFormatterArray = variablesFormatterArray2;
        } else {
            LinkedHashMap<String, VariablesFormatter> linkedHashMap = new LinkedHashMap<String, VariablesFormatter>(variablesFormatterArray2.length);
            for (VariablesFormatter variablesFormatter : variablesFormatterArray2) {
                linkedHashMap.put(variablesFormatter.getName(), variablesFormatter);
            }
            for (int i = 0; i < variablesFormatterArray.length; ++i) {
                if (!variablesFormatterArray[i].isDefault || !linkedHashMap.containsKey(variablesFormatterArray[i].getName())) continue;
                VariablesFormatter variablesFormatter = variablesFormatterArray[i];
                variablesFormatterArray[i] = (VariablesFormatter)linkedHashMap.remove(variablesFormatterArray[i].getName());
                variablesFormatterArray[i].setEnabled(variablesFormatter.isEnabled());
            }
            if (!linkedHashMap.isEmpty()) {
                VariablesFormatter[] variablesFormatterArray3 = new VariablesFormatter[variablesFormatterArray.length + linkedHashMap.size()];
                System.arraycopy(variablesFormatterArray, 0, variablesFormatterArray3, 0, variablesFormatterArray.length);
                System.arraycopy(linkedHashMap.values().toArray(), 0, variablesFormatterArray3, variablesFormatterArray.length, linkedHashMap.size());
                variablesFormatterArray = variablesFormatterArray3;
            }
        }
        return variablesFormatterArray;
    }

    private static VariablesFormatter[] createDefaultFormatters() {
        VariablesFormatter variablesFormatter = new VariablesFormatter(NbBundle.getMessage(VariablesFormatter.class, (String)"MSG_CollectionFormatter"));
        variablesFormatter.setClassTypes("java.util.Collection");
        variablesFormatter.setIncludeSubTypes(true);
        variablesFormatter.setChildrenFormatCode("toArray()");
        variablesFormatter.setValueFormatCode("\"size = \"+size()");
        variablesFormatter.isDefault = true;
        VariablesFormatter variablesFormatter2 = new VariablesFormatter(NbBundle.getMessage(VariablesFormatter.class, (String)"MSG_MapFormatter"));
        variablesFormatter2.setClassTypes("java.util.Map");
        variablesFormatter2.setIncludeSubTypes(true);
        variablesFormatter2.setChildrenFormatCode("entrySet()");
        variablesFormatter2.setValueFormatCode("\"size = \"+size()");
        variablesFormatter2.isDefault = true;
        VariablesFormatter variablesFormatter3 = new VariablesFormatter(NbBundle.getMessage(VariablesFormatter.class, (String)"MSG_MapEntryFormatter"));
        variablesFormatter3.setClassTypes("java.util.Map$Entry");
        variablesFormatter3.setIncludeSubTypes(true);
        variablesFormatter3.setUseChildrenVariables(true);
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("key", "getKey()");
        linkedHashMap.put("value", "getValue()");
        variablesFormatter3.setChildrenVariables(linkedHashMap);
        variablesFormatter3.setValueFormatCode("getKey()+\" => \"+getValue()");
        variablesFormatter3.isDefault = true;
        return new VariablesFormatter[]{variablesFormatter, variablesFormatter2, variablesFormatter3};
    }

    public static class ReaderWriter
    implements Properties.Reader {
        public String[] getSupportedClassNames() {
            return new String[]{VariablesFormatter.class.getName()};
        }

        public Object read(String string, Properties properties) {
            String string2 = properties.getString("name", "<EMPTY>");
            VariablesFormatter variablesFormatter = new VariablesFormatter(string2);
            variablesFormatter.setEnabled(properties.getBoolean("enabled", variablesFormatter.isEnabled()));
            variablesFormatter.setClassTypes(properties.getString("classTypes", variablesFormatter.getClassTypesCommaSeparated()));
            variablesFormatter.setIncludeSubTypes(properties.getBoolean("includeSubTypes", variablesFormatter.isIncludeSubTypes()));
            variablesFormatter.setValueFormatCode(properties.getString("valueFormatCode", variablesFormatter.getValueFormatCode()));
            variablesFormatter.setChildrenFormatCode(properties.getString("childrenFormatCode", variablesFormatter.getChildrenFormatCode()));
            variablesFormatter.setChildrenVariables(properties.getMap("childrenVariables", variablesFormatter.getChildrenVariables()));
            variablesFormatter.setUseChildrenVariables(properties.getBoolean("useChildrenVariables", variablesFormatter.isUseChildrenVariables()));
            variablesFormatter.setChildrenExpandTestCode(properties.getString("childrenExpandTestCode", variablesFormatter.getChildrenExpandTestCode()));
            variablesFormatter.isDefault = properties.getBoolean("isDefault", variablesFormatter.isDefault);
            return variablesFormatter;
        }

        public void write(Object object, Properties properties) {
            VariablesFormatter variablesFormatter = (VariablesFormatter)object;
            properties.setString("name", variablesFormatter.getName());
            properties.setBoolean("enabled", variablesFormatter.isEnabled());
            properties.setString("classTypes", variablesFormatter.getClassTypesCommaSeparated());
            properties.setBoolean("includeSubTypes", variablesFormatter.isIncludeSubTypes());
            properties.setString("valueFormatCode", variablesFormatter.getValueFormatCode());
            properties.setString("childrenFormatCode", variablesFormatter.getChildrenFormatCode());
            properties.setMap("childrenVariables", variablesFormatter.getChildrenVariables());
            properties.setBoolean("useChildrenVariables", variablesFormatter.isUseChildrenVariables());
            properties.setString("childrenExpandTestCode", variablesFormatter.getChildrenExpandTestCode());
            properties.setBoolean("isDefault", variablesFormatter.isDefault);
        }
    }
}

