/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.model;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.heap.ObjectFieldValue;
import org.netbeans.lib.profiler.heap.Value;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerNode;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerNodeFactory;
import org.netbeans.modules.profiler.heapwalk.model.InstanceNode;
import org.netbeans.modules.profiler.heapwalk.model.InstancesContainerNode;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class HeapPatterns {
    private static final String INSTANCE_OF_STRING = NbBundle.getMessage(HeapPatterns.class, (String)"HeapPatterns_InstanceOfString");
    private static final String INSTANCES_OF_STRING = NbBundle.getMessage(HeapPatterns.class, (String)"HeapPatterns_InstancesOfString");
    private static final String LINKED_LIST_CLASSNAME = "java.util.LinkedList";
    private static final String LINKED_LIST_ENTRY_CLASSNAME = "java.util.LinkedList$Entry";

    HeapPatterns() {
    }

    static HeapWalkerNode[] processReferencePatterns(InstanceNode instanceNode, List list) {
        Instance instance = instanceNode.getInstance();
        JavaClass javaClass = instance.getJavaClass();
        String string = javaClass.getName();
        if (LINKED_LIST_ENTRY_CLASSNAME.equals(string)) {
            return HeapPatterns.processLinkedListReferencePatterns(instanceNode, instance, javaClass, list);
        }
        return null;
    }

    private static HeapWalkerNode[] processLinkedListReferencePatterns(InstanceNode instanceNode, Instance instance, JavaClass javaClass, List<Value> list) {
        String string;
        Object object;
        String string2;
        Object object2;
        int n;
        boolean bl;
        Object object3 = null;
        String string3 = null;
        Value value = null;
        Value value2 = null;
        Value value3 = null;
        Value value4 = null;
        boolean bl2 = false;
        boolean bl3 = bl = list.size() != 3;
        while (value3 == null && ((n = list.size()) == 2 || n == 3)) {
            JavaClass javaClass2;
            Instance instance2;
            Value value5;
            JavaClass javaClass3;
            value = list.get(0);
            value2 = list.get(1);
            value3 = n == 2 ? null : list.get(2);
            object2 = value instanceof ObjectFieldValue ? value.getDefiningInstance() : null;
            string2 = value2 instanceof ObjectFieldValue ? value2.getDefiningInstance() : null;
            Instance instance3 = object = value3 instanceof ObjectFieldValue ? value3.getDefiningInstance() : null;
            if (object2 == null || string2 == null) break;
            JavaClass javaClass4 = object2.getJavaClass();
            JavaClass javaClass5 = string2.getJavaClass();
            JavaClass javaClass6 = javaClass3 = object == null ? null : object.getJavaClass();
            if (javaClass.equals(javaClass3)) {
                if (!javaClass.equals(javaClass4)) {
                    value5 = value3;
                    instance2 = object;
                    javaClass2 = javaClass3;
                    value3 = value;
                    object = object2;
                    javaClass3 = javaClass4;
                    value = value5;
                    object2 = instance2;
                    javaClass4 = javaClass2;
                } else {
                    if (javaClass.equals(javaClass5)) break;
                    value5 = value3;
                    instance2 = object;
                    javaClass2 = javaClass3;
                    value3 = value2;
                    object = string2;
                    javaClass3 = javaClass5;
                    value2 = value5;
                    string2 = instance2;
                    javaClass5 = javaClass2;
                }
            }
            if (!javaClass.equals(javaClass4) || !javaClass.equals(javaClass5)) break;
            if (object3 == null) {
                object3 = object2;
                string3 = string2;
            }
            if (value3 == null) {
                value5 = ((ObjectFieldValue)value).getField();
                instance2 = ((ObjectFieldValue)value2).getField();
                if (value4 == null) {
                    value4 = value5;
                } else {
                    javaClass2 = null;
                    if (value4.equals(value5)) {
                        javaClass2 = value5;
                    } else if (value4.equals(instance2)) {
                        javaClass2 = instance2;
                    }
                    if (javaClass2 == null) break;
                    value4 = javaClass2;
                }
                list = value4 == value5 ? object2.getReferences() : string2.getReferences();
                continue;
            }
            bl2 = LINKED_LIST_CLASSNAME.equals(javaClass3.getName());
        }
        if (!bl2) {
            return null;
        }
        if (object3.equals(string3)) {
            string = MessageFormat.format(INSTANCE_OF_STRING, LINKED_LIST_ENTRY_CLASSNAME);
            object2 = Collections.singletonList(object3);
        } else {
            string = MessageFormat.format(INSTANCES_OF_STRING, 2, LINKED_LIST_ENTRY_CLASSNAME);
            object2 = Arrays.asList(object3, string3);
        }
        string2 = "previous, next (" + string + ")";
        object = bl ? new Instance[]{new InstancesContainerNode(string2, instanceNode, Collections.singletonList(value3), (List<Instance>)object2)} : new HeapWalkerNode[]{HeapWalkerNodeFactory.createReferenceNode(value3, instanceNode), new InstancesContainerNode(string2, instanceNode, Collections.EMPTY_LIST, (List<Instance>)object2)};
        return object;
    }
}

