/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ppoints.ui;

import java.io.File;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.ppoints.CodeProfilingPoint;
import org.netbeans.modules.profiler.ppoints.ProfilingPointsManager;
import org.netbeans.modules.profiler.ppoints.Utils;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class ShowOppositeProfilingPointAction
extends NodeAction {
    private static final String NO_END_DEFINED_MSG = NbBundle.getMessage(ShowOppositeProfilingPointAction.class, (String)"ShowOppositeProfilingPointAction_NoEndDefinedMsg");
    private static final String NO_DATA_STRING = NbBundle.getMessage(ShowOppositeProfilingPointAction.class, (String)"ShowOppositeProfilingPointAction_NoDataString");
    private static final String END_ACTION_NAME = NbBundle.getMessage(ShowOppositeProfilingPointAction.class, (String)"ShowOppositeProfilingPointAction_EndActionName");
    private static final String START_ACTION_NAME = NbBundle.getMessage(ShowOppositeProfilingPointAction.class, (String)"ShowOppositeProfilingPointAction_StartActionName");

    public ShowOppositeProfilingPointAction() {
        this.setIcon(null);
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(ShowOppositeProfilingPointAction.class);
    }

    public String getName() {
        InvocationLocationDescriptor invocationLocationDescriptor = this.getCurrentLocationDescriptor();
        if (invocationLocationDescriptor.getProfilingPoint() == null) {
            return NO_DATA_STRING;
        }
        return invocationLocationDescriptor.isStartLocation() ? END_ACTION_NAME : START_ACTION_NAME;
    }

    protected boolean asynchronous() {
        return false;
    }

    protected boolean enable(Node[] nodeArray) {
        if (ProfilingPointsManager.getDefault().isProfilingSessionInProgress()) {
            return false;
        }
        return this.getCurrentLocationDescriptor().getProfilingPoint() != null;
    }

    protected void performAction(Node[] nodeArray) {
        InvocationLocationDescriptor invocationLocationDescriptor = this.getCurrentLocationDescriptor();
        if (invocationLocationDescriptor.getProfilingPoint() == null) {
            return;
        }
        CodeProfilingPoint.Location location = invocationLocationDescriptor.getOppositeLocation();
        if (location != null) {
            Utils.openLocation(location);
        } else {
            NetBeansProfiler.getDefaultNB().displayWarning(NO_END_DEFINED_MSG);
        }
    }

    private InvocationLocationDescriptor getCurrentLocationDescriptor() {
        CodeProfilingPoint.Location location = Utils.getCurrentLocation(0);
        CodeProfilingPoint[] codeProfilingPointArray = Utils.getProfilingPointsOnLine(location);
        if (codeProfilingPointArray.length > 0) {
            for (CodeProfilingPoint codeProfilingPoint : codeProfilingPointArray) {
                if (!(codeProfilingPoint instanceof CodeProfilingPoint.Paired)) continue;
                return new InvocationLocationDescriptor((CodeProfilingPoint.Paired)codeProfilingPoint, location);
            }
        }
        return new InvocationLocationDescriptor(null, location);
    }

    private class InvocationLocationDescriptor {
        private CodeProfilingPoint.Location location;
        private CodeProfilingPoint.Location oppositeLocation;
        private CodeProfilingPoint.Paired profilingPoint;
        private boolean isStartLocation;

        public InvocationLocationDescriptor(CodeProfilingPoint.Paired paired, CodeProfilingPoint.Location location) {
            this.profilingPoint = paired;
            this.location = location;
            this.computeOppositeLocation();
        }

        public CodeProfilingPoint.Location getLocation() {
            return this.location;
        }

        public CodeProfilingPoint.Location getOppositeLocation() {
            return this.oppositeLocation;
        }

        public CodeProfilingPoint.Paired getProfilingPoint() {
            return this.profilingPoint;
        }

        public boolean isStartLocation() {
            return this.isStartLocation;
        }

        private void computeOppositeLocation() {
            CodeProfilingPoint.Paired paired = this.getProfilingPoint();
            if (paired == null) {
                return;
            }
            CodeProfilingPoint.Location location = paired.getStartLocation();
            if (new File(location.getFile()).equals(new File(this.location.getFile())) && location.getLine() == this.location.getLine()) {
                this.oppositeLocation = paired.getEndLocation();
                this.isStartLocation = true;
            } else {
                this.oppositeLocation = paired.getStartLocation();
                this.isStartLocation = false;
            }
        }
    }
}

