/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ui.stats.drilldown;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.RuntimeCPUCCTNode;
import org.netbeans.lib.profiler.ui.charts.PieChart;
import org.netbeans.lib.profiler.ui.charts.PieChartModel;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.lib.profiler.ui.cpu.StatisticsPanel;
import org.netbeans.lib.profiler.ui.cpu.statistics.StatisticalModule;
import org.netbeans.modules.profiler.categories.Category;
import org.netbeans.modules.profiler.ui.stats.drilldown.DrillDown;
import org.netbeans.modules.profiler.ui.stats.drilldown.DrillDownListener;
import org.netbeans.modules.profiler.ui.stats.drilldown.ProjectPieChartModel;

public class DrillDownPanel
extends StatisticalModule {
    private DrillDownListener listener = new DrillDownListener(){

        public void dataChanged() {
        }

        public void drillDownPathChanged(List list) {
            DrillDownPanel.this.updateCrumbNav();
        }
    };
    private HTMLTextArea crumbNav;
    private DrillDown ddModel;
    private PieChart pieChart;
    private ProjectPieChartModel pieModel = null;
    private StatisticsPanel panel = null;
    private String lastNavigableCategoryId = null;

    public DrillDownPanel(DrillDown drillDown) {
        this.ddModel = drillDown;
        this.ddModel.addListener(this.listener);
        this.initComponents();
    }

    public void addSnippet(StatisticalModule statisticalModule) {
        this.panel.addSnippet((JComponent)statisticalModule);
    }

    public void pause() {
    }

    public void refresh(RuntimeCPUCCTNode runtimeCPUCCTNode) {
    }

    public void removeSnippet(StatisticalModule statisticalModule) {
        this.panel.removeSnippet((JComponent)statisticalModule);
    }

    public void resume() {
    }

    private synchronized HTMLTextArea getCrumbNav() {
        if (this.crumbNav == null) {
            this.crumbNav = new HTMLTextArea();
            this.crumbNav.setOpaque(false);
            this.crumbNav.addHyperlinkListener(new HyperlinkListener(){

                public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                    String string = hyperlinkEvent.getURL().getQuery();
                    if (hyperlinkEvent.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                        return;
                    }
                    int n = hyperlinkEvent.getURL().getQuery().lastIndexOf(61);
                    if (n <= -1) {
                        return;
                    }
                    DrillDownPanel.this.ddModel.drillup(string.substring(n + 1));
                }
            });
            this.updateCrumbNav();
        }
        return this.crumbNav;
    }

    private synchronized PieChart getPieChart() {
        if (this.pieChart == null) {
            this.pieChart = new PieChart();
            this.pieModel = new ProjectPieChartModel(this.ddModel);
            this.pieChart.setModel((PieChartModel)this.pieModel);
        }
        return this.pieChart;
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.panel = new StatisticsPanel(this.getCrumbNav(), this.getPieChart(), new Runnable(){

            public void run() {
                DrillDownPanel.this.navigateOneLevelBack();
            }
        });
        this.panel.addListener(new StatisticsPanel.Listener(){

            public void itemClicked(int n) {
                DrillDownPanel.this.pieModel.drilldown(n);
            }
        });
        this.add((Component)this.panel, "Center");
    }

    private void navigateOneLevelBack() {
        if (this.lastNavigableCategoryId != null) {
            this.ddModel.drillup(this.lastNavigableCategoryId);
        }
    }

    private synchronized void updateCrumbNav() {
        StringBuilder stringBuilder = new StringBuilder();
        this.lastNavigableCategoryId = null;
        int n = this.ddModel.getDrillDownPath().size() - 1;
        for (Category category : this.ddModel.getDrillDownPath()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("/");
            }
            if (n-- > 0) {
                stringBuilder.append("<a href=\"http://localhost/category?id=").append(category.getId()).append("\">").append(category.getLabel()).append("</a>");
                this.lastNavigableCategoryId = category.getId();
            } else {
                stringBuilder.append(category.getLabel());
            }
            this.crumbNav.setText(stringBuilder.toString());
        }
    }
}

