/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ui.stp;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.profiler.ui.stp.SelectProfilingTask;

public class DefaultSettingsPanel
extends JPanel
implements Scrollable {
    private SettingsChangeListener settingsChangeListener;
    private Vector<ChangeListener> changeListeners;

    public DefaultSettingsPanel() {
        this.setOpaque(true);
        this.setBackground(SelectProfilingTask.BACKGROUND_COLOR);
        this.changeListeners = new Vector();
        this.settingsChangeListener = new SettingsChangeListener();
    }

    public Dimension getPreferredScrollableViewportSize() {
        return null;
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        Container container = this.getParent();
        if (container == null || !(container instanceof JViewport)) {
            return 50;
        }
        return (int)((float)((JViewport)container).getHeight() * 0.95f);
    }

    public boolean getScrollableTracksViewportHeight() {
        Container container = this.getParent();
        if (container == null || !(container instanceof JViewport)) {
            return false;
        }
        return this.getPreferredSize().height < ((JViewport)container).getHeight();
    }

    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        return 20;
    }

    public void addChangeListener(ChangeListener changeListener) {
        if (!this.changeListeners.contains(changeListener)) {
            this.changeListeners.add(changeListener);
        }
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeListeners.remove(changeListener);
    }

    SettingsChangeListener getSettingsChangeListener() {
        return this.settingsChangeListener;
    }

    private void fireSettingsChanged() {
        for (ChangeListener changeListener : this.changeListeners) {
            changeListener.stateChanged(new ChangeEvent(this));
        }
    }

    private class SettingsChangeListener
    implements ActionListener,
    ChangeListener {
        private SettingsChangeListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DefaultSettingsPanel.this.fireSettingsChanged();
        }

        public void stateChanged(ChangeEvent changeEvent) {
            DefaultSettingsPanel.this.fireSettingsChanged();
        }
    }
}

