/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.ext.html.parser.AstNode;
import org.netbeans.editor.ext.html.parser.AstNodeUtils;
import org.netbeans.editor.ext.html.parser.AstNodeVisitor;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.modules.csl.api.ColoringAttributes;
import org.netbeans.modules.csl.api.DeclarationFinder;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintsProvider;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.html.editor.api.completion.HtmlCompletionItem;
import org.netbeans.modules.html.editor.api.gsf.HtmlExtension;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.web.jsf.editor.JsfSupport;
import org.netbeans.modules.web.jsf.editor.completion.JsfCompletionItem;
import org.netbeans.modules.web.jsf.editor.facelets.CompositeComponentLibrary;
import org.netbeans.modules.web.jsf.editor.facelets.FaceletsLibrary;
import org.netbeans.modules.web.jsf.editor.hints.HintsRegistry;
import org.netbeans.modules.web.jsf.editor.tld.LibraryDescriptor;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.lexer.MutableTextInput;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsfHtmlExtension
extends HtmlExtension {
    private static boolean activated = false;
    private static final String EL_ENABLED_KEY = "el_enabled";

    static synchronized void activate() {
        if (!activated) {
            HtmlExtension.register((String)"text/xhtml", (HtmlExtension)new JsfHtmlExtension());
            activated = true;
        }
    }

    public Map<OffsetRange, Set<ColoringAttributes>> getHighlights(HtmlParserResult htmlParserResult, SchedulerEvent schedulerEvent) {
        HashMap<OffsetRange, Set<ColoringAttributes>> hashMap = new HashMap<OffsetRange, Set<ColoringAttributes>>();
        this.highlightJsfTags(htmlParserResult, hashMap);
        this.checkELEnabled(htmlParserResult);
        return hashMap;
    }

    public void checkELEnabled(HtmlParserResult htmlParserResult) {
        Language language;
        Document document = htmlParserResult.getSnapshot().getSource().getDocument(true);
        InputAttributes inputAttributes = (InputAttributes)document.getProperty(InputAttributes.class);
        if (inputAttributes == null) {
            inputAttributes = new InputAttributes();
            document.putProperty(InputAttributes.class, inputAttributes);
        }
        if (inputAttributes.getValue(LanguagePath.get((Language)(language = Language.find((String)"text/xhtml"))), (Object)EL_ENABLED_KEY) == null) {
            inputAttributes.setValue(LanguagePath.get((Language)language), (Object)EL_ENABLED_KEY, new Object(), false);
            this.recolor(document);
        }
    }

    private void recolor(final Document document) {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                NbEditorDocument nbEditorDocument = (NbEditorDocument)document;
                nbEditorDocument.extWriteLock();
                try {
                    MutableTextInput mutableTextInput = (MutableTextInput)document.getProperty(MutableTextInput.class);
                    if (mutableTextInput != null) {
                        mutableTextInput.tokenHierarchyControl().rebuild();
                    }
                }
                finally {
                    nbEditorDocument.extWriteUnlock();
                }
            }
        });
    }

    private void highlightJsfTags(HtmlParserResult htmlParserResult, final Map<OffsetRange, Set<ColoringAttributes>> map) {
        final Snapshot snapshot = htmlParserResult.getSnapshot();
        Source source = snapshot.getSource();
        JsfSupport jsfSupport = JsfSupport.findFor(source);
        if (jsfSupport == null) {
            return;
        }
        Map<String, FaceletsLibrary> map2 = jsfSupport.getFaceletsLibraries();
        Map map3 = htmlParserResult.getNamespaces();
        for (String string : map3.keySet()) {
            AstNode astNode = htmlParserResult.root(string);
            if (astNode == null) continue;
            final FaceletsLibrary faceletsLibrary = map2.get(string);
            AstNodeUtils.visitChildren((AstNode)astNode, (AstNodeVisitor)new AstNodeVisitor(){

                public void visit(AstNode astNode) {
                    if ((astNode.type() == AstNode.NodeType.OPEN_TAG || astNode.type() == AstNode.NodeType.ENDTAG) && astNode.getNamespacePrefix() != null) {
                        EnumSet enumSet = faceletsLibrary == null ? ColoringAttributes.CLASS_SET : ColoringAttributes.METHOD_SET;
                        JsfHtmlExtension.this.highlight(snapshot, astNode, map, enumSet);
                    }
                }
            });
        }
    }

    private void highlight(Snapshot snapshot, AstNode astNode, Map<OffsetRange, Set<ColoringAttributes>> map, Set<ColoringAttributes> set) {
        int n = astNode.type() == AstNode.NodeType.OPEN_TAG ? 1 : 2;
        map.put(this.getDocumentOffsetRange(snapshot, astNode.startOffset(), astNode.startOffset() + astNode.name().length() + n), set);
        map.put(this.getDocumentOffsetRange(snapshot, astNode.endOffset() - 1, astNode.endOffset()), set);
    }

    private OffsetRange getDocumentOffsetRange(Snapshot snapshot, int n, int n2) {
        return new OffsetRange(snapshot.getOriginalOffset(n), snapshot.getOriginalOffset(n2));
    }

    public List<CompletionItem> completeOpenTags(HtmlExtension.CompletionContext completionContext) {
        Object object;
        Object object2;
        HtmlParserResult htmlParserResult = completionContext.getResult();
        Source source = htmlParserResult.getSnapshot().getSource();
        JsfSupport jsfSupport = JsfSupport.findFor(source);
        if (jsfSupport == null) {
            return Collections.emptyList();
        }
        Map<String, FaceletsLibrary> map = jsfSupport.getFaceletsLibraries();
        Map map2 = htmlParserResult.getNamespaces();
        ArrayList<CompletionItem> arrayList = new ArrayList<CompletionItem>();
        int n = completionContext.getPrefix().indexOf(58);
        if (n == -1) {
            for (FaceletsLibrary object3 : map.values()) {
                object2 = (String)map2.get(object3.getNamespace());
                if (object2 == null) {
                    if (object3.getDefaultPrefix() == null || !object3.getDefaultPrefix().startsWith(completionContext.getPrefix())) continue;
                    arrayList.addAll(this.queryLibrary(completionContext, object3, object3.getDefaultPrefix(), true));
                    continue;
                }
                arrayList.addAll(this.queryLibrary(completionContext, object3, (String)object2, false));
            }
        } else {
            object = completionContext.getPrefix().substring(0, n);
            String string = this.getUriForPrefix((String)object, map2);
            if (string == null) {
                for (FaceletsLibrary faceletsLibrary : map.values()) {
                    if (faceletsLibrary.getDefaultPrefix() == null || !faceletsLibrary.getDefaultPrefix().equals(object)) continue;
                    arrayList.addAll(this.queryLibrary(completionContext, faceletsLibrary, (String)object, true));
                }
            } else {
                object2 = map.get(string);
                if (object2 == null) {
                    return Collections.emptyList();
                }
                arrayList.addAll(this.queryLibrary(completionContext, (FaceletsLibrary)object2, (String)object, false));
            }
        }
        object = arrayList.iterator();
        while (object.hasNext()) {
            if (CharSequenceUtilities.startsWith((CharSequence)((CompletionItem)object.next()).getInsertPrefix(), (CharSequence)completionContext.getPrefix())) continue;
            object.remove();
        }
        return arrayList;
    }

    private String getUriForPrefix(String string, Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (!string.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    private Collection<CompletionItem> queryLibrary(HtmlExtension.CompletionContext completionContext, FaceletsLibrary faceletsLibrary, String string, boolean bl) {
        ArrayList<CompletionItem> arrayList = new ArrayList<CompletionItem>();
        for (FaceletsLibrary.NamedComponent namedComponent : faceletsLibrary.getComponents()) {
            arrayList.add((CompletionItem)JsfCompletionItem.createTag(completionContext.getCCItemStartOffset(), namedComponent, string, bl));
        }
        return arrayList;
    }

    public List<CompletionItem> completeAttributes(HtmlExtension.CompletionContext completionContext) {
        Object object;
        HtmlParserResult htmlParserResult = completionContext.getResult();
        Source source = htmlParserResult.getSnapshot().getSource();
        JsfSupport jsfSupport = JsfSupport.findFor(source);
        if (jsfSupport == null) {
            return Collections.emptyList();
        }
        Map<String, FaceletsLibrary> map = jsfSupport.getFaceletsLibraries();
        Map map2 = htmlParserResult.getNamespaces();
        ArrayList<CompletionItem> arrayList = new ArrayList<CompletionItem>();
        AstNode astNode = completionContext.getCurrentNode();
        String string = astNode.getNamespacePrefix();
        String string2 = astNode.getNameWithoutPrefix();
        String string3 = this.getUriForPrefix(string, map2);
        FaceletsLibrary faceletsLibrary = map.get(string3);
        if (faceletsLibrary == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Cannot find facelets library when completing tag " + astNode.toString() + ", namespace prefix=" + string + ", namespace = " + string3 + ", declared libraries: ");
            for (String string4 : map2.keySet()) {
                stringBuffer.append(string4);
                stringBuffer.append(" => ");
                stringBuffer.append((String)map2.get(string4));
                stringBuffer.append(", ");
            }
            stringBuffer.append(", facelets libraries: ");
            for (String string4 : map.keySet()) {
                stringBuffer.append(string4);
                stringBuffer.append(" => ");
                stringBuffer.append((String)map2.get(string4));
                stringBuffer.append(", ");
            }
            throw new IllegalStateException(stringBuffer.toString());
        }
        LibraryDescriptor.Tag tag = faceletsLibrary.getTag(string2);
        if (tag != null) {
            object = tag.getAttributes();
            Collection collection = astNode.getAttributeKeys();
            Iterator<LibraryDescriptor.Attribute> iterator = object.iterator();
            while (iterator.hasNext()) {
                LibraryDescriptor.Attribute attribute = iterator.next();
                String string5 = attribute.getName();
                if (collection.contains(string5) && !collection.contains(completionContext.getItemText())) continue;
                arrayList.add((CompletionItem)JsfCompletionItem.createAttribute(string5, completionContext.getCCItemStartOffset(), faceletsLibrary, tag, attribute));
            }
        }
        if (completionContext.getPrefix().length() > 0) {
            object = arrayList.iterator();
            while (object.hasNext()) {
                if (CharSequenceUtilities.startsWith((CharSequence)((CompletionItem)object.next()).getInsertPrefix(), (CharSequence)completionContext.getPrefix())) continue;
                object.remove();
            }
        }
        return arrayList;
    }

    public List<CompletionItem> completeAttributeValue(HtmlExtension.CompletionContext completionContext) {
        ArrayList<CompletionItem> arrayList = new ArrayList<CompletionItem>();
        if (completionContext.getAttributeName().toLowerCase(Locale.ENGLISH).startsWith("xmlns")) {
            HtmlParserResult htmlParserResult = completionContext.getResult();
            Source source = htmlParserResult.getSnapshot().getSource();
            JsfSupport jsfSupport = JsfSupport.findFor(source);
            if (jsfSupport == null) {
                return Collections.emptyList();
            }
            ArrayList<String> arrayList2 = new ArrayList<String>(jsfSupport.getFaceletsLibraries().keySet());
            arrayList2.add("http://www.w3.org/1999/xhtml");
            for (String string : arrayList2) {
                if (!string.startsWith(completionContext.getPrefix())) continue;
                arrayList.add((CompletionItem)HtmlCompletionItem.createAttributeValue((String)string, (int)completionContext.getCCItemStartOffset(), (!completionContext.isValueQuoted() ? 1 : 0) != 0));
            }
        }
        return arrayList;
    }

    public DeclarationFinder.DeclarationLocation findDeclaration(ParserResult parserResult, final int n) {
        assert (parserResult instanceof HtmlParserResult);
        HtmlParserResult htmlParserResult = (HtmlParserResult)parserResult;
        Snapshot snapshot = parserResult.getSnapshot();
        AstNode astNode = htmlParserResult.findLeaf(n);
        if (astNode.type() == AstNode.NodeType.OPEN_TAG) {
            String string = astNode.getNamespace();
            FaceletsLibrary faceletsLibrary = JsfSupport.findFor(parserResult.getSnapshot().getSource()).getFaceletsLibraries().get(string);
            if (faceletsLibrary != null && faceletsLibrary instanceof CompositeComponentLibrary) {
                String string2 = astNode.getNameWithoutPrefix();
                CompositeComponentLibrary.CompositeComponent compositeComponent = (CompositeComponentLibrary.CompositeComponent)faceletsLibrary.getComponent(string2);
                if (compositeComponent == null) {
                    return DeclarationFinder.DeclarationLocation.NONE;
                }
                FileObject fileObject = compositeComponent.getComponentModel().getSourceFile();
                int n2 = snapshot.getEmbeddedOffset(n);
                int n3 = 0;
                TokenSequence tokenSequence = snapshot.getTokenHierarchy().tokenSequence();
                tokenSequence.move(n2);
                if ((tokenSequence.moveNext() || tokenSequence.movePrevious()) && tokenSequence.token().id() != HTMLTokenId.TAG_OPEN && tokenSequence.token().id() == HTMLTokenId.ARGUMENT) {
                    final String string3 = ((Object)tokenSequence.token().text()).toString();
                    Source source = Source.create((FileObject)fileObject);
                    final int[] nArray = new int[1];
                    try {
                        ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){

                            public void run(ResultIterator resultIterator) throws Exception {
                                Parser.Result result = resultIterator.getParserResult(n);
                                if (result instanceof HtmlParserResult) {
                                    HtmlParserResult htmlParserResult = (HtmlParserResult)result;
                                    AstNode astNode = htmlParserResult.root("http://java.sun.com/jsf/composite");
                                    AstNodeUtils.visitChildren((AstNode)astNode, (AstNodeVisitor)new AstNodeVisitor(){

                                        public void visit(AstNode astNode) {
                                            if (astNode.type() == AstNode.NodeType.OPEN_TAG && astNode.getNameWithoutPrefix().equals("interface")) {
                                                for (AstNode astNode2 : astNode.children()) {
                                                    String string;
                                                    if (astNode2.type() != AstNode.NodeType.OPEN_TAG || !astNode2.getNameWithoutPrefix().equals("attribute") || (string = astNode2.getUnqotedAttributeValue("name")) == null || !string.equals(string3)) continue;
                                                    nArray[0] = astNode2.startOffset();
                                                    break;
                                                }
                                            }
                                        }
                                    });
                                }
                            }
                        });
                    }
                    catch (ParseException parseException) {
                        Exceptions.printStackTrace((Throwable)parseException);
                    }
                    n3 = nArray[0];
                }
                if (fileObject != null) {
                    return new DeclarationFinder.DeclarationLocation(fileObject, n3);
                }
            }
        }
        return DeclarationFinder.DeclarationLocation.NONE;
    }

    public OffsetRange getReferenceSpan(Document document, int n) {
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
        List list = tokenHierarchy.embeddedTokenSequences(n, false);
        TokenSequence tokenSequence = null;
        for (TokenSequence tokenSequence2 : list) {
            if (tokenSequence2.language() != HTMLTokenId.language()) continue;
            tokenSequence = tokenSequence2;
            break;
        }
        if (tokenSequence == null) {
            return OffsetRange.NONE;
        }
        tokenSequence.move(n);
        if (tokenSequence.moveNext() || tokenSequence.movePrevious()) {
            Token token = tokenSequence.token();
            if (token.id() == HTMLTokenId.TAG_OPEN) {
                if (CharSequenceUtilities.indexOf((CharSequence)token.text(), (int)58) != -1) {
                    return new OffsetRange(tokenSequence.offset(), tokenSequence.offset() + token.length());
                }
            } else if (token.id() == HTMLTokenId.ARGUMENT) {
                int n2 = tokenSequence.offset();
                int n3 = n2 + token.text().length();
                while (tokenSequence.movePrevious()) {
                    if (tokenSequence.token().id() != HTMLTokenId.TAG_OPEN) continue;
                    if (CharSequenceUtilities.indexOf((CharSequence)tokenSequence.token().text(), (int)58) == -1) break;
                    return new OffsetRange(n2, n3);
                }
            }
        }
        return OffsetRange.NONE;
    }

    public void computeErrors(HintsProvider.HintsManager hintsManager, RuleContext ruleContext, List<Hint> list, List<Error> list2) {
        list.addAll(HintsRegistry.getDefault().gatherHints(ruleContext));
    }
}

