/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor.el;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.text.BadLocationException;
import org.netbeans.editor.ext.html.parser.AstNode;
import org.netbeans.editor.ext.html.parser.AstNodeUtils;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.web.jsf.editor.JsfSupport;
import org.netbeans.modules.web.jsf.editor.el.JsfVariableContext;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsfVariablesModel {
    static boolean inTest = false;
    private static final String VARIABLE_NAME = "var";
    private static final String VALUE_NAME = "value";
    private static WeakReference<JsfVariablesModel> lastModelCache;
    private HtmlParserResult result;
    private SortedSet<JsfVariableContext> contextsList;

    public static JsfVariablesModel getModel(HtmlParserResult htmlParserResult) {
        JsfVariablesModel jsfVariablesModel;
        if (lastModelCache != null && (jsfVariablesModel = (JsfVariablesModel)lastModelCache.get()) != null && jsfVariablesModel.result == htmlParserResult) {
            return jsfVariablesModel;
        }
        jsfVariablesModel = new JsfVariablesModel(htmlParserResult);
        lastModelCache = new WeakReference<JsfVariablesModel>(jsfVariablesModel);
        return jsfVariablesModel;
    }

    private JsfVariablesModel(HtmlParserResult htmlParserResult) {
        this.result = htmlParserResult;
        this.initModel();
    }

    private void initModel() {
        JsfSupport jsfSupport = JsfSupport.findFor(this.result.getSnapshot().getSource());
        Set<String> set = inTest ? null : jsfSupport.getFaceletsLibraries().keySet();
        Set set2 = this.result.getNamespaces().keySet();
        this.contextsList = new TreeSet<JsfVariableContext>();
        for (String string : set2) {
            if (!inTest && !set.contains(string)) continue;
            AstNode astNode = this.result.root(string);
            List list = AstNodeUtils.getChildrenRecursivelly((AstNode)astNode, (AstNode.NodeFilter)new AstNode.NodeFilter(){

                public boolean accepts(AstNode astNode) {
                    return astNode.getAttribute(JsfVariablesModel.VALUE_NAME) != null && astNode.getAttribute(JsfVariablesModel.VARIABLE_NAME) != null;
                }
            }, (boolean)false);
            for (AstNode astNode2 : list) {
                AstNode.Attribute attribute = astNode2.getAttribute(VALUE_NAME);
                int n = this.result.getSnapshot().getOriginalOffset(attribute.valueOffset());
                int n2 = this.result.getSnapshot().getOriginalOffset(attribute.valueOffset() + attribute.value().length());
                if (n == -1 || n2 == -1) continue;
                try {
                    String string2 = this.result.getSnapshot().getSource().getDocument(false).getText(n, n2 - n);
                    JsfVariableContext jsfVariableContext = new JsfVariableContext(astNode2.logicalStartOffset(), astNode2.logicalEndOffset(), astNode2.getAttribute(VARIABLE_NAME).unquotedValue(), this.unquotedValue(string2));
                    this.contextsList.add(jsfVariableContext);
                }
                catch (BadLocationException badLocationException) {
                    Exceptions.printStackTrace((Throwable)badLocationException);
                }
            }
        }
    }

    private String unquotedValue(String string) {
        return this.isValueQuoted(string) ? string.substring(1, string.length() - 1) : string;
    }

    private boolean isValueQuoted(String string) {
        if (string.length() < 2) {
            return false;
        }
        return !(string.charAt(0) != '\'' && string.charAt(0) != '\"' || string.charAt(string.length() - 1) != '\'' && string.charAt(string.length() - 1) != '\"');
    }

    public SortedSet<JsfVariableContext> getContexts() {
        return this.contextsList;
    }

    public JsfVariableContext getContainingContext(int n) {
        JsfVariableContext jsfVariableContext = null;
        for (JsfVariableContext jsfVariableContext2 : this.getContexts()) {
            if (jsfVariableContext2.getFrom() <= n && jsfVariableContext2.getTo() > n) {
                jsfVariableContext = jsfVariableContext2;
            }
            if (jsfVariableContext == null || jsfVariableContext2.getTo() >= n) continue;
            break;
        }
        return jsfVariableContext;
    }

    public JsfVariableContext getPrecedingContext(int n) {
        JsfVariableContext jsfVariableContext;
        JsfVariableContext jsfVariableContext2 = null;
        Iterator iterator = this.getContexts().iterator();
        while (iterator.hasNext() && (jsfVariableContext = (JsfVariableContext)iterator.next()).getFrom() < n) {
            jsfVariableContext2 = jsfVariableContext;
        }
        return jsfVariableContext2;
    }

    List<JsfVariableContext> getAncestors(JsfVariableContext jsfVariableContext, boolean bl) {
        SortedSet<JsfVariableContext> sortedSet = this.getContexts().headSet(jsfVariableContext);
        JsfVariableContext[] jsfVariableContextArray = sortedSet.toArray(new JsfVariableContext[0]);
        ArrayList<JsfVariableContext> arrayList = new ArrayList<JsfVariableContext>();
        for (int i = jsfVariableContextArray.length - 1; i >= 0; --i) {
            JsfVariableContext jsfVariableContext2 = jsfVariableContextArray[i];
            if (jsfVariableContext2.getTo() <= jsfVariableContext.getTo()) continue;
            arrayList.add(jsfVariableContext2);
        }
        if (bl) {
            arrayList.add(0, jsfVariableContext);
        }
        return arrayList;
    }

    List<JsfVariableContext> getPredecessors(JsfVariableContext jsfVariableContext, boolean bl) {
        SortedSet<JsfVariableContext> sortedSet = this.getContexts().headSet(jsfVariableContext);
        ArrayList<JsfVariableContext> arrayList = new ArrayList<JsfVariableContext>();
        for (JsfVariableContext jsfVariableContext2 : sortedSet) {
            arrayList.add(0, jsfVariableContext2);
        }
        if (bl) {
            arrayList.add(0, jsfVariableContext);
        }
        return arrayList;
    }

    String resolveVariable(JsfVariableContext jsfVariableContext, boolean bl) {
        List<JsfVariableContext> list;
        Expression expression = Expression.parse(jsfVariableContext.getVariableValue());
        String string = expression.getPostfix() != null ? expression.getPostfix() : "";
        List<JsfVariableContext> list2 = list = bl ? this.getAncestors(jsfVariableContext, false) : this.getPredecessors(jsfVariableContext, false);
        if (list.isEmpty()) {
            return expression.getCleanExpression();
        }
        ArrayList<JsfVariableContext> arrayList = new ArrayList<JsfVariableContext>();
        for (JsfVariableContext jsfVariableContext2 : list) {
            if (!jsfVariableContext2.getVariableName().equals(expression.getBase())) continue;
            expression = Expression.parse(jsfVariableContext2.getVariableValue());
            arrayList.add(jsfVariableContext2);
        }
        Iterator<JsfVariableContext> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            JsfVariableContext jsfVariableContext2;
            jsfVariableContext2 = iterator.next();
            expression = Expression.parse(jsfVariableContext2.getVariableValue());
            if (iterator.hasNext()) {
                string = expression.getPostfix() + "." + string;
                continue;
            }
            string = expression.getCleanExpression() + "." + string;
        }
        return string;
    }

    public String resolveExpression(String string, int n, boolean bl) {
        JsfVariableContext jsfVariableContext;
        Expression expression = Expression.parse(string);
        JsfVariableContext jsfVariableContext2 = jsfVariableContext = bl ? this.getContainingContext(n) : this.getPrecedingContext(n);
        if (jsfVariableContext == null) {
            return null;
        }
        List<JsfVariableContext> list = bl ? this.getAncestors(jsfVariableContext, true) : this.getPredecessors(jsfVariableContext, true);
        JsfVariableContext jsfVariableContext3 = null;
        for (JsfVariableContext jsfVariableContext4 : list) {
            if (!jsfVariableContext4.getVariableName().equals(expression.getBase())) continue;
            jsfVariableContext3 = jsfVariableContext4;
            break;
        }
        if (jsfVariableContext3 == null) {
            return null;
        }
        return this.resolveVariable(jsfVariableContext3, bl) + (expression.getPostfix() != null ? "." + expression.getPostfix() : "");
    }

    public List<JsfVariableContext> getAllAvailableVariables(int n, boolean bl) {
        JsfVariableContext jsfVariableContext;
        ArrayList<JsfVariableContext> arrayList = new ArrayList<JsfVariableContext>();
        JsfVariableContext jsfVariableContext2 = jsfVariableContext = bl ? this.getContainingContext(n) : this.getPrecedingContext(n);
        if (jsfVariableContext == null) {
            return arrayList;
        }
        List<JsfVariableContext> list = bl ? this.getAncestors(jsfVariableContext, true) : this.getPredecessors(jsfVariableContext, true);
        for (JsfVariableContext jsfVariableContext3 : list) {
            jsfVariableContext3.setResolvedType(this.resolveVariable(jsfVariableContext3, bl));
            arrayList.add(jsfVariableContext3);
        }
        return arrayList;
    }

    private static class Expression {
        private String base;
        private String postfix;
        private String expression;

        public static Expression parse(String string) {
            return new Expression(string);
        }

        private Expression(String string) {
            if ((string.charAt(0) == '#' || string.charAt(0) == '$') && string.charAt(1) == '{') {
                string = string.substring(2);
            }
            if (string.charAt(string.length() - 1) == '}') {
                string = string.substring(0, string.length() - 1);
            }
            this.expression = string;
            int n = string.indexOf(46);
            this.base = n == -1 ? string : string.substring(0, n);
            this.postfix = n == -1 ? null : string.substring(n + 1);
        }

        public String getCleanExpression() {
            return this.expression;
        }

        public String getBase() {
            return this.base;
        }

        public String getPostfix() {
            return this.postfix;
        }

        public String toString() {
            return super.toString() + " (base=" + this.base + ", postfix=" + this.postfix;
        }
    }
}

