/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor.index;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.indexing.BinaryIndexer;
import org.netbeans.modules.parsing.spi.indexing.BinaryIndexerFactory;
import org.netbeans.modules.parsing.spi.indexing.Context;
import org.netbeans.modules.parsing.spi.indexing.support.IndexDocument;
import org.netbeans.modules.parsing.spi.indexing.support.IndexingSupport;
import org.netbeans.modules.web.jsf.editor.facelets.FaceletsLibraryDescriptor;
import org.netbeans.modules.web.jsf.editor.index.CompositeComponentModel;
import org.netbeans.modules.web.jsf.editor.index.JsfPageModelFactory;
import org.netbeans.modules.web.jsf.editor.tld.TldLibrary;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsfBinaryIndexer
extends BinaryIndexer {
    static final String INDEXER_NAME = "jsfBinary";
    static final int INDEX_VERSION = 5;
    static final String TLD_LIBRARY_MARK_KEY = "tagLibraryDescriptor";
    static final String FACELETS_LIBRARY_MARK_KEY = "faceletsLibraryDescriptor";
    static final String LIBRARY_NAMESPACE_KEY = "namespace";
    private static final String TLD_LIB_SUFFIX = ".tld";
    private static final String FACELETS_LIB_SUFFIX = ".taglib.xml";
    private static final Logger LOGGER = Logger.getLogger(JsfBinaryIndexer.class.getSimpleName());

    protected void index(Context context) {
        LOGGER.log(Level.FINE, "indexing " + context.getRoot());
        if (context.getRoot() == null) {
            return;
        }
        this.processTlds(context);
        this.processFaceletsLibraryDescriptors(context);
        this.processFaceletsCompositeLibraries(context);
    }

    private void processTlds(Context context) {
        FileObject fileObject = context.getRoot();
        for (FileObject fileObject2 : JsfBinaryIndexer.findLibraryDescriptors(fileObject, TLD_LIB_SUFFIX)) {
            try {
                String string = TldLibrary.parseNamespace(fileObject2.getInputStream());
                if (string == null) continue;
                IndexingSupport indexingSupport = IndexingSupport.getInstance((Context)context);
                IndexDocument indexDocument = indexingSupport.createDocument(fileObject2);
                indexDocument.addPair(LIBRARY_NAMESPACE_KEY, string, true, true);
                indexDocument.addPair(TLD_LIBRARY_MARK_KEY, Boolean.TRUE.toString(), true, true);
                indexingSupport.addDocument(indexDocument);
                LOGGER.log(Level.FINE, "The file " + fileObject2 + " indexed as a TLD (namespace=" + string + ")");
            }
            catch (FileNotFoundException fileNotFoundException) {
                Exceptions.printStackTrace((Throwable)fileNotFoundException);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    private void processFaceletsLibraryDescriptors(Context context) {
        FileObject fileObject = context.getRoot();
        for (FileObject fileObject2 : JsfBinaryIndexer.findLibraryDescriptors(fileObject, FACELETS_LIB_SUFFIX)) {
            try {
                String string = FaceletsLibraryDescriptor.parseNamespace(fileObject2.getInputStream());
                if (string == null) continue;
                IndexingSupport indexingSupport = IndexingSupport.getInstance((Context)context);
                IndexDocument indexDocument = indexingSupport.createDocument(fileObject2);
                indexDocument.addPair(LIBRARY_NAMESPACE_KEY, string, true, true);
                indexDocument.addPair(FACELETS_LIBRARY_MARK_KEY, Boolean.TRUE.toString(), true, true);
                indexingSupport.addDocument(indexDocument);
                LOGGER.log(Level.FINE, "The file " + fileObject2 + " indexed as a Facelets Library Descriptor");
            }
            catch (FileNotFoundException fileNotFoundException) {
                Exceptions.printStackTrace((Throwable)fileNotFoundException);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    private void processFaceletsCompositeLibraries(Context context) {
        FileObject fileObject = context.getRoot().getFileObject("META-INF/resources");
        if (fileObject != null) {
            LOGGER.log(Level.FINE, "Composite Libraries Scan: META-INF/resources folder found");
            try {
                Enumeration enumeration = fileObject.getFolders(false);
                final IndexingSupport indexingSupport = IndexingSupport.getInstance((Context)context);
                final JsfPageModelFactory jsfPageModelFactory = JsfPageModelFactory.getFactory(CompositeComponentModel.Factory.class);
                while (enumeration.hasMoreElements()) {
                    FileObject fileObject2 = (FileObject)enumeration.nextElement();
                    for (final FileObject fileObject3 : fileObject2.getChildren()) {
                        if (!fileObject3.getExt().equalsIgnoreCase("xhtml")) continue;
                        LOGGER.log(Level.FINE, "Composite Libraries Scan: found " + fileObject3);
                        Source source = Source.create((FileObject)fileObject3);
                        try {
                            ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){

                                public void run(ResultIterator resultIterator) throws Exception {
                                    for (Embedding embedding : resultIterator.getEmbeddings()) {
                                        HtmlParserResult htmlParserResult;
                                        CompositeComponentModel compositeComponentModel;
                                        if (!embedding.getMimeType().equals("text/html") || (compositeComponentModel = (CompositeComponentModel)jsfPageModelFactory.getModel(htmlParserResult = (HtmlParserResult)resultIterator.getResultIterator(embedding).getParserResult())) == null) continue;
                                        IndexDocument indexDocument = indexingSupport.createDocument(fileObject3);
                                        compositeComponentModel.storeToIndex(indexDocument);
                                        indexingSupport.addDocument(indexDocument);
                                        LOGGER.log(Level.FINE, "Composite Libraries Scan: Model created for file " + fileObject3);
                                    }
                                }
                            });
                        }
                        catch (ParseException parseException) {
                            Exceptions.printStackTrace((Throwable)parseException);
                        }
                    }
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    public static Collection<FileObject> findLibraryDescriptors(FileObject fileObject, String string) {
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        Enumeration enumeration = fileObject.getChildren(true);
        while (enumeration.hasMoreElements()) {
            FileObject fileObject2 = (FileObject)enumeration.nextElement();
            if (!fileObject2.getNameExt().toLowerCase(Locale.US).endsWith(string)) continue;
            arrayList.add(fileObject2);
        }
        return arrayList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    extends BinaryIndexerFactory {
        public BinaryIndexer createIndexer() {
            return new JsfBinaryIndexer();
        }

        public void rootsRemoved(Iterable<? extends URL> iterable) {
        }

        public String getIndexerName() {
            return JsfBinaryIndexer.INDEXER_NAME;
        }

        public int getIndexVersion() {
            return 5;
        }
    }
}

