/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor.tld;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.api.xml.services.UserCatalog;
import org.netbeans.modules.web.jsf.editor.facelets.DefaultFaceletLibraries;
import org.netbeans.modules.web.jsf.editor.tld.LibraryDescriptor;
import org.netbeans.modules.web.jsf.editor.tld.LibraryDescriptorException;
import org.openide.filesystems.FileObject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class TldLibrary
extends LibraryDescriptor {
    static TldLibrary create(FileObject fileObject) throws LibraryDescriptorException {
        return new TldLibrary(fileObject);
    }

    static TldLibrary create(InputStream inputStream) throws LibraryDescriptorException {
        return new TldLibrary(inputStream);
    }

    public TldLibrary() {
    }

    private TldLibrary(FileObject fileObject) throws LibraryDescriptorException {
        super(fileObject);
        this.parseLibrary();
    }

    private TldLibrary(InputStream inputStream) throws LibraryDescriptorException {
        super(inputStream);
        this.parseLibrary(inputStream);
    }

    public static String parseNamespace(InputStream inputStream) {
        return TldLibrary.parseNamespace(inputStream, "taglib", "uri");
    }

    protected void parseLibrary(InputStream inputStream) throws LibraryDescriptorException {
        try {
            NodeList nodeList;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            InputSource inputSource = new InputSource(inputStream);
            inputSource.setEncoding("UTF-8");
            documentBuilder.setEntityResolver(UserCatalog.getDefault().getEntityResolver());
            Document document = documentBuilder.parse(inputSource);
            Node node = TldLibrary.getNodeByName(document, "taglib");
            this.prefix = TldLibrary.getTextContent(node, "short-name");
            if (this.prefix == null) {
                this.prefix = "";
            }
            this.uri = TldLibrary.getTextContent(node, "uri");
            if (this.uri == null) {
                throw new LibraryDescriptorException("Missing uri entry in " + this.getDefinitionFile().getPath() + " library.", null);
            }
            this.displayName = TldLibrary.getTextContent(node, "display-name");
            if (this.displayName == null) {
                this.displayName = DefaultFaceletLibraries.getLibraryDisplayName(this.uri);
                if (this.displayName == null) {
                    this.displayName = this.getDefinitionFile().getNameExt();
                }
            }
            if ((nodeList = document.getElementsByTagName("tag")) != null) {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node2 = nodeList.item(i);
                    String string = TldLibrary.getTextContent(node2, "name");
                    String string2 = TldLibrary.getTextContent(node2, "description");
                    HashMap<String, LibraryDescriptor.Attribute> hashMap = new HashMap<String, LibraryDescriptor.Attribute>();
                    for (Node node3 : TldLibrary.getNodesByName(node2, "attribute")) {
                        String string3 = TldLibrary.getTextContent(node3, "name");
                        String string4 = TldLibrary.getTextContent(node3, "description");
                        boolean bl = Boolean.parseBoolean(TldLibrary.getTextContent(node3, "required"));
                        hashMap.put(string3, new LibraryDescriptor.Attribute(string3, string4, bl));
                    }
                    this.tags.put(string, new LibraryDescriptor.TagImpl(string, string2, hashMap));
                }
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new LibraryDescriptorException("Error parsing TLD library: ", parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new LibraryDescriptorException("Error parsing TLD library: ", sAXException);
        }
        catch (IOException iOException) {
            throw new LibraryDescriptorException("Error parsing TLD library: ", iOException);
        }
    }
}

