/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer;

import java.util.Set;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.editor.util.ArrayUtilities;
import org.netbeans.lib.lexer.EmbeddedTokenList;
import org.netbeans.lib.lexer.EmbeddingContainer;
import org.netbeans.lib.lexer.JoinTokenList;
import org.netbeans.lib.lexer.LanguageManager;
import org.netbeans.lib.lexer.LanguageOperation;
import org.netbeans.lib.lexer.LexerApiPackageAccessor;
import org.netbeans.lib.lexer.LexerSpiPackageAccessor;
import org.netbeans.lib.lexer.TokenIdImpl;
import org.netbeans.lib.lexer.TokenList;
import org.netbeans.lib.lexer.TokenOrEmbedding;
import org.netbeans.lib.lexer.inc.MutableTokenList;
import org.netbeans.lib.lexer.inc.SnapshotTokenList;
import org.netbeans.lib.lexer.inc.TokenHierarchyEventInfo;
import org.netbeans.lib.lexer.token.AbstractToken;
import org.netbeans.lib.lexer.token.TextToken;
import org.netbeans.spi.lexer.LanguageEmbedding;
import org.netbeans.spi.lexer.LanguageHierarchy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LexerUtilsConstants {
    public static final int MAX_FLY_SEQUENCE_LENGTH = 5;
    public static final int MOD_COUNT_IMMUTABLE_INPUT = -1;
    public static final int MOD_COUNT_REMOVED = -2;
    public static final int MAX_CACHED_TOKEN_LENGTH = 200;
    public static final short CACHE_TOKEN_TO_STRING_THRESHOLD = 900;
    public static final short INPUT_TEXT_STRING_THRESHOLD = 300;
    public static final short TOKEN_LENGTH_STRING_CREATION_FACTOR = 50;
    public static final int READER_TEXT_BUFFER_SIZE = 4096;
    public static final AbstractToken<?> SKIP_TOKEN = new TextToken<TokenIdImpl>(new TokenIdImpl("skip-token-id; special id of TokenFactory.SKIP_TOKEN;  It should never be part of token sequence", 0, null), "");
    public static final int MOD_COUNT_EMBEDDED_INITIAL = -3;

    public static void tokenLengthZeroOrNegative(int n) {
        if (n == 0) {
            throw new IllegalArgumentException("Tokens with zero length are not supported by the framework. Fix the lexer.");
        }
        throw new IllegalArgumentException("Negative token length " + n);
    }

    public static void throwFlyTokenProhibited() {
        throw new IllegalStateException("Flyweight token created but prohibited. Lexer needs to check lexerInput.isFlyTokenAllowed().");
    }

    public static void throwBranchTokenFlyProhibited(AbstractToken abstractToken) {
        throw new IllegalStateException("Language embedding cannot be created for flyweight token=" + abstractToken + "\nFix the lexer to not create flyweight token instance when" + " language embedding exists for the token.");
    }

    public static void checkValidBackup(int n, int n2) {
        if (n > n2) {
            throw new IndexOutOfBoundsException("Cannot backup " + n + " characters. Maximum: " + n2 + '.');
        }
    }

    public static <T extends TokenId> Language<T> innerLanguage(LanguagePath languagePath) {
        Language<?> language = languagePath.innerLanguage();
        return language;
    }

    public static <T extends TokenId> LanguageHierarchy<T> innerLanguageHierarchy(LanguagePath languagePath) {
        Language<T> language = LexerUtilsConstants.innerLanguage(languagePath);
        return LexerApiPackageAccessor.get().languageHierarchy(language);
    }

    public static <T extends TokenId> LanguageOperation<T> innerLanguageOperation(LanguagePath languagePath) {
        Language<T> language = LexerUtilsConstants.innerLanguage(languagePath);
        return LexerApiPackageAccessor.get().languageOperation(language);
    }

    public static <T extends TokenId> LanguageEmbedding<?> findEmbedding(LanguageHierarchy<T> languageHierarchy, AbstractToken<T> abstractToken, LanguagePath languagePath, InputAttributes inputAttributes) {
        LanguageEmbedding<?> languageEmbedding = LexerSpiPackageAccessor.get().embedding(languageHierarchy, abstractToken, languagePath, inputAttributes);
        if (languageEmbedding == null) {
            languageEmbedding = LanguageManager.getInstance().findLanguageEmbedding(abstractToken, languagePath, inputAttributes);
        }
        return languageEmbedding;
    }

    public static int maxLanguagePathSize(Set<LanguagePath> set) {
        int n = 0;
        for (LanguagePath languagePath : set) {
            n = Math.max(languagePath.size(), n);
        }
        return n;
    }

    public static int[] tokenIndexLazyTokenCreation(TokenList<?> tokenList, int n) {
        int n2;
        int n3 = tokenList.tokenCountCurrent();
        if (n3 == 0) {
            if (tokenList.tokenOrEmbedding(0) == null) {
                return new int[]{-1, 0};
            }
            n3 = tokenList.tokenCountCurrent();
        }
        if (n > (n2 = tokenList.tokenOffset(n3 - 1))) {
            int n4 = tokenList.tokenOrEmbedding(n3 - 1).token().length();
            while (n >= n2 + n4) {
                TokenOrEmbedding<?> tokenOrEmbedding = tokenList.tokenOrEmbedding(n3);
                if (tokenOrEmbedding != null) {
                    AbstractToken<?> abstractToken = tokenOrEmbedding.token();
                    n2 = abstractToken.isFlyweight() ? (n2 += n4) : tokenList.tokenOffset(n3);
                    n4 = abstractToken.length();
                    ++n3;
                    continue;
                }
                return new int[]{n3, n2 + n4};
            }
            return new int[]{n3 - 1, n2};
        }
        return LexerUtilsConstants.tokenIndexBinSearch(tokenList, n, n3);
    }

    public static int[] tokenIndexBinSearch(TokenList<?> tokenList, int n, int n2) {
        int n3 = 0;
        int n4 = n2 - 1;
        int n5 = -1;
        int n6 = -1;
        while (n3 <= n4) {
            n5 = n3 + n4 >>> 1;
            n6 = tokenList.tokenOffset(n5);
            if (n6 < n) {
                n3 = n5 + 1;
                continue;
            }
            if (n6 > n) {
                n4 = n5 - 1;
                continue;
            }
            return new int[]{n5, n6};
        }
        if (n4 >= 0) {
            if (n3 == n2) {
                AbstractToken<?> abstractToken = tokenList.tokenOrEmbedding(n4).token();
                if (n >= n6 + abstractToken.length()) {
                    n6 += abstractToken.length();
                } else if (n5 != n4) {
                    n6 = tokenList.tokenOffset(n4);
                }
            } else if (n5 != n4) {
                n6 = tokenList.tokenOffset(n4);
            }
        } else {
            if (n2 == 0) {
                return new int[]{-1, 0};
            }
            n4 = 0;
        }
        return new int[]{++n4, n6};
    }

    public static int updatedStartOffset(EmbeddedTokenList<?> embeddedTokenList, TokenHierarchyEventInfo tokenHierarchyEventInfo) {
        embeddedTokenList.embeddingContainer().updateStatusUnsync();
        int n = embeddedTokenList.startOffset();
        return embeddedTokenList.isRemoved() && n > tokenHierarchyEventInfo.modOffset() ? Math.max(n - tokenHierarchyEventInfo.removedLength(), tokenHierarchyEventInfo.modOffset()) : n;
    }

    public static <T extends TokenId> StringBuilder appendTokenList(StringBuilder stringBuilder, TokenList<T> tokenList) {
        return LexerUtilsConstants.appendTokenList(stringBuilder, tokenList, -1, 0, Integer.MAX_VALUE, true, 0, true);
    }

    public static <T extends TokenId> StringBuilder appendTokenListIndented(StringBuilder stringBuilder, TokenList<T> tokenList, int n) {
        return LexerUtilsConstants.appendTokenList(stringBuilder, tokenList, -1, 0, Integer.MAX_VALUE, false, n, true);
    }

    public static <T extends TokenId> StringBuilder appendTokenList(StringBuilder stringBuilder, TokenList<T> tokenList, int n, int n2, int n3, boolean bl, int n4, boolean bl2) {
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder(200);
        }
        TokenHierarchy<?> tokenHierarchy = tokenList instanceof SnapshotTokenList ? ((SnapshotTokenList)tokenList).snapshot().tokenHierarchy() : null;
        n3 = Math.min(tokenList.tokenCountCurrent(), n3);
        int n5 = ArrayUtilities.digitCount((int)(n3 - 1));
        for (int i = Math.max(n2, 0); i < n3; ++i) {
            ArrayUtilities.appendSpaces((StringBuilder)stringBuilder, (int)n4);
            stringBuilder.append(i == n ? (char)'*' : 'T');
            ArrayUtilities.appendBracketedIndex((StringBuilder)stringBuilder, (int)i, (int)n5);
            LexerUtilsConstants.appendTokenInfo(stringBuilder, tokenList, i, tokenHierarchy, bl, n4, bl2);
            stringBuilder.append('\n');
        }
        return stringBuilder;
    }

    public static boolean statesEqual(Object object, Object object2) {
        return object == null && object2 == null || object != null && object.equals(object2);
    }

    public static String idToString(TokenId tokenId) {
        return tokenId.name() + '[' + tokenId.ordinal() + ']';
    }

    public static <T extends TokenId> void appendTokenInfo(StringBuilder stringBuilder, TokenList<T> tokenList, int n, TokenHierarchy tokenHierarchy, boolean bl, int n2, boolean bl2) {
        try {
            LexerUtilsConstants.appendTokenInfo(stringBuilder, tokenList.tokenOrEmbedding(n), tokenList.lookahead(n), tokenList.state(n), tokenHierarchy, bl, n2, bl2);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            tokenList.lookahead(n);
            System.err.println("Index=" + n + ", tokenCount=" + tokenList.tokenCount() + ", cls=" + tokenList.getClass());
            throw indexOutOfBoundsException;
        }
    }

    public static <T extends TokenId> void appendTokenInfo(StringBuilder stringBuilder, TokenOrEmbedding<T> tokenOrEmbedding, int n, Object object, TokenHierarchy<?> tokenHierarchy, boolean bl, int n2, boolean bl2) {
        if (tokenOrEmbedding == null) {
            stringBuilder.append("<NULL-TOKEN>");
        } else {
            EmbeddingContainer<T> embeddingContainer = tokenOrEmbedding.embedding();
            AbstractToken<T> abstractToken = tokenOrEmbedding.token();
            abstractToken.dumpInfo(stringBuilder, tokenHierarchy, bl2, true, n2);
            LexerUtilsConstants.appendLAState(stringBuilder, n, object);
            stringBuilder.append(", ");
            LexerUtilsConstants.appendIdentityHashCode(stringBuilder, abstractToken);
            if (embeddingContainer != null) {
                n2 += 4;
                stringBuilder.append("; EC-");
                LexerUtilsConstants.appendIdentityHashCode(stringBuilder, embeddingContainer);
                EmbeddedTokenList<?> embeddedTokenList = embeddingContainer.firstEmbeddedTokenList();
                int n3 = 0;
                while (embeddedTokenList != null) {
                    stringBuilder.append('\n');
                    ArrayUtilities.appendSpaces((StringBuilder)stringBuilder, (int)n2);
                    stringBuilder.append("Embedding[").append(n3).append("]: \"").append(embeddedTokenList.languagePath().mimePath()).append("\"\n");
                    if (bl) {
                        LexerUtilsConstants.appendTokenList(stringBuilder, embeddedTokenList, -1, 0, Integer.MAX_VALUE, bl, n2, true);
                    }
                    embeddedTokenList = embeddedTokenList.nextEmbeddedTokenList();
                    ++n3;
                }
            }
        }
    }

    public static void appendIdentityHashCode(StringBuilder stringBuilder, Object object) {
        stringBuilder.append("IHC=");
        stringBuilder.append(System.identityHashCode(object));
    }

    public static void appendLAState(StringBuilder stringBuilder, TokenList<?> tokenList, int n) {
        LexerUtilsConstants.appendLAState(stringBuilder, tokenList.lookahead(n), tokenList.state(n));
    }

    public static void appendLAState(StringBuilder stringBuilder, int n, Object object) {
        if (n > 0) {
            stringBuilder.append(", la=");
            stringBuilder.append(n);
        }
        if (object != null) {
            stringBuilder.append(", st=");
            stringBuilder.append(object);
        }
    }

    public static String checkConsistencyTokenList(TokenList<?> tokenList, boolean bl) {
        int n;
        int n2;
        int n3 = tokenList.tokenCountCurrent();
        boolean bl2 = tokenList.isContinuous();
        if (tokenList instanceof EmbeddedTokenList) {
            ((EmbeddedTokenList)tokenList).embeddingContainer().updateStatus();
        }
        int n4 = n2 = tokenList.startOffset();
        for (n = 0; n < n3; ++n) {
            int n5;
            TokenOrEmbedding<?> tokenOrEmbedding = tokenList.tokenOrEmbedding(n);
            if (tokenOrEmbedding == null) {
                tokenOrEmbedding = tokenList.tokenOrEmbedding(n);
                return LexerUtilsConstants.dumpContext("Null token", tokenList, n);
            }
            AbstractToken<?> abstractToken = tokenOrEmbedding.token();
            if (abstractToken.isRemoved()) {
                return LexerUtilsConstants.dumpContext("Token is removed", tokenList, n);
            }
            if (n == 0 && bl2 && n3 > 0 && !abstractToken.isFlyweight() && abstractToken.offset(null) != tokenList.startOffset()) {
                return LexerUtilsConstants.dumpContext("firstToken.offset()=" + abstractToken.offset(null) + " != tokenList.startOffset()=" + tokenList.startOffset(), tokenList, n);
            }
            if (!abstractToken.isFlyweight() && abstractToken.tokenList() != tokenList && !(tokenList instanceof JoinTokenList)) {
                return LexerUtilsConstants.dumpContext("Invalid token.tokenList()=" + abstractToken.tokenList(), tokenList, n);
            }
            if (abstractToken.text() == null) {
                return LexerUtilsConstants.dumpContext("Null token.text()", tokenList, n);
            }
            if (((Object)abstractToken.text()).toString() == null) {
                return LexerUtilsConstants.dumpContext("Null token.text().toString()", tokenList, n);
            }
            int n6 = n5 = abstractToken.isFlyweight() ? n4 : abstractToken.offset(null);
            if (n5 < 0) {
                return LexerUtilsConstants.dumpContext("Token offset=" + n5 + " < 0", tokenList, n);
            }
            if (n5 < n4) {
                return LexerUtilsConstants.dumpContext("Token offset=" + n5 + " < lastOffset=" + n4, tokenList, n);
            }
            if (n5 > n4 && bl2) {
                return LexerUtilsConstants.dumpContext("Gap between tokens; offset=" + n5 + ", lastOffset=" + n4, tokenList, n);
            }
            n4 = n5 + abstractToken.length();
            EmbeddingContainer<?> embeddingContainer = tokenOrEmbedding.embedding();
            if (embeddingContainer == null || !bl) continue;
            for (EmbeddedTokenList<?> embeddedTokenList = embeddingContainer.firstEmbeddedTokenList(); embeddedTokenList != null; embeddedTokenList = embeddedTokenList.nextEmbeddedTokenList()) {
                String string = LexerUtilsConstants.checkConsistencyTokenList(embeddedTokenList, bl);
                if (string == null) continue;
                return string;
            }
        }
        if (tokenList instanceof MutableTokenList && ((MutableTokenList)tokenList).isFullyLexed()) {
            n = tokenList.endOffset();
            if (n2 != n && n3 == 0) {
                return LexerUtilsConstants.dumpContext("Non-empty token list does not contain any tokens", tokenList, 0);
            }
            if (bl2 && n4 != n) {
                return LexerUtilsConstants.dumpContext("lastOffset=" + n4 + " != endOffset=" + n, tokenList, n3);
            }
        }
        return null;
    }

    private static String dumpContext(String string, TokenList<?> tokenList, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append(" at index=");
        stringBuilder.append(n);
        stringBuilder.append(" of tokens of language-path ");
        stringBuilder.append(tokenList.languagePath().mimePath());
        stringBuilder.append(", ").append(tokenList.getClass());
        stringBuilder.append('\n');
        LexerUtilsConstants.appendTokenList(stringBuilder, tokenList, n, n - 2, n + 3, false, 0, true);
        return stringBuilder.toString();
    }

    private LexerUtilsConstants() {
    }
}

