/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.csl.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenChange;
import org.netbeans.api.lexer.TokenHierarchyEvent;
import org.netbeans.api.lexer.TokenHierarchyEventType;
import org.netbeans.api.lexer.TokenHierarchyListener;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.api.OffsetRange;

public final class EditHistory
implements DocumentListener,
TokenHierarchyListener {
    private static final Object ADDED = new Object();
    private static final Object REMOVED = new Object();
    private int start = -1;
    private int originalEnd = -1;
    private int editedEnd = -1;
    private List<Edit> edits = new ArrayList<Edit>(4);
    private Map<TokenId, Object> tokenIds = new IdentityHashMap<TokenId, Object>();
    private int delta = 0;
    private boolean valid = true;
    EditHistory previous;
    private int version = -1;
    private static final int MAX_KEEP = 15;

    public int getStart() {
        return this.start;
    }

    public boolean isInDamagedRegion(int n) {
        if (this.start == -1) {
            return false;
        }
        return n >= this.start && n <= this.editedEnd;
    }

    public boolean isInDamagedRegion(OffsetRange offsetRange) {
        if (this.start == -1) {
            return false;
        }
        return offsetRange.getStart() < this.editedEnd && offsetRange.getEnd() > this.start;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean bl) {
        this.valid = bl;
    }

    public int getEditedSize() {
        return this.editedEnd - this.start;
    }

    public int getOriginalEnd() {
        return this.originalEnd;
    }

    public int getEditedEnd() {
        return this.editedEnd;
    }

    public int getSizeDelta() {
        return this.delta;
    }

    public int getOriginalSize() {
        return this.originalEnd - this.start;
    }

    public int getVersion() {
        return this.version;
    }

    public boolean wasModified(@NullAllowed TokenId tokenId) {
        if (tokenId == null) {
            return false;
        }
        return this.tokenIds.containsKey(tokenId);
    }

    public int convertOriginalToEdited(int n) {
        if (this.start == -1 || n <= this.start) {
            return n;
        }
        if (n >= this.originalEnd) {
            return n + this.delta;
        }
        List<Edit> list = this.edits;
        int n2 = list.size();
        if (n2 == 0) {
            return n;
        }
        for (int i = 0; i < n2; ++i) {
            Edit edit = list.get(i);
            if (n <= edit.offset) continue;
            if (edit.insert) {
                n += edit.len;
                continue;
            }
            if (n < edit.offset + edit.len) {
                n = edit.offset;
                continue;
            }
            n -= edit.len;
        }
        if (n < 0) {
            n = 0;
        }
        return n;
    }

    public int convertEditedToOriginal(int n) {
        List<Edit> list = this.edits;
        int n2 = list.size();
        if (n2 == 0) {
            return n;
        }
        for (int i = n2 - 1; i >= 0; --i) {
            Edit edit = list.get(i);
            if (edit.insert) {
                if (n <= edit.offset) continue;
                if (n < edit.offset + edit.len) {
                    n = edit.offset;
                    continue;
                }
                n -= edit.len;
                continue;
            }
            if (n < edit.offset) continue;
            n += edit.len;
        }
        if (n < 0) {
            n = 0;
        }
        return n;
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        int n = documentEvent.getOffset();
        int n2 = documentEvent.getLength();
        this.insertUpdate(n, n2);
    }

    private void insertUpdate(int n, int n2) {
        this.edits.add(new Edit(n, n2, true));
        if (this.start == -1) {
            this.start = n;
            this.originalEnd = n;
            this.editedEnd = n + n2;
            this.delta = n2;
        } else {
            int n3 = this.convertEditedToOriginal(n);
            if (n3 > this.originalEnd) {
                this.originalEnd = n3;
            }
            if (n < this.start) {
                this.start = n;
            }
            this.editedEnd = n > this.editedEnd ? n + n2 : (this.editedEnd += n2);
            this.delta = this.getEditedSize() - this.getOriginalSize();
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        int n = documentEvent.getOffset();
        int n2 = documentEvent.getLength();
        this.removeUpdate(n, n2);
    }

    private void removeUpdate(int n, int n2) {
        this.edits.add(new Edit(n, n2, false));
        if (this.start == -1) {
            this.start = n;
            this.originalEnd = n + n2;
            this.editedEnd = n;
            this.delta = -n2;
        } else {
            int n3 = this.convertEditedToOriginal(n);
            if (n3 > this.originalEnd) {
                this.originalEnd = n3;
            } else if (n + n2 > this.editedEnd) {
                this.originalEnd += n + n2 - this.editedEnd;
            }
            if (n > this.editedEnd) {
                this.editedEnd = n;
            } else {
                this.editedEnd -= n2;
                if (this.editedEnd < n) {
                    this.editedEnd = n;
                }
            }
            if (n < this.start) {
                this.start = n;
            }
            this.delta = this.getEditedSize() - this.getOriginalSize();
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void tokenHierarchyChanged(TokenHierarchyEvent tokenHierarchyEvent) {
        TokenHierarchyEventType tokenHierarchyEventType = tokenHierarchyEvent.type();
        if (tokenHierarchyEventType == TokenHierarchyEventType.MODIFICATION) {
            this.changed(tokenHierarchyEvent.tokenChange());
        } else if (tokenHierarchyEventType == TokenHierarchyEventType.REBUILD) {
            this.valid = false;
        }
    }

    public void changed(TokenChange tokenChange) {
        TokenSequence tokenSequence;
        TokenSequence tokenSequence2;
        int n = tokenChange.embeddedChangeCount();
        for (int i = 0; i < n; ++i) {
            this.changed(tokenChange.embeddedChange(i));
        }
        if (tokenChange.removedTokenCount() > 0 && (tokenSequence2 = tokenChange.removedTokenSequence()) != null) {
            tokenSequence2.moveStart();
            while (tokenSequence2.moveNext()) {
                Token token = tokenSequence2.token();
                if (token == null) continue;
                TokenId tokenId = token.id();
                this.tokenIds.put(tokenId, REMOVED);
            }
        }
        if (tokenChange.addedTokenCount() > 0 && (tokenSequence = tokenChange.currentTokenSequence()) != null) {
            tokenSequence.moveIndex(tokenChange.index());
            int n2 = tokenChange.addedTokenCount();
            for (int i = 0; tokenSequence.moveNext() && i < n2; ++i) {
                Token token = tokenSequence.token();
                if (token == null) continue;
                TokenId tokenId = token.id();
                this.tokenIds.put(tokenId, ADDED);
            }
        }
    }

    public String toString() {
        return "EditHistory(version=" + this.version + ", offset=" + this.start + ", originalSize=" + this.getOriginalSize() + ", editedSize=" + this.getEditedSize() + ", delta=" + this.delta + ")";
    }

    public void add(@NonNull EditHistory editHistory) {
        editHistory.previous = this;
        editHistory.version = this.version + 1;
        if (editHistory.version % 15 == 0) {
            EditHistory editHistory2 = editHistory;
            for (int i = 0; i < 15; ++i) {
                editHistory2 = editHistory2.previous;
                if (editHistory2 != null) continue;
                return;
            }
            editHistory2.previous = null;
        }
    }

    @CheckForNull
    public static EditHistory getCombinedEdits(int n, @NonNull EditHistory editHistory) {
        if (!editHistory.isValid()) {
            return editHistory;
        }
        if (editHistory.previous == null || editHistory.version == n) {
            return null;
        }
        if (editHistory.previous.version == n) {
            return editHistory;
        }
        EditHistory editHistory2 = editHistory;
        ArrayList<EditHistory> arrayList = new ArrayList<EditHistory>();
        while (editHistory2.version != n) {
            arrayList.add(editHistory2);
            if (editHistory2.version == n) break;
            editHistory2 = editHistory2.previous;
            if (editHistory2 != null) continue;
            if (n == -1) break;
            return null;
        }
        EditHistory editHistory3 = new EditHistory();
        Collections.reverse(arrayList);
        for (EditHistory editHistory4 : arrayList) {
            for (Edit edit : editHistory4.edits) {
                if (edit.insert) {
                    editHistory3.insertUpdate(edit.offset, edit.len);
                    continue;
                }
                editHistory3.removeUpdate(edit.offset, edit.len);
            }
            editHistory3.tokenIds.putAll(editHistory4.tokenIds);
        }
        return editHistory3;
    }

    public void testHelperNotifyToken(boolean bl, TokenId tokenId) {
        if (bl) {
            this.tokenIds.put(tokenId, ADDED);
        } else {
            this.tokenIds.put(tokenId, REMOVED);
        }
    }

    private class Edit {
        private final int offset;
        private final int len;
        private final boolean insert;

        private Edit(int n, int n2, boolean bl) {
            this.offset = n;
            this.len = n2;
            this.insert = bl;
        }
    }
}

